package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class ServiceMonitorSpecFluentImpl<A extends ServiceMonitorSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServiceMonitorSpecFluent<A> {

    private List<EndpointBuilder> endpoints =  new ArrayList<EndpointBuilder>();
    private String jobLabel;
    private NamespaceSelectorBuilder namespaceSelector;
    private List<String> podTargetLabels = new ArrayList<String>();
    private Long sampleLimit;
    private LabelSelectorBuilder selector;
    private List<String> targetLabels = new ArrayList<String>();

    public ServiceMonitorSpecFluentImpl() {
    }

    public ServiceMonitorSpecFluentImpl(ServiceMonitorSpec instance) {
        this.withEndpoints(instance.getEndpoints()); 
        this.withJobLabel(instance.getJobLabel()); 
        this.withNamespaceSelector(instance.getNamespaceSelector()); 
        this.withPodTargetLabels(instance.getPodTargetLabels()); 
        this.withSampleLimit(instance.getSampleLimit()); 
        this.withSelector(instance.getSelector()); 
        this.withTargetLabels(instance.getTargetLabels()); 
    }

    public A addToEndpoints(int index,Endpoint item) {
        if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
        EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(index >= 0 ? index : _visitables.get("endpoints").size(), builder);this.endpoints.add(index >= 0 ? index : endpoints.size(), builder); return (A)this;
    }

    public A setToEndpoints(int index,Endpoint item) {
        if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
        EndpointBuilder builder = new EndpointBuilder(item);
        if (index < 0 || index >= _visitables.get("endpoints").size()) { _visitables.get("endpoints").add(builder); } else { _visitables.get("endpoints").set(index, builder);}
        if (index < 0 || index >= endpoints.size()) { endpoints.add(builder); } else { endpoints.set(index, builder);}
         return (A)this;
    }

    public A addToEndpoints(Endpoint... items) {
        if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
        for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
    }

    public A addAllToEndpoints(Collection<Endpoint> items) {
        if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
        for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
    }

    public A removeFromEndpoints(Endpoint... items) {
        for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
    }

    public A removeAllFromEndpoints(Collection<Endpoint> items) {
        for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate) {
        if (endpoints == null) return (A) this;
        final Iterator<EndpointBuilder> each = endpoints.iterator();
        final List visitables = _visitables.get("endpoints");
        while (each.hasNext()) {
          EndpointBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<Endpoint> getEndpoints() {
        return build(endpoints);
    }

    public List<Endpoint> buildEndpoints() {
        return build(endpoints);
    }

    public Endpoint buildEndpoint(int index) {
        return this.endpoints.get(index).build();
    }

    public Endpoint buildFirstEndpoint() {
        return this.endpoints.get(0).build();
    }

    public Endpoint buildLastEndpoint() {
        return this.endpoints.get(endpoints.size() - 1).build();
    }

    public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item: endpoints) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item: endpoints) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEndpoints(List<Endpoint> endpoints) {
        if (this.endpoints != null) { _visitables.get("endpoints").removeAll(this.endpoints);}
        if (endpoints != null) {this.endpoints = new ArrayList<EndpointBuilder>(); for (Endpoint item : endpoints){this.addToEndpoints(item);}} else { this.endpoints = null;} return (A) this;
    }

    public A withEndpoints(Endpoint... endpoints) {
        if (this.endpoints != null) {this.endpoints.clear();}
        if (endpoints != null) {for (Endpoint item :endpoints){ this.addToEndpoints(item);}} return (A) this;
    }

    public Boolean hasEndpoints() {
        return endpoints != null && !endpoints.isEmpty();
    }

    public ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpoint() {
        return new EndpointsNestedImpl();
    }

    public ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpointLike(Endpoint item) {
        return new EndpointsNestedImpl(-1, item);
    }

    public ServiceMonitorSpecFluent.EndpointsNested<A> setNewEndpointLike(int index,Endpoint item) {
        return new EndpointsNestedImpl(index, item);
    }

    public ServiceMonitorSpecFluent.EndpointsNested<A> editEndpoint(int index) {
        if (endpoints.size() <= index) throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
        return setNewEndpointLike(index, buildEndpoint(index));
    }

    public ServiceMonitorSpecFluent.EndpointsNested<A> editFirstEndpoint() {
        if (endpoints.size() == 0) throw new RuntimeException("Can't edit first endpoints. The list is empty.");
        return setNewEndpointLike(0, buildEndpoint(0));
    }

    public ServiceMonitorSpecFluent.EndpointsNested<A> editLastEndpoint() {
        int index = endpoints.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last endpoints. The list is empty.");
        return setNewEndpointLike(index, buildEndpoint(index));
    }

    public ServiceMonitorSpecFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        int index = -1;
        for (int i=0;i<endpoints.size();i++) { 
        if (predicate.test(endpoints.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching endpoints. No match found.");
        return setNewEndpointLike(index, buildEndpoint(index));
    }

    public String getJobLabel() {
        return this.jobLabel;
    }

    public A withJobLabel(String jobLabel) {
        this.jobLabel=jobLabel; return (A) this;
    }

    public Boolean hasJobLabel() {
        return this.jobLabel != null;
    }

    public A withNewJobLabel(String arg1) {
        return (A)withJobLabel(new String(arg1));
    }

    public A withNewJobLabel(StringBuilder arg1) {
        return (A)withJobLabel(new String(arg1));
    }

    public A withNewJobLabel(StringBuffer arg1) {
        return (A)withJobLabel(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public NamespaceSelector getNamespaceSelector() {
        return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public NamespaceSelector buildNamespaceSelector() {
        return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
        _visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector!=null){ this.namespaceSelector= new NamespaceSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} return (A) this;
    }

    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return withNewNamespaceSelectorLike(getNamespaceSelector());
    }

    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new NamespaceSelectorBuilder().build());
    }

    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
        return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
    }

    public A addToPodTargetLabels(int index,String item) {
        if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
        this.podTargetLabels.add(index, item);
        return (A)this;
    }

    public A setToPodTargetLabels(int index,String item) {
        if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
        this.podTargetLabels.set(index, item); return (A)this;
    }

    public A addToPodTargetLabels(String... items) {
        if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
        for (String item : items) {this.podTargetLabels.add(item);} return (A)this;
    }

    public A addAllToPodTargetLabels(Collection<String> items) {
        if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
        for (String item : items) {this.podTargetLabels.add(item);} return (A)this;
    }

    public A removeFromPodTargetLabels(String... items) {
        for (String item : items) {if (this.podTargetLabels!= null){ this.podTargetLabels.remove(item);}} return (A)this;
    }

    public A removeAllFromPodTargetLabels(Collection<String> items) {
        for (String item : items) {if (this.podTargetLabels!= null){ this.podTargetLabels.remove(item);}} return (A)this;
    }

    public List<String> getPodTargetLabels() {
        return this.podTargetLabels;
    }

    public String getPodTargetLabel(int index) {
        return this.podTargetLabels.get(index);
    }

    public String getFirstPodTargetLabel() {
        return this.podTargetLabels.get(0);
    }

    public String getLastPodTargetLabel() {
        return this.podTargetLabels.get(podTargetLabels.size() - 1);
    }

    public String getMatchingPodTargetLabel(Predicate<String> predicate) {
        for (String item: podTargetLabels) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingPodTargetLabel(Predicate<String> predicate) {
        for (String item: podTargetLabels) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPodTargetLabels(List<String> podTargetLabels) {
        if (this.podTargetLabels != null) { _visitables.get("podTargetLabels").removeAll(this.podTargetLabels);}
        if (podTargetLabels != null) {this.podTargetLabels = new ArrayList<String>(); for (String item : podTargetLabels){this.addToPodTargetLabels(item);}} else { this.podTargetLabels = null;} return (A) this;
    }

    public A withPodTargetLabels(String... podTargetLabels) {
        if (this.podTargetLabels != null) {this.podTargetLabels.clear();}
        if (podTargetLabels != null) {for (String item :podTargetLabels){ this.addToPodTargetLabels(item);}} return (A) this;
    }

    public Boolean hasPodTargetLabels() {
        return podTargetLabels != null && !podTargetLabels.isEmpty();
    }

    public A addNewPodTargetLabel(String arg1) {
        return (A)addToPodTargetLabels(new String(arg1));
    }

    public A addNewPodTargetLabel(StringBuilder arg1) {
        return (A)addToPodTargetLabels(new String(arg1));
    }

    public A addNewPodTargetLabel(StringBuffer arg1) {
        return (A)addToPodTargetLabels(new String(arg1));
    }

    public Long getSampleLimit() {
        return this.sampleLimit;
    }

    public A withSampleLimit(Long sampleLimit) {
        this.sampleLimit=sampleLimit; return (A) this;
    }

    public Boolean hasSampleLimit() {
        return this.sampleLimit != null;
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public LabelSelector buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(LabelSelector selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public ServiceMonitorSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public ServiceMonitorSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    public ServiceMonitorSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
    }

    public ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public A addToTargetLabels(int index,String item) {
        if (this.targetLabels == null) {this.targetLabels = new ArrayList<String>();}
        this.targetLabels.add(index, item);
        return (A)this;
    }

    public A setToTargetLabels(int index,String item) {
        if (this.targetLabels == null) {this.targetLabels = new ArrayList<String>();}
        this.targetLabels.set(index, item); return (A)this;
    }

    public A addToTargetLabels(String... items) {
        if (this.targetLabels == null) {this.targetLabels = new ArrayList<String>();}
        for (String item : items) {this.targetLabels.add(item);} return (A)this;
    }

    public A addAllToTargetLabels(Collection<String> items) {
        if (this.targetLabels == null) {this.targetLabels = new ArrayList<String>();}
        for (String item : items) {this.targetLabels.add(item);} return (A)this;
    }

    public A removeFromTargetLabels(String... items) {
        for (String item : items) {if (this.targetLabels!= null){ this.targetLabels.remove(item);}} return (A)this;
    }

    public A removeAllFromTargetLabels(Collection<String> items) {
        for (String item : items) {if (this.targetLabels!= null){ this.targetLabels.remove(item);}} return (A)this;
    }

    public List<String> getTargetLabels() {
        return this.targetLabels;
    }

    public String getTargetLabel(int index) {
        return this.targetLabels.get(index);
    }

    public String getFirstTargetLabel() {
        return this.targetLabels.get(0);
    }

    public String getLastTargetLabel() {
        return this.targetLabels.get(targetLabels.size() - 1);
    }

    public String getMatchingTargetLabel(Predicate<String> predicate) {
        for (String item: targetLabels) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingTargetLabel(Predicate<String> predicate) {
        for (String item: targetLabels) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTargetLabels(List<String> targetLabels) {
        if (this.targetLabels != null) { _visitables.get("targetLabels").removeAll(this.targetLabels);}
        if (targetLabels != null) {this.targetLabels = new ArrayList<String>(); for (String item : targetLabels){this.addToTargetLabels(item);}} else { this.targetLabels = null;} return (A) this;
    }

    public A withTargetLabels(String... targetLabels) {
        if (this.targetLabels != null) {this.targetLabels.clear();}
        if (targetLabels != null) {for (String item :targetLabels){ this.addToTargetLabels(item);}} return (A) this;
    }

    public Boolean hasTargetLabels() {
        return targetLabels != null && !targetLabels.isEmpty();
    }

    public A addNewTargetLabel(String arg1) {
        return (A)addToTargetLabels(new String(arg1));
    }

    public A addNewTargetLabel(StringBuilder arg1) {
        return (A)addToTargetLabels(new String(arg1));
    }

    public A addNewTargetLabel(StringBuffer arg1) {
        return (A)addToTargetLabels(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServiceMonitorSpecFluentImpl that = (ServiceMonitorSpecFluentImpl) o;
        if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
        if (jobLabel != null ? !jobLabel.equals(that.jobLabel) :that.jobLabel != null) return false;
        if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
        if (podTargetLabels != null ? !podTargetLabels.equals(that.podTargetLabels) :that.podTargetLabels != null) return false;
        if (sampleLimit != null ? !sampleLimit.equals(that.sampleLimit) :that.sampleLimit != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (targetLabels != null ? !targetLabels.equals(that.targetLabels) :that.targetLabels != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(endpoints,  jobLabel,  namespaceSelector,  podTargetLabels,  sampleLimit,  selector,  targetLabels,  super.hashCode());
    }

    public class EndpointsNestedImpl<N> extends EndpointFluentImpl<ServiceMonitorSpecFluent.EndpointsNested<N>> implements ServiceMonitorSpecFluent.EndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointBuilder builder;
        private final int index;

            EndpointsNestedImpl(int index,Endpoint item) {
                this.index = index;
                this.builder = new EndpointBuilder(this, item);
                        
            }

            EndpointsNestedImpl() {
                this.index = -1;
                this.builder = new EndpointBuilder(this);
                        
            }

            public N and() {
                return (N) ServiceMonitorSpecFluentImpl.this.setToEndpoints(index,builder.build());
            }

            public N endEndpoint() {
                return and();
            }
    }


    public class NamespaceSelectorNestedImpl<N> extends NamespaceSelectorFluentImpl<ServiceMonitorSpecFluent.NamespaceSelectorNested<N>> implements ServiceMonitorSpecFluent.NamespaceSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamespaceSelectorBuilder builder;

            NamespaceSelectorNestedImpl(NamespaceSelector item) {
                this.builder = new NamespaceSelectorBuilder(this, item);
                        
            }

            NamespaceSelectorNestedImpl() {
                this.builder = new NamespaceSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) ServiceMonitorSpecFluentImpl.this.withNamespaceSelector(builder.build());
            }

            public N endNamespaceSelector() {
                return and();
            }
    }


    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<ServiceMonitorSpecFluent.SelectorNested<N>> implements ServiceMonitorSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            SelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) ServiceMonitorSpecFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


}
