package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EmbeddedObjectMetadataBuilder extends EmbeddedObjectMetadataFluentImpl<EmbeddedObjectMetadataBuilder> implements VisitableBuilder<EmbeddedObjectMetadata,EmbeddedObjectMetadataBuilder> {

    EmbeddedObjectMetadataFluent<?> fluent;
    Boolean validationEnabled;

    public EmbeddedObjectMetadataBuilder() {
        this(true);
    }

    public EmbeddedObjectMetadataBuilder(Boolean validationEnabled) {
        this(new EmbeddedObjectMetadata(), validationEnabled);
    }

    public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadataFluent<?> fluent) {
        this(fluent, true);
    }

    public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadataFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EmbeddedObjectMetadata(), validationEnabled);
    }

    public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadataFluent<?> fluent,EmbeddedObjectMetadata instance) {
        this(fluent, instance, true);
    }

    public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadataFluent<?> fluent,EmbeddedObjectMetadata instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withLabels(instance.getLabels()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadata instance) {
        this(instance,true);
    }

    public EmbeddedObjectMetadataBuilder(EmbeddedObjectMetadata instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withLabels(instance.getLabels()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public EmbeddedObjectMetadata build() {
        EmbeddedObjectMetadata buildable = new EmbeddedObjectMetadata(fluent.getAnnotations(),fluent.getLabels(),fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EmbeddedObjectMetadataBuilder that = (EmbeddedObjectMetadataBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
