package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class RulesFluentImpl<A extends RulesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RulesFluent<A> {

    private RulesAlertBuilder alert;

    public RulesFluentImpl() {
    }

    public RulesFluentImpl(Rules instance) {
        this.withAlert(instance.getAlert()); 
    }

    
/**
 * This method has been deprecated, please use method buildAlert instead.
 * @return The buildable object.
 */
@Deprecated public RulesAlert getAlert() {
        return this.alert!=null?this.alert.build():null;
    }

    public RulesAlert buildAlert() {
        return this.alert!=null?this.alert.build():null;
    }

    public A withAlert(RulesAlert alert) {
        _visitables.get("alert").remove(this.alert);
        if (alert!=null){ this.alert= new RulesAlertBuilder(alert); _visitables.get("alert").add(this.alert);} return (A) this;
    }

    public Boolean hasAlert() {
        return this.alert != null;
    }

    public A withNewAlert(String forGracePeriod,String forOutageTolerance,String resendDelay) {
        return (A)withAlert(new RulesAlert(forGracePeriod, forOutageTolerance, resendDelay));
    }

    public RulesFluent.AlertNested<A> withNewAlert() {
        return new AlertNestedImpl();
    }

    public RulesFluent.AlertNested<A> withNewAlertLike(RulesAlert item) {
        return new AlertNestedImpl(item);
    }

    public RulesFluent.AlertNested<A> editAlert() {
        return withNewAlertLike(getAlert());
    }

    public RulesFluent.AlertNested<A> editOrNewAlert() {
        return withNewAlertLike(getAlert() != null ? getAlert(): new RulesAlertBuilder().build());
    }

    public RulesFluent.AlertNested<A> editOrNewAlertLike(RulesAlert item) {
        return withNewAlertLike(getAlert() != null ? getAlert(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RulesFluentImpl that = (RulesFluentImpl) o;
        if (alert != null ? !alert.equals(that.alert) :that.alert != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(alert,  super.hashCode());
    }

    public class AlertNestedImpl<N> extends RulesAlertFluentImpl<RulesFluent.AlertNested<N>> implements RulesFluent.AlertNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RulesAlertBuilder builder;

            AlertNestedImpl(RulesAlert item) {
                this.builder = new RulesAlertBuilder(this, item);
                        
            }

            AlertNestedImpl() {
                this.builder = new RulesAlertBuilder(this);
                        
            }

            public N and() {
                return (N) RulesFluentImpl.this.withAlert(builder.build());
            }

            public N endAlert() {
                return and();
            }
    }


}
