package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class RemoteReadSpecFluentImpl<A extends RemoteReadSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RemoteReadSpecFluent<A> {

    private BasicAuthBuilder basicAuth;
    private String bearerToken;
    private String bearerTokenFile;
    private String name;
    private String proxyUrl;
    private Boolean readRecent;
    private String remoteTimeout;
    private Map<String,String> requiredMatchers;
    private TLSConfigBuilder tlsConfig;
    private String url;

    public RemoteReadSpecFluentImpl() {
    }

    public RemoteReadSpecFluentImpl(RemoteReadSpec instance) {
        this.withBasicAuth(instance.getBasicAuth()); 
        this.withBearerToken(instance.getBearerToken()); 
        this.withBearerTokenFile(instance.getBearerTokenFile()); 
        this.withName(instance.getName()); 
        this.withProxyUrl(instance.getProxyUrl()); 
        this.withReadRecent(instance.getReadRecent()); 
        this.withRemoteTimeout(instance.getRemoteTimeout()); 
        this.withRequiredMatchers(instance.getRequiredMatchers()); 
        this.withTlsConfig(instance.getTlsConfig()); 
        this.withUrl(instance.getUrl()); 
    }

    
/**
 * This method has been deprecated, please use method buildBasicAuth instead.
 * @return The buildable object.
 */
@Deprecated public BasicAuth getBasicAuth() {
        return this.basicAuth!=null?this.basicAuth.build():null;
    }

    public BasicAuth buildBasicAuth() {
        return this.basicAuth!=null?this.basicAuth.build():null;
    }

    public A withBasicAuth(BasicAuth basicAuth) {
        _visitables.get("basicAuth").remove(this.basicAuth);
        if (basicAuth!=null){ this.basicAuth= new BasicAuthBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} return (A) this;
    }

    public Boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    public RemoteReadSpecFluent.BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNestedImpl();
    }

    public RemoteReadSpecFluent.BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNestedImpl(item);
    }

    public RemoteReadSpecFluent.BasicAuthNested<A> editBasicAuth() {
        return withNewBasicAuthLike(getBasicAuth());
    }

    public RemoteReadSpecFluent.BasicAuthNested<A> editOrNewBasicAuth() {
        return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new BasicAuthBuilder().build());
    }

    public RemoteReadSpecFluent.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public A withBearerToken(String bearerToken) {
        this.bearerToken=bearerToken; return (A) this;
    }

    public Boolean hasBearerToken() {
        return this.bearerToken != null;
    }

    public A withNewBearerToken(String arg1) {
        return (A)withBearerToken(new String(arg1));
    }

    public A withNewBearerToken(StringBuilder arg1) {
        return (A)withBearerToken(new String(arg1));
    }

    public A withNewBearerToken(StringBuffer arg1) {
        return (A)withBearerToken(new String(arg1));
    }

    public String getBearerTokenFile() {
        return this.bearerTokenFile;
    }

    public A withBearerTokenFile(String bearerTokenFile) {
        this.bearerTokenFile=bearerTokenFile; return (A) this;
    }

    public Boolean hasBearerTokenFile() {
        return this.bearerTokenFile != null;
    }

    public A withNewBearerTokenFile(String arg1) {
        return (A)withBearerTokenFile(new String(arg1));
    }

    public A withNewBearerTokenFile(StringBuilder arg1) {
        return (A)withBearerTokenFile(new String(arg1));
    }

    public A withNewBearerTokenFile(StringBuffer arg1) {
        return (A)withBearerTokenFile(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl=proxyUrl; return (A) this;
    }

    public Boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public A withNewProxyUrl(String arg1) {
        return (A)withProxyUrl(new String(arg1));
    }

    public A withNewProxyUrl(StringBuilder arg1) {
        return (A)withProxyUrl(new String(arg1));
    }

    public A withNewProxyUrl(StringBuffer arg1) {
        return (A)withProxyUrl(new String(arg1));
    }

    public Boolean isReadRecent() {
        return this.readRecent;
    }

    public A withReadRecent(Boolean readRecent) {
        this.readRecent=readRecent; return (A) this;
    }

    public Boolean hasReadRecent() {
        return this.readRecent != null;
    }

    public A withNewReadRecent(String arg1) {
        return (A)withReadRecent(new Boolean(arg1));
    }

    public A withNewReadRecent(boolean arg1) {
        return (A)withReadRecent(new Boolean(arg1));
    }

    public String getRemoteTimeout() {
        return this.remoteTimeout;
    }

    public A withRemoteTimeout(String remoteTimeout) {
        this.remoteTimeout=remoteTimeout; return (A) this;
    }

    public Boolean hasRemoteTimeout() {
        return this.remoteTimeout != null;
    }

    public A withNewRemoteTimeout(String arg1) {
        return (A)withRemoteTimeout(new String(arg1));
    }

    public A withNewRemoteTimeout(StringBuilder arg1) {
        return (A)withRemoteTimeout(new String(arg1));
    }

    public A withNewRemoteTimeout(StringBuffer arg1) {
        return (A)withRemoteTimeout(new String(arg1));
    }

    public A addToRequiredMatchers(String key,String value) {
        if(this.requiredMatchers == null && key != null && value != null) { this.requiredMatchers = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.requiredMatchers.put(key, value);} return (A)this;
    }

    public A addToRequiredMatchers(Map<String,String> map) {
        if(this.requiredMatchers == null && map != null) { this.requiredMatchers = new LinkedHashMap<String,String>(); }
        if(map != null) { this.requiredMatchers.putAll(map);} return (A)this;
    }

    public A removeFromRequiredMatchers(String key) {
        if(this.requiredMatchers == null) { return (A) this; }
        if(key != null && this.requiredMatchers != null) {this.requiredMatchers.remove(key);} return (A)this;
    }

    public A removeFromRequiredMatchers(Map<String,String> map) {
        if(this.requiredMatchers == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.requiredMatchers != null){this.requiredMatchers.remove(key);}}} return (A)this;
    }

    public Map<String,String> getRequiredMatchers() {
        return this.requiredMatchers;
    }

    public A withRequiredMatchers(Map<String,String> requiredMatchers) {
        if (requiredMatchers == null) { this.requiredMatchers =  null;} else {this.requiredMatchers = new LinkedHashMap<String,String>(requiredMatchers);} return (A) this;
    }

    public Boolean hasRequiredMatchers() {
        return this.requiredMatchers != null;
    }

    
/**
 * This method has been deprecated, please use method buildTlsConfig instead.
 * @return The buildable object.
 */
@Deprecated public TLSConfig getTlsConfig() {
        return this.tlsConfig!=null?this.tlsConfig.build():null;
    }

    public TLSConfig buildTlsConfig() {
        return this.tlsConfig!=null?this.tlsConfig.build():null;
    }

    public A withTlsConfig(TLSConfig tlsConfig) {
        _visitables.get("tlsConfig").remove(this.tlsConfig);
        if (tlsConfig!=null){ this.tlsConfig= new TLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} return (A) this;
    }

    public Boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public RemoteReadSpecFluent.TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNestedImpl();
    }

    public RemoteReadSpecFluent.TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
        return new TlsConfigNestedImpl(item);
    }

    public RemoteReadSpecFluent.TlsConfigNested<A> editTlsConfig() {
        return withNewTlsConfigLike(getTlsConfig());
    }

    public RemoteReadSpecFluent.TlsConfigNested<A> editOrNewTlsConfig() {
        return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new TLSConfigBuilder().build());
    }

    public RemoteReadSpecFluent.TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
        return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url=url; return (A) this;
    }

    public Boolean hasUrl() {
        return this.url != null;
    }

    public A withNewUrl(String arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuilder arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1) {
        return (A)withUrl(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RemoteReadSpecFluentImpl that = (RemoteReadSpecFluentImpl) o;
        if (basicAuth != null ? !basicAuth.equals(that.basicAuth) :that.basicAuth != null) return false;
        if (bearerToken != null ? !bearerToken.equals(that.bearerToken) :that.bearerToken != null) return false;
        if (bearerTokenFile != null ? !bearerTokenFile.equals(that.bearerTokenFile) :that.bearerTokenFile != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (proxyUrl != null ? !proxyUrl.equals(that.proxyUrl) :that.proxyUrl != null) return false;
        if (readRecent != null ? !readRecent.equals(that.readRecent) :that.readRecent != null) return false;
        if (remoteTimeout != null ? !remoteTimeout.equals(that.remoteTimeout) :that.remoteTimeout != null) return false;
        if (requiredMatchers != null ? !requiredMatchers.equals(that.requiredMatchers) :that.requiredMatchers != null) return false;
        if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(basicAuth,  bearerToken,  bearerTokenFile,  name,  proxyUrl,  readRecent,  remoteTimeout,  requiredMatchers,  tlsConfig,  url,  super.hashCode());
    }

    public class BasicAuthNestedImpl<N> extends BasicAuthFluentImpl<RemoteReadSpecFluent.BasicAuthNested<N>> implements RemoteReadSpecFluent.BasicAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BasicAuthBuilder builder;

            BasicAuthNestedImpl(BasicAuth item) {
                this.builder = new BasicAuthBuilder(this, item);
                        
            }

            BasicAuthNestedImpl() {
                this.builder = new BasicAuthBuilder(this);
                        
            }

            public N and() {
                return (N) RemoteReadSpecFluentImpl.this.withBasicAuth(builder.build());
            }

            public N endBasicAuth() {
                return and();
            }
    }


    public class TlsConfigNestedImpl<N> extends TLSConfigFluentImpl<RemoteReadSpecFluent.TlsConfigNested<N>> implements RemoteReadSpecFluent.TlsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TLSConfigBuilder builder;

            TlsConfigNestedImpl(TLSConfig item) {
                this.builder = new TLSConfigBuilder(this, item);
                        
            }

            TlsConfigNestedImpl() {
                this.builder = new TLSConfigBuilder(this);
                        
            }

            public N and() {
                return (N) RemoteReadSpecFluentImpl.this.withTlsConfig(builder.build());
            }

            public N endTlsConfig() {
                return and();
            }
    }


}
