package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface AlertmanagerFluent<A extends AlertmanagerFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public AlertmanagerFluent.MetadataNested<A> withNewMetadata();
    public AlertmanagerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public AlertmanagerFluent.MetadataNested<A> editMetadata();
    public AlertmanagerFluent.MetadataNested<A> editOrNewMetadata();
    public AlertmanagerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public AlertmanagerSpec getSpec();
    public AlertmanagerSpec buildSpec();
    public A withSpec(AlertmanagerSpec spec);
    public Boolean hasSpec();
    public AlertmanagerFluent.SpecNested<A> withNewSpec();
    public AlertmanagerFluent.SpecNested<A> withNewSpecLike(AlertmanagerSpec item);
    public AlertmanagerFluent.SpecNested<A> editSpec();
    public AlertmanagerFluent.SpecNested<A> editOrNewSpec();
    public AlertmanagerFluent.SpecNested<A> editOrNewSpecLike(AlertmanagerSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public AlertmanagerStatus getStatus();
    public AlertmanagerStatus buildStatus();
    public A withStatus(AlertmanagerStatus status);
    public Boolean hasStatus();
    public A withNewStatus(Integer availableReplicas,Boolean paused,Integer replicas,Integer unavailableReplicas,Integer updatedReplicas);
    public AlertmanagerFluent.StatusNested<A> withNewStatus();
    public AlertmanagerFluent.StatusNested<A> withNewStatusLike(AlertmanagerStatus item);
    public AlertmanagerFluent.StatusNested<A> editStatus();
    public AlertmanagerFluent.StatusNested<A> editOrNewStatus();
    public AlertmanagerFluent.StatusNested<A> editOrNewStatusLike(AlertmanagerStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<AlertmanagerFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AlertmanagerSpecFluent<AlertmanagerFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AlertmanagerStatusFluent<AlertmanagerFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
