package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class ThanosSpecFluentImpl<A extends io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent<A>{
  public ThanosSpecFluentImpl() {
  }
  public ThanosSpecFluentImpl(io.fabric8.openshift.api.model.monitoring.v1.ThanosSpec instance) {
    this.withBaseImage(instance.getBaseImage()); 
    this.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig()); 
    this.withImage(instance.getImage()); 
    this.withListenLocal(instance.getListenLocal()); 
    this.withLogFormat(instance.getLogFormat()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withMinTime(instance.getMinTime()); 
    this.withObjectStorageConfig(instance.getObjectStorageConfig()); 
    this.withObjectStorageConfigFile(instance.getObjectStorageConfigFile()); 
    this.withReadyTimeout(instance.getReadyTimeout()); 
    this.withResources(instance.getResources()); 
    this.withSha(instance.getSha()); 
    this.withTag(instance.getTag()); 
    this.withTracingConfig(instance.getTracingConfig()); 
    this.withTracingConfigFile(instance.getTracingConfigFile()); 
    this.withVersion(instance.getVersion()); 
    this.withVolumeMounts(instance.getVolumeMounts()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String baseImage;
  private io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder grpcServerTlsConfig;
  private java.lang.String image;
  private java.lang.Boolean listenLocal;
  private java.lang.String logFormat;
  private java.lang.String logLevel;
  private java.lang.String minTime;
  private io.fabric8.kubernetes.api.model.SecretKeySelector objectStorageConfig;
  private java.lang.String objectStorageConfigFile;
  private java.lang.String readyTimeout;
  private io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder resources;
  private java.lang.String sha;
  private java.lang.String tag;
  private io.fabric8.kubernetes.api.model.SecretKeySelector tracingConfig;
  private java.lang.String tracingConfigFile;
  private java.lang.String version;
  private java.util.List<io.fabric8.kubernetes.api.model.VolumeMount> volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMount>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getBaseImage() {
    return this.baseImage;
  }
  public A withBaseImage(java.lang.String baseImage) {
    this.baseImage=baseImage; return (A) this;
  }
  public java.lang.Boolean hasBaseImage() {
    return this.baseImage != null;
  }
  
  /**
   * Method is deprecated. use withBaseImage instead.
   */
  @java.lang.Deprecated
  public A withNewBaseImage(java.lang.String arg0) {
    return (A)withBaseImage(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildGrpcServerTlsConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.monitoring.v1.TLSConfig getGrpcServerTlsConfig() {
    return this.grpcServerTlsConfig!=null?this.grpcServerTlsConfig.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.TLSConfig buildGrpcServerTlsConfig() {
    return this.grpcServerTlsConfig!=null?this.grpcServerTlsConfig.build():null;
  }
  public A withGrpcServerTlsConfig(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig grpcServerTlsConfig) {
    _visitables.get("grpcServerTlsConfig").remove(this.grpcServerTlsConfig);
    if (grpcServerTlsConfig!=null){ this.grpcServerTlsConfig= new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder(grpcServerTlsConfig); _visitables.get("grpcServerTlsConfig").add(this.grpcServerTlsConfig);} return (A) this;
  }
  public java.lang.Boolean hasGrpcServerTlsConfig() {
    return this.grpcServerTlsConfig != null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfig() {
    return new io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluentImpl.GrpcServerTlsConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfigLike(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluentImpl.GrpcServerTlsConfigNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent.GrpcServerTlsConfigNested<A> editGrpcServerTlsConfig() {
    return withNewGrpcServerTlsConfigLike(getGrpcServerTlsConfig());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfig() {
    return withNewGrpcServerTlsConfigLike(getGrpcServerTlsConfig() != null ? getGrpcServerTlsConfig(): new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfigLike(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig item) {
    return withNewGrpcServerTlsConfigLike(getGrpcServerTlsConfig() != null ? getGrpcServerTlsConfig(): item);
  }
  public java.lang.String getImage() {
    return this.image;
  }
  public A withImage(java.lang.String image) {
    this.image=image; return (A) this;
  }
  public java.lang.Boolean hasImage() {
    return this.image != null;
  }
  
  /**
   * Method is deprecated. use withImage instead.
   */
  @java.lang.Deprecated
  public A withNewImage(java.lang.String arg0) {
    return (A)withImage(new String(arg0));
  }
  public java.lang.Boolean getListenLocal() {
    return this.listenLocal;
  }
  public A withListenLocal(java.lang.Boolean listenLocal) {
    this.listenLocal=listenLocal; return (A) this;
  }
  public java.lang.Boolean hasListenLocal() {
    return this.listenLocal != null;
  }
  public java.lang.String getLogFormat() {
    return this.logFormat;
  }
  public A withLogFormat(java.lang.String logFormat) {
    this.logFormat=logFormat; return (A) this;
  }
  public java.lang.Boolean hasLogFormat() {
    return this.logFormat != null;
  }
  
  /**
   * Method is deprecated. use withLogFormat instead.
   */
  @java.lang.Deprecated
  public A withNewLogFormat(java.lang.String arg0) {
    return (A)withLogFormat(new String(arg0));
  }
  public java.lang.String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(java.lang.String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public java.lang.Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  
  /**
   * Method is deprecated. use withLogLevel instead.
   */
  @java.lang.Deprecated
  public A withNewLogLevel(java.lang.String arg0) {
    return (A)withLogLevel(new String(arg0));
  }
  public java.lang.String getMinTime() {
    return this.minTime;
  }
  public A withMinTime(java.lang.String minTime) {
    this.minTime=minTime; return (A) this;
  }
  public java.lang.Boolean hasMinTime() {
    return this.minTime != null;
  }
  
  /**
   * Method is deprecated. use withMinTime instead.
   */
  @java.lang.Deprecated
  public A withNewMinTime(java.lang.String arg0) {
    return (A)withMinTime(new String(arg0));
  }
  public io.fabric8.kubernetes.api.model.SecretKeySelector getObjectStorageConfig() {
    return this.objectStorageConfig;
  }
  public A withObjectStorageConfig(io.fabric8.kubernetes.api.model.SecretKeySelector objectStorageConfig) {
    this.objectStorageConfig=objectStorageConfig; return (A) this;
  }
  public java.lang.Boolean hasObjectStorageConfig() {
    return this.objectStorageConfig != null;
  }
  public A withNewObjectStorageConfig(java.lang.String key,java.lang.String name,java.lang.Boolean optional) {
    return (A)withObjectStorageConfig(new SecretKeySelector(key, name, optional));
  }
  public java.lang.String getObjectStorageConfigFile() {
    return this.objectStorageConfigFile;
  }
  public A withObjectStorageConfigFile(java.lang.String objectStorageConfigFile) {
    this.objectStorageConfigFile=objectStorageConfigFile; return (A) this;
  }
  public java.lang.Boolean hasObjectStorageConfigFile() {
    return this.objectStorageConfigFile != null;
  }
  
  /**
   * Method is deprecated. use withObjectStorageConfigFile instead.
   */
  @java.lang.Deprecated
  public A withNewObjectStorageConfigFile(java.lang.String arg0) {
    return (A)withObjectStorageConfigFile(new String(arg0));
  }
  public java.lang.String getReadyTimeout() {
    return this.readyTimeout;
  }
  public A withReadyTimeout(java.lang.String readyTimeout) {
    this.readyTimeout=readyTimeout; return (A) this;
  }
  public java.lang.Boolean hasReadyTimeout() {
    return this.readyTimeout != null;
  }
  
  /**
   * Method is deprecated. use withReadyTimeout instead.
   */
  @java.lang.Deprecated
  public A withNewReadyTimeout(java.lang.String arg0) {
    return (A)withReadyTimeout(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
    return this.resources!=null?this.resources.build():null;
  }
  public io.fabric8.kubernetes.api.model.ResourceRequirements buildResources() {
    return this.resources!=null?this.resources.build():null;
  }
  public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
  }
  public java.lang.Boolean hasResources() {
    return this.resources != null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent.ResourcesNested<A> withNewResources() {
    return new io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluentImpl.ResourcesNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent.ResourcesNested<A> withNewResourcesLike(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluentImpl.ResourcesNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent.ResourcesNested<A> editOrNewResourcesLike(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  public java.lang.String getSha() {
    return this.sha;
  }
  public A withSha(java.lang.String sha) {
    this.sha=sha; return (A) this;
  }
  public java.lang.Boolean hasSha() {
    return this.sha != null;
  }
  
  /**
   * Method is deprecated. use withSha instead.
   */
  @java.lang.Deprecated
  public A withNewSha(java.lang.String arg0) {
    return (A)withSha(new String(arg0));
  }
  public java.lang.String getTag() {
    return this.tag;
  }
  public A withTag(java.lang.String tag) {
    this.tag=tag; return (A) this;
  }
  public java.lang.Boolean hasTag() {
    return this.tag != null;
  }
  
  /**
   * Method is deprecated. use withTag instead.
   */
  @java.lang.Deprecated
  public A withNewTag(java.lang.String arg0) {
    return (A)withTag(new String(arg0));
  }
  public io.fabric8.kubernetes.api.model.SecretKeySelector getTracingConfig() {
    return this.tracingConfig;
  }
  public A withTracingConfig(io.fabric8.kubernetes.api.model.SecretKeySelector tracingConfig) {
    this.tracingConfig=tracingConfig; return (A) this;
  }
  public java.lang.Boolean hasTracingConfig() {
    return this.tracingConfig != null;
  }
  public A withNewTracingConfig(java.lang.String key,java.lang.String name,java.lang.Boolean optional) {
    return (A)withTracingConfig(new SecretKeySelector(key, name, optional));
  }
  public java.lang.String getTracingConfigFile() {
    return this.tracingConfigFile;
  }
  public A withTracingConfigFile(java.lang.String tracingConfigFile) {
    this.tracingConfigFile=tracingConfigFile; return (A) this;
  }
  public java.lang.Boolean hasTracingConfigFile() {
    return this.tracingConfigFile != null;
  }
  
  /**
   * Method is deprecated. use withTracingConfigFile instead.
   */
  @java.lang.Deprecated
  public A withNewTracingConfigFile(java.lang.String arg0) {
    return (A)withTracingConfigFile(new String(arg0));
  }
  public java.lang.String getVersion() {
    return this.version;
  }
  public A withVersion(java.lang.String version) {
    this.version=version; return (A) this;
  }
  public java.lang.Boolean hasVersion() {
    return this.version != null;
  }
  
  /**
   * Method is deprecated. use withVersion instead.
   */
  @java.lang.Deprecated
  public A withNewVersion(java.lang.String arg0) {
    return (A)withVersion(new String(arg0));
  }
  public A addToVolumeMounts(java.lang.Integer index,io.fabric8.kubernetes.api.model.VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMount>();}
    this.volumeMounts.add(index, item);
    return (A)this;
  }
  public A setToVolumeMounts(java.lang.Integer index,io.fabric8.kubernetes.api.model.VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMount>();}
    this.volumeMounts.set(index, item); return (A)this;
  }
  public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    if (this.volumeMounts == null) {this.volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMount>();}
    for (io.fabric8.kubernetes.api.model.VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
  }
  public A addAllToVolumeMounts(java.util.Collection<io.fabric8.kubernetes.api.model.VolumeMount> items) {
    if (this.volumeMounts == null) {this.volumeMounts = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeMount>();}
    for (io.fabric8.kubernetes.api.model.VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
  }
  public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    for (io.fabric8.kubernetes.api.model.VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
  }
  public A removeAllFromVolumeMounts(java.util.Collection<io.fabric8.kubernetes.api.model.VolumeMount> items) {
    for (io.fabric8.kubernetes.api.model.VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.VolumeMount> getVolumeMounts() {
    return this.volumeMounts;
  }
  public io.fabric8.kubernetes.api.model.VolumeMount getVolumeMount(java.lang.Integer index) {
    return this.volumeMounts.get(index);
  }
  public io.fabric8.kubernetes.api.model.VolumeMount getFirstVolumeMount() {
    return this.volumeMounts.get(0);
  }
  public io.fabric8.kubernetes.api.model.VolumeMount getLastVolumeMount() {
    return this.volumeMounts.get(volumeMounts.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.VolumeMount getMatchingVolumeMount(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeMount> predicate) {
    for (io.fabric8.kubernetes.api.model.VolumeMount item: volumeMounts) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingVolumeMount(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeMount> predicate) {
    for (io.fabric8.kubernetes.api.model.VolumeMount item: volumeMounts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumeMounts(java.util.List<io.fabric8.kubernetes.api.model.VolumeMount> volumeMounts) {
    if (volumeMounts != null) {this.volumeMounts = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
  }
  public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... volumeMounts) {
    if (this.volumeMounts != null) {this.volumeMounts.clear();}
    if (volumeMounts != null) {for (io.fabric8.kubernetes.api.model.VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
  }
  public java.lang.Boolean hasVolumeMounts() {
    return volumeMounts != null && !volumeMounts.isEmpty();
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ThanosSpecFluentImpl that = (ThanosSpecFluentImpl) o;
    if (baseImage != null ? !baseImage.equals(that.baseImage) :that.baseImage != null) return false;
    if (grpcServerTlsConfig != null ? !grpcServerTlsConfig.equals(that.grpcServerTlsConfig) :that.grpcServerTlsConfig != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (listenLocal != null ? !listenLocal.equals(that.listenLocal) :that.listenLocal != null) return false;
    if (logFormat != null ? !logFormat.equals(that.logFormat) :that.logFormat != null) return false;
    if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
    if (minTime != null ? !minTime.equals(that.minTime) :that.minTime != null) return false;
    if (objectStorageConfig != null ? !objectStorageConfig.equals(that.objectStorageConfig) :that.objectStorageConfig != null) return false;
    if (objectStorageConfigFile != null ? !objectStorageConfigFile.equals(that.objectStorageConfigFile) :that.objectStorageConfigFile != null) return false;
    if (readyTimeout != null ? !readyTimeout.equals(that.readyTimeout) :that.readyTimeout != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (sha != null ? !sha.equals(that.sha) :that.sha != null) return false;
    if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
    if (tracingConfig != null ? !tracingConfig.equals(that.tracingConfig) :that.tracingConfig != null) return false;
    if (tracingConfigFile != null ? !tracingConfigFile.equals(that.tracingConfigFile) :that.tracingConfigFile != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(baseImage,  grpcServerTlsConfig,  image,  listenLocal,  logFormat,  logLevel,  minTime,  objectStorageConfig,  objectStorageConfigFile,  readyTimeout,  resources,  sha,  tag,  tracingConfig,  tracingConfigFile,  version,  volumeMounts,  additionalProperties,  super.hashCode());
  }
  public class GrpcServerTlsConfigNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent.GrpcServerTlsConfigNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent.GrpcServerTlsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GrpcServerTlsConfigNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig item) {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder(this, item);
    }
    GrpcServerTlsConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder builder;
    public N and() {
      return (N) ThanosSpecFluentImpl.this.withGrpcServerTlsConfig(builder.build());
    }
    public N endGrpcServerTlsConfig() {
      return and();
    }
    
  }
  public class ResourcesNestedImpl<N> extends io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent.ResourcesNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ResourcesNestedImpl(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
      this.builder = new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder builder;
    public N and() {
      return (N) ThanosSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  
}