package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class ServiceMonitorSpecFluentImpl<A extends io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent<A>{
  public ServiceMonitorSpecFluentImpl() {
  }
  public ServiceMonitorSpecFluentImpl(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpec instance) {
    this.withEndpoints(instance.getEndpoints()); 
    this.withJobLabel(instance.getJobLabel()); 
    this.withLabelLimit(instance.getLabelLimit()); 
    this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit()); 
    this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withPodTargetLabels(instance.getPodTargetLabels()); 
    this.withSampleLimit(instance.getSampleLimit()); 
    this.withSelector(instance.getSelector()); 
    this.withTargetLabels(instance.getTargetLabels()); 
    this.withTargetLimit(instance.getTargetLimit()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder> endpoints =  new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder>();
  private java.lang.String jobLabel;
  private java.lang.Long labelLimit;
  private java.lang.Long labelNameLengthLimit;
  private java.lang.Long labelValueLengthLimit;
  private io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorBuilder namespaceSelector;
  private java.util.List<java.lang.String> podTargetLabels = new java.util.ArrayList<java.lang.String>();
  private java.lang.Long sampleLimit;
  private io.fabric8.kubernetes.api.model.LabelSelectorBuilder selector;
  private java.util.List<java.lang.String> targetLabels = new java.util.ArrayList<java.lang.String>();
  private java.lang.Long targetLimit;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToEndpoints(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.Endpoint item) {
    if (this.endpoints == null) {this.endpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder(item);_visitables.get("endpoints").add(index >= 0 ? index : _visitables.get("endpoints").size(), builder);this.endpoints.add(index >= 0 ? index : endpoints.size(), builder); return (A)this;
  }
  public A setToEndpoints(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.Endpoint item) {
    if (this.endpoints == null) {this.endpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder(item);
    if (index < 0 || index >= _visitables.get("endpoints").size()) { _visitables.get("endpoints").add(builder); } else { _visitables.get("endpoints").set(index, builder);}
    if (index < 0 || index >= endpoints.size()) { endpoints.add(builder); } else { endpoints.set(index, builder);}
     return (A)this;
  }
  public A addToEndpoints(io.fabric8.openshift.api.model.monitoring.v1.Endpoint... items) {
    if (this.endpoints == null) {this.endpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1.Endpoint item : items) {io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  public A addAllToEndpoints(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.Endpoint> items) {
    if (this.endpoints == null) {this.endpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1.Endpoint item : items) {io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  public A removeFromEndpoints(io.fabric8.openshift.api.model.monitoring.v1.Endpoint... items) {
    for (io.fabric8.openshift.api.model.monitoring.v1.Endpoint item : items) {io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
  }
  public A removeAllFromEndpoints(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.Endpoint> items) {
    for (io.fabric8.openshift.api.model.monitoring.v1.Endpoint item : items) {io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEndpoints(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder> predicate) {
    if (endpoints == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder> each = endpoints.iterator();
    final List visitables = _visitables.get("endpoints");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEndpoints instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.Endpoint> getEndpoints() {
    return build(endpoints);
  }
  public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.Endpoint> buildEndpoints() {
    return build(endpoints);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.Endpoint buildEndpoint(java.lang.Integer index) {
    return this.endpoints.get(index).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.Endpoint buildFirstEndpoint() {
    return this.endpoints.get(0).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.Endpoint buildLastEndpoint() {
    return this.endpoints.get(endpoints.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.Endpoint buildMatchingEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder item: endpoints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder item: endpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEndpoints(java.util.List<io.fabric8.openshift.api.model.monitoring.v1.Endpoint> endpoints) {
    if (this.endpoints != null) { _visitables.get("endpoints").removeAll(this.endpoints);}
    if (endpoints != null) {this.endpoints = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.monitoring.v1.Endpoint item : endpoints){this.addToEndpoints(item);}} else { this.endpoints = null;} return (A) this;
  }
  public A withEndpoints(io.fabric8.openshift.api.model.monitoring.v1.Endpoint... endpoints) {
    if (this.endpoints != null) {this.endpoints.clear();}
    if (endpoints != null) {for (io.fabric8.openshift.api.model.monitoring.v1.Endpoint item :endpoints){ this.addToEndpoints(item);}} return (A) this;
  }
  public java.lang.Boolean hasEndpoints() {
    return endpoints != null && !endpoints.isEmpty();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpoint() {
    return new io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluentImpl.EndpointsNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpointLike(io.fabric8.openshift.api.model.monitoring.v1.Endpoint item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluentImpl.EndpointsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.EndpointsNested<A> setNewEndpointLike(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.Endpoint item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluentImpl.EndpointsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.EndpointsNested<A> editEndpoint(java.lang.Integer index) {
    if (endpoints.size() <= index) throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.EndpointsNested<A> editFirstEndpoint() {
    if (endpoints.size() == 0) throw new RuntimeException("Can't edit first endpoints. The list is empty.");
    return setNewEndpointLike(0, buildEndpoint(0));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.EndpointsNested<A> editLastEndpoint() {
    int index = endpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last endpoints. The list is empty.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.EndpointsNested<A> editMatchingEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<endpoints.size();i++) { 
    if (predicate.test(endpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching endpoints. No match found.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public java.lang.String getJobLabel() {
    return this.jobLabel;
  }
  public A withJobLabel(java.lang.String jobLabel) {
    this.jobLabel=jobLabel; return (A) this;
  }
  public java.lang.Boolean hasJobLabel() {
    return this.jobLabel != null;
  }
  
  /**
   * Method is deprecated. use withJobLabel instead.
   */
  @java.lang.Deprecated
  public A withNewJobLabel(java.lang.String arg0) {
    return (A)withJobLabel(new String(arg0));
  }
  public java.lang.Long getLabelLimit() {
    return this.labelLimit;
  }
  public A withLabelLimit(java.lang.Long labelLimit) {
    this.labelLimit=labelLimit; return (A) this;
  }
  public java.lang.Boolean hasLabelLimit() {
    return this.labelLimit != null;
  }
  public java.lang.Long getLabelNameLengthLimit() {
    return this.labelNameLengthLimit;
  }
  public A withLabelNameLengthLimit(java.lang.Long labelNameLengthLimit) {
    this.labelNameLengthLimit=labelNameLengthLimit; return (A) this;
  }
  public java.lang.Boolean hasLabelNameLengthLimit() {
    return this.labelNameLengthLimit != null;
  }
  public java.lang.Long getLabelValueLengthLimit() {
    return this.labelValueLengthLimit;
  }
  public A withLabelValueLengthLimit(java.lang.Long labelValueLengthLimit) {
    this.labelValueLengthLimit=labelValueLengthLimit; return (A) this;
  }
  public java.lang.Boolean hasLabelValueLengthLimit() {
    return this.labelValueLengthLimit != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector getNamespaceSelector() {
    return this.namespaceSelector!=null?this.namespaceSelector.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} return (A) this;
  }
  public java.lang.Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluentImpl.NamespaceSelectorNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  public A addToPodTargetLabels(java.lang.Integer index,java.lang.String item) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new java.util.ArrayList<java.lang.String>();}
    this.podTargetLabels.add(index, item);
    return (A)this;
  }
  public A setToPodTargetLabels(java.lang.Integer index,java.lang.String item) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new java.util.ArrayList<java.lang.String>();}
    this.podTargetLabels.set(index, item); return (A)this;
  }
  public A addToPodTargetLabels(java.lang.String... items) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.podTargetLabels.add(item);} return (A)this;
  }
  public A addAllToPodTargetLabels(java.util.Collection<java.lang.String> items) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.podTargetLabels.add(item);} return (A)this;
  }
  public A removeFromPodTargetLabels(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.podTargetLabels!= null){ this.podTargetLabels.remove(item);}} return (A)this;
  }
  public A removeAllFromPodTargetLabels(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.podTargetLabels!= null){ this.podTargetLabels.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getPodTargetLabels() {
    return this.podTargetLabels;
  }
  public java.lang.String getPodTargetLabel(java.lang.Integer index) {
    return this.podTargetLabels.get(index);
  }
  public java.lang.String getFirstPodTargetLabel() {
    return this.podTargetLabels.get(0);
  }
  public java.lang.String getLastPodTargetLabel() {
    return this.podTargetLabels.get(podTargetLabels.size() - 1);
  }
  public java.lang.String getMatchingPodTargetLabel(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: podTargetLabels) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingPodTargetLabel(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: podTargetLabels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPodTargetLabels(java.util.List<java.lang.String> podTargetLabels) {
    if (podTargetLabels != null) {this.podTargetLabels = new java.util.ArrayList(); for (java.lang.String item : podTargetLabels){this.addToPodTargetLabels(item);}} else { this.podTargetLabels = null;} return (A) this;
  }
  public A withPodTargetLabels(java.lang.String... podTargetLabels) {
    if (this.podTargetLabels != null) {this.podTargetLabels.clear();}
    if (podTargetLabels != null) {for (java.lang.String item :podTargetLabels){ this.addToPodTargetLabels(item);}} return (A) this;
  }
  public java.lang.Boolean hasPodTargetLabels() {
    return podTargetLabels != null && !podTargetLabels.isEmpty();
  }
  public A addNewPodTargetLabel(java.lang.String arg0) {
    return (A)addToPodTargetLabels(new String(arg0));
  }
  public java.lang.Long getSampleLimit() {
    return this.sampleLimit;
  }
  public A withSampleLimit(java.lang.Long sampleLimit) {
    this.sampleLimit=sampleLimit; return (A) this;
  }
  public java.lang.Boolean hasSampleLimit() {
    return this.sampleLimit != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.LabelSelector getSelector() {
    return this.selector!=null?this.selector.build():null;
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildSelector() {
    return this.selector!=null?this.selector.build():null;
  }
  public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
  }
  public java.lang.Boolean hasSelector() {
    return this.selector != null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.SelectorNested<A> withNewSelector() {
    return new io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluentImpl.SelectorNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluentImpl.SelectorNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public A addToTargetLabels(java.lang.Integer index,java.lang.String item) {
    if (this.targetLabels == null) {this.targetLabels = new java.util.ArrayList<java.lang.String>();}
    this.targetLabels.add(index, item);
    return (A)this;
  }
  public A setToTargetLabels(java.lang.Integer index,java.lang.String item) {
    if (this.targetLabels == null) {this.targetLabels = new java.util.ArrayList<java.lang.String>();}
    this.targetLabels.set(index, item); return (A)this;
  }
  public A addToTargetLabels(java.lang.String... items) {
    if (this.targetLabels == null) {this.targetLabels = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.targetLabels.add(item);} return (A)this;
  }
  public A addAllToTargetLabels(java.util.Collection<java.lang.String> items) {
    if (this.targetLabels == null) {this.targetLabels = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.targetLabels.add(item);} return (A)this;
  }
  public A removeFromTargetLabels(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.targetLabels!= null){ this.targetLabels.remove(item);}} return (A)this;
  }
  public A removeAllFromTargetLabels(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.targetLabels!= null){ this.targetLabels.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getTargetLabels() {
    return this.targetLabels;
  }
  public java.lang.String getTargetLabel(java.lang.Integer index) {
    return this.targetLabels.get(index);
  }
  public java.lang.String getFirstTargetLabel() {
    return this.targetLabels.get(0);
  }
  public java.lang.String getLastTargetLabel() {
    return this.targetLabels.get(targetLabels.size() - 1);
  }
  public java.lang.String getMatchingTargetLabel(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: targetLabels) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingTargetLabel(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: targetLabels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTargetLabels(java.util.List<java.lang.String> targetLabels) {
    if (targetLabels != null) {this.targetLabels = new java.util.ArrayList(); for (java.lang.String item : targetLabels){this.addToTargetLabels(item);}} else { this.targetLabels = null;} return (A) this;
  }
  public A withTargetLabels(java.lang.String... targetLabels) {
    if (this.targetLabels != null) {this.targetLabels.clear();}
    if (targetLabels != null) {for (java.lang.String item :targetLabels){ this.addToTargetLabels(item);}} return (A) this;
  }
  public java.lang.Boolean hasTargetLabels() {
    return targetLabels != null && !targetLabels.isEmpty();
  }
  public A addNewTargetLabel(java.lang.String arg0) {
    return (A)addToTargetLabels(new String(arg0));
  }
  public java.lang.Long getTargetLimit() {
    return this.targetLimit;
  }
  public A withTargetLimit(java.lang.Long targetLimit) {
    this.targetLimit=targetLimit; return (A) this;
  }
  public java.lang.Boolean hasTargetLimit() {
    return this.targetLimit != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceMonitorSpecFluentImpl that = (ServiceMonitorSpecFluentImpl) o;
    if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
    if (jobLabel != null ? !jobLabel.equals(that.jobLabel) :that.jobLabel != null) return false;
    if (labelLimit != null ? !labelLimit.equals(that.labelLimit) :that.labelLimit != null) return false;
    if (labelNameLengthLimit != null ? !labelNameLengthLimit.equals(that.labelNameLengthLimit) :that.labelNameLengthLimit != null) return false;
    if (labelValueLengthLimit != null ? !labelValueLengthLimit.equals(that.labelValueLengthLimit) :that.labelValueLengthLimit != null) return false;
    if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
    if (podTargetLabels != null ? !podTargetLabels.equals(that.podTargetLabels) :that.podTargetLabels != null) return false;
    if (sampleLimit != null ? !sampleLimit.equals(that.sampleLimit) :that.sampleLimit != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (targetLabels != null ? !targetLabels.equals(that.targetLabels) :that.targetLabels != null) return false;
    if (targetLimit != null ? !targetLimit.equals(that.targetLimit) :that.targetLimit != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(endpoints,  jobLabel,  labelLimit,  labelNameLengthLimit,  labelValueLengthLimit,  namespaceSelector,  podTargetLabels,  sampleLimit,  selector,  targetLabels,  targetLimit,  additionalProperties,  super.hashCode());
  }
  public class EndpointsNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.EndpointsNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.EndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EndpointsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.Endpoint item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder(this, item);
    }
    EndpointsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ServiceMonitorSpecFluentImpl.this.setToEndpoints(index,builder.build());
    }
    public N endEndpoint() {
      return and();
    }
    
  }
  public class NamespaceSelectorNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.NamespaceSelectorNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.NamespaceSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NamespaceSelectorNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector item) {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorBuilder builder;
    public N and() {
      return (N) ServiceMonitorSpecFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  public class SelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.SelectorNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;
    public N and() {
      return (N) ServiceMonitorSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}