package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class RulesAlertBuilder extends io.fabric8.openshift.api.model.monitoring.v1.RulesAlertFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.RulesAlertBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.RulesAlert,io.fabric8.openshift.api.model.monitoring.v1.RulesAlertBuilder>{
  public RulesAlertBuilder() {
    this(false);
  }
  public RulesAlertBuilder(java.lang.Boolean validationEnabled) {
    this(new RulesAlert(), validationEnabled);
  }
  public RulesAlertBuilder(io.fabric8.openshift.api.model.monitoring.v1.RulesAlertFluent<?> fluent) {
    this(fluent, false);
  }
  public RulesAlertBuilder(io.fabric8.openshift.api.model.monitoring.v1.RulesAlertFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RulesAlert(), validationEnabled);
  }
  public RulesAlertBuilder(io.fabric8.openshift.api.model.monitoring.v1.RulesAlertFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.RulesAlert instance) {
    this(fluent, instance, false);
  }
  public RulesAlertBuilder(io.fabric8.openshift.api.model.monitoring.v1.RulesAlertFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.RulesAlert instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withForGracePeriod(instance.getForGracePeriod()); 
    fluent.withForOutageTolerance(instance.getForOutageTolerance()); 
    fluent.withResendDelay(instance.getResendDelay()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RulesAlertBuilder(io.fabric8.openshift.api.model.monitoring.v1.RulesAlert instance) {
    this(instance,false);
  }
  public RulesAlertBuilder(io.fabric8.openshift.api.model.monitoring.v1.RulesAlert instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withForGracePeriod(instance.getForGracePeriod()); 
    this.withForOutageTolerance(instance.getForOutageTolerance()); 
    this.withResendDelay(instance.getResendDelay()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.RulesAlertFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.RulesAlert build() {
    RulesAlert buildable = new RulesAlert(fluent.getForGracePeriod(),fluent.getForOutageTolerance(),fluent.getResendDelay());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RulesAlertBuilder that = (RulesAlertBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}