package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class OAuth2Builder extends io.fabric8.openshift.api.model.monitoring.v1.OAuth2FluentImpl<io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.OAuth2,io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder>{
  public OAuth2Builder() {
    this(false);
  }
  public OAuth2Builder(java.lang.Boolean validationEnabled) {
    this(new OAuth2(), validationEnabled);
  }
  public OAuth2Builder(io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent<?> fluent) {
    this(fluent, false);
  }
  public OAuth2Builder(io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OAuth2(), validationEnabled);
  }
  public OAuth2Builder(io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.OAuth2 instance) {
    this(fluent, instance, false);
  }
  public OAuth2Builder(io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.OAuth2 instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClientId(instance.getClientId()); 
    fluent.withClientSecret(instance.getClientSecret()); 
    fluent.withEndpointParams(instance.getEndpointParams()); 
    fluent.withScopes(instance.getScopes()); 
    fluent.withTokenUrl(instance.getTokenUrl()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuth2Builder(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 instance) {
    this(instance,false);
  }
  public OAuth2Builder(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClientId(instance.getClientId()); 
    this.withClientSecret(instance.getClientSecret()); 
    this.withEndpointParams(instance.getEndpointParams()); 
    this.withScopes(instance.getScopes()); 
    this.withTokenUrl(instance.getTokenUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.OAuth2 build() {
    OAuth2 buildable = new OAuth2(fluent.getClientId(),fluent.getClientSecret(),fluent.getEndpointParams(),fluent.getScopes(),fluent.getTokenUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OAuth2Builder that = (OAuth2Builder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}