package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;

 /**
  * Generated
  */
public class EndpointFluentImpl<A extends io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent<A>{
  public EndpointFluentImpl() {
  }
  public EndpointFluentImpl(io.fabric8.openshift.api.model.monitoring.v1.Endpoint instance) {
    this.withAuthorization(instance.getAuthorization()); 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerTokenFile(instance.getBearerTokenFile()); 
    this.withBearerTokenSecret(instance.getBearerTokenSecret()); 
    this.withHonorLabels(instance.getHonorLabels()); 
    this.withHonorTimestamps(instance.getHonorTimestamps()); 
    this.withInterval(instance.getInterval()); 
    this.withMetricRelabelings(instance.getMetricRelabelings()); 
    this.withOauth2(instance.getOauth2()); 
    this.withParams(instance.getParams()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withProxyUrl(instance.getProxyUrl()); 
    this.withRelabelings(instance.getRelabelings()); 
    this.withScheme(instance.getScheme()); 
    this.withScrapeTimeout(instance.getScrapeTimeout()); 
    this.withTargetPort(instance.getTargetPort()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder authorization;
  private io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder basicAuth;
  private java.lang.String bearerTokenFile;
  private io.fabric8.kubernetes.api.model.SecretKeySelector bearerTokenSecret;
  private java.lang.Boolean honorLabels;
  private java.lang.Boolean honorTimestamps;
  private java.lang.String interval;
  private java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> metricRelabelings =  new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();
  private io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder oauth2;
  private java.util.Map<java.lang.String,java.util.ArrayList<java.lang.String>> params;
  private java.lang.String path;
  private java.lang.String port;
  private java.lang.String proxyUrl;
  private java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> relabelings =  new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();
  private java.lang.String scheme;
  private java.lang.String scrapeTimeout;
  private io.fabric8.kubernetes.api.model.IntOrStringBuilder targetPort;
  private io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder tlsConfig;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAuthorization instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization getAuthorization() {
    return this.authorization!=null?this.authorization.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization buildAuthorization() {
    return this.authorization!=null?this.authorization.build():null;
  }
  public A withAuthorization(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization authorization) {
    _visitables.get("authorization").remove(this.authorization);
    if (authorization!=null){ this.authorization= new io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder(authorization); _visitables.get("authorization").add(this.authorization);} return (A) this;
  }
  public java.lang.Boolean hasAuthorization() {
    return this.authorization != null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.AuthorizationNested<A> withNewAuthorization() {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.AuthorizationNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.AuthorizationNested<A> withNewAuthorizationLike(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.AuthorizationNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(getAuthorization());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): new io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.AuthorizationNested<A> editOrNewAuthorizationLike(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization item) {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBasicAuth instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.monitoring.v1.BasicAuth getBasicAuth() {
    return this.basicAuth!=null?this.basicAuth.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.BasicAuth buildBasicAuth() {
    return this.basicAuth!=null?this.basicAuth.build():null;
  }
  public A withBasicAuth(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth basicAuth) {
    _visitables.get("basicAuth").remove(this.basicAuth);
    if (basicAuth!=null){ this.basicAuth= new io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} return (A) this;
  }
  public java.lang.Boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.BasicAuthNested<A> withNewBasicAuth() {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.BasicAuthNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.BasicAuthNested<A> withNewBasicAuthLike(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.BasicAuthNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.BasicAuthNested<A> editOrNewBasicAuthLike(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth item) {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
  }
  public java.lang.String getBearerTokenFile() {
    return this.bearerTokenFile;
  }
  public A withBearerTokenFile(java.lang.String bearerTokenFile) {
    this.bearerTokenFile=bearerTokenFile; return (A) this;
  }
  public java.lang.Boolean hasBearerTokenFile() {
    return this.bearerTokenFile != null;
  }
  
  /**
   * Method is deprecated. use withBearerTokenFile instead.
   */
  @java.lang.Deprecated
  public A withNewBearerTokenFile(java.lang.String arg0) {
    return (A)withBearerTokenFile(new String(arg0));
  }
  public io.fabric8.kubernetes.api.model.SecretKeySelector getBearerTokenSecret() {
    return this.bearerTokenSecret;
  }
  public A withBearerTokenSecret(io.fabric8.kubernetes.api.model.SecretKeySelector bearerTokenSecret) {
    this.bearerTokenSecret=bearerTokenSecret; return (A) this;
  }
  public java.lang.Boolean hasBearerTokenSecret() {
    return this.bearerTokenSecret != null;
  }
  public A withNewBearerTokenSecret(java.lang.String key,java.lang.String name,java.lang.Boolean optional) {
    return (A)withBearerTokenSecret(new SecretKeySelector(key, name, optional));
  }
  public java.lang.Boolean getHonorLabels() {
    return this.honorLabels;
  }
  public A withHonorLabels(java.lang.Boolean honorLabels) {
    this.honorLabels=honorLabels; return (A) this;
  }
  public java.lang.Boolean hasHonorLabels() {
    return this.honorLabels != null;
  }
  public java.lang.Boolean getHonorTimestamps() {
    return this.honorTimestamps;
  }
  public A withHonorTimestamps(java.lang.Boolean honorTimestamps) {
    this.honorTimestamps=honorTimestamps; return (A) this;
  }
  public java.lang.Boolean hasHonorTimestamps() {
    return this.honorTimestamps != null;
  }
  public java.lang.String getInterval() {
    return this.interval;
  }
  public A withInterval(java.lang.String interval) {
    this.interval=interval; return (A) this;
  }
  public java.lang.Boolean hasInterval() {
    return this.interval != null;
  }
  
  /**
   * Method is deprecated. use withInterval instead.
   */
  @java.lang.Deprecated
  public A withNewInterval(java.lang.String arg0) {
    return (A)withInterval(new String(arg0));
  }
  public A addToMetricRelabelings(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(index >= 0 ? index : _visitables.get("metricRelabelings").size(), builder);this.metricRelabelings.add(index >= 0 ? index : metricRelabelings.size(), builder); return (A)this;
  }
  public A setToMetricRelabelings(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("metricRelabelings").size()) { _visitables.get("metricRelabelings").add(builder); } else { _visitables.get("metricRelabelings").set(index, builder);}
    if (index < 0 || index >= metricRelabelings.size()) { metricRelabelings.add(builder); } else { metricRelabelings.set(index, builder);}
     return (A)this;
  }
  public A addToMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
  }
  public A addAllToMetricRelabelings(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
  }
  public A removeFromMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder);if (this.metricRelabelings != null) {this.metricRelabelings.remove(builder);}} return (A)this;
  }
  public A removeAllFromMetricRelabelings(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder);if (this.metricRelabelings != null) {this.metricRelabelings.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMetricRelabelings(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    if (metricRelabelings == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> each = metricRelabelings.iterator();
    final List visitables = _visitables.get("metricRelabelings");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMetricRelabelings instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> getMetricRelabelings() {
    return build(metricRelabelings);
  }
  public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> buildMetricRelabelings() {
    return build(metricRelabelings);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildMetricRelabeling(java.lang.Integer index) {
    return this.metricRelabelings.get(index).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildFirstMetricRelabeling() {
    return this.metricRelabelings.get(0).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildLastMetricRelabeling() {
    return this.metricRelabelings.get(metricRelabelings.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildMatchingMetricRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: metricRelabelings) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingMetricRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: metricRelabelings) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMetricRelabelings(java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> metricRelabelings) {
    if (this.metricRelabelings != null) { _visitables.get("metricRelabelings").removeAll(this.metricRelabelings);}
    if (metricRelabelings != null) {this.metricRelabelings = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : metricRelabelings){this.addToMetricRelabelings(item);}} else { this.metricRelabelings = null;} return (A) this;
  }
  public A withMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... metricRelabelings) {
    if (this.metricRelabelings != null) {this.metricRelabelings.clear();}
    if (metricRelabelings != null) {for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item :metricRelabelings){ this.addToMetricRelabelings(item);}} return (A) this;
  }
  public java.lang.Boolean hasMetricRelabelings() {
    return metricRelabelings != null && !metricRelabelings.isEmpty();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabeling() {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.MetricRelabelingsNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabelingLike(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.MetricRelabelingsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.MetricRelabelingsNested<A> setNewMetricRelabelingLike(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.MetricRelabelingsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.MetricRelabelingsNested<A> editMetricRelabeling(java.lang.Integer index) {
    if (metricRelabelings.size() <= index) throw new RuntimeException("Can't edit metricRelabelings. Index exceeds size.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.MetricRelabelingsNested<A> editFirstMetricRelabeling() {
    if (metricRelabelings.size() == 0) throw new RuntimeException("Can't edit first metricRelabelings. The list is empty.");
    return setNewMetricRelabelingLike(0, buildMetricRelabeling(0));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.MetricRelabelingsNested<A> editLastMetricRelabeling() {
    int index = metricRelabelings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last metricRelabelings. The list is empty.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.MetricRelabelingsNested<A> editMatchingMetricRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<metricRelabelings.size();i++) { 
    if (predicate.test(metricRelabelings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching metricRelabelings. No match found.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  
  /**
   * This method has been deprecated, please use method buildOauth2 instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.monitoring.v1.OAuth2 getOauth2() {
    return this.oauth2!=null?this.oauth2.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.OAuth2 buildOauth2() {
    return this.oauth2!=null?this.oauth2.build():null;
  }
  public A withOauth2(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 oauth2) {
    _visitables.get("oauth2").remove(this.oauth2);
    if (oauth2!=null){ this.oauth2= new io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder(oauth2); _visitables.get("oauth2").add(this.oauth2);} return (A) this;
  }
  public java.lang.Boolean hasOauth2() {
    return this.oauth2 != null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.Oauth2Nested<A> withNewOauth2() {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.Oauth2NestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.Oauth2Nested<A> withNewOauth2Like(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.Oauth2NestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.Oauth2Nested<A> editOauth2() {
    return withNewOauth2Like(getOauth2());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.Oauth2Nested<A> editOrNewOauth2() {
    return withNewOauth2Like(getOauth2() != null ? getOauth2(): new io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.Oauth2Nested<A> editOrNewOauth2Like(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 item) {
    return withNewOauth2Like(getOauth2() != null ? getOauth2(): item);
  }
  public A addToParams(java.lang.String key,java.util.ArrayList<java.lang.String> value) {
    if(this.params == null && key != null && value != null) { this.params = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.params.put(key, value);} return (A)this;
  }
  public A addToParams(java.util.Map<java.lang.String,java.util.ArrayList<java.lang.String>> map) {
    if(this.params == null && map != null) { this.params = new java.util.LinkedHashMap(); }
    if(map != null) { this.params.putAll(map);} return (A)this;
  }
  public A removeFromParams(java.lang.String key) {
    if(this.params == null) { return (A) this; }
    if(key != null && this.params != null) {this.params.remove(key);} return (A)this;
  }
  public A removeFromParams(java.util.Map<java.lang.String,java.util.ArrayList<java.lang.String>> map) {
    if(this.params == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.params != null){this.params.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.util.ArrayList<java.lang.String>> getParams() {
    return this.params;
  }
  public <K,V>A withParams(java.util.Map<java.lang.String,java.util.ArrayList<java.lang.String>> params) {
    if (params == null) { this.params =  null;} else {this.params = new java.util.LinkedHashMap(params);} return (A) this;
  }
  public java.lang.Boolean hasParams() {
    return this.params != null;
  }
  public java.lang.String getPath() {
    return this.path;
  }
  public A withPath(java.lang.String path) {
    this.path=path; return (A) this;
  }
  public java.lang.Boolean hasPath() {
    return this.path != null;
  }
  
  /**
   * Method is deprecated. use withPath instead.
   */
  @java.lang.Deprecated
  public A withNewPath(java.lang.String arg0) {
    return (A)withPath(new String(arg0));
  }
  public java.lang.String getPort() {
    return this.port;
  }
  public A withPort(java.lang.String port) {
    this.port=port; return (A) this;
  }
  public java.lang.Boolean hasPort() {
    return this.port != null;
  }
  
  /**
   * Method is deprecated. use withPort instead.
   */
  @java.lang.Deprecated
  public A withNewPort(java.lang.String arg0) {
    return (A)withPort(new String(arg0));
  }
  public java.lang.String getProxyUrl() {
    return this.proxyUrl;
  }
  public A withProxyUrl(java.lang.String proxyUrl) {
    this.proxyUrl=proxyUrl; return (A) this;
  }
  public java.lang.Boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  
  /**
   * Method is deprecated. use withProxyUrl instead.
   */
  @java.lang.Deprecated
  public A withNewProxyUrl(java.lang.String arg0) {
    return (A)withProxyUrl(new String(arg0));
  }
  public A addToRelabelings(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    if (this.relabelings == null) {this.relabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").add(index >= 0 ? index : _visitables.get("relabelings").size(), builder);this.relabelings.add(index >= 0 ? index : relabelings.size(), builder); return (A)this;
  }
  public A setToRelabelings(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    if (this.relabelings == null) {this.relabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("relabelings").size()) { _visitables.get("relabelings").add(builder); } else { _visitables.get("relabelings").set(index, builder);}
    if (index < 0 || index >= relabelings.size()) { relabelings.add(builder); } else { relabelings.set(index, builder);}
     return (A)this;
  }
  public A addToRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.relabelings == null) {this.relabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
  }
  public A addAllToRelabelings(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
    if (this.relabelings == null) {this.relabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
  }
  public A removeFromRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder);if (this.relabelings != null) {this.relabelings.remove(builder);}} return (A)this;
  }
  public A removeAllFromRelabelings(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder);if (this.relabelings != null) {this.relabelings.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRelabelings(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    if (relabelings == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> each = relabelings.iterator();
    final List visitables = _visitables.get("relabelings");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRelabelings instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> getRelabelings() {
    return build(relabelings);
  }
  public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> buildRelabelings() {
    return build(relabelings);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildRelabeling(java.lang.Integer index) {
    return this.relabelings.get(index).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildFirstRelabeling() {
    return this.relabelings.get(0).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildLastRelabeling() {
    return this.relabelings.get(relabelings.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildMatchingRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: relabelings) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: relabelings) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelabelings(java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> relabelings) {
    if (this.relabelings != null) { _visitables.get("relabelings").removeAll(this.relabelings);}
    if (relabelings != null) {this.relabelings = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : relabelings){this.addToRelabelings(item);}} else { this.relabelings = null;} return (A) this;
  }
  public A withRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... relabelings) {
    if (this.relabelings != null) {this.relabelings.clear();}
    if (relabelings != null) {for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item :relabelings){ this.addToRelabelings(item);}} return (A) this;
  }
  public java.lang.Boolean hasRelabelings() {
    return relabelings != null && !relabelings.isEmpty();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.RelabelingsNested<A> addNewRelabeling() {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.RelabelingsNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.RelabelingsNested<A> addNewRelabelingLike(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.RelabelingsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.RelabelingsNested<A> setNewRelabelingLike(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.RelabelingsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.RelabelingsNested<A> editRelabeling(java.lang.Integer index) {
    if (relabelings.size() <= index) throw new RuntimeException("Can't edit relabelings. Index exceeds size.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.RelabelingsNested<A> editFirstRelabeling() {
    if (relabelings.size() == 0) throw new RuntimeException("Can't edit first relabelings. The list is empty.");
    return setNewRelabelingLike(0, buildRelabeling(0));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.RelabelingsNested<A> editLastRelabeling() {
    int index = relabelings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relabelings. The list is empty.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.RelabelingsNested<A> editMatchingRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relabelings.size();i++) { 
    if (predicate.test(relabelings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relabelings. No match found.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  public java.lang.String getScheme() {
    return this.scheme;
  }
  public A withScheme(java.lang.String scheme) {
    this.scheme=scheme; return (A) this;
  }
  public java.lang.Boolean hasScheme() {
    return this.scheme != null;
  }
  
  /**
   * Method is deprecated. use withScheme instead.
   */
  @java.lang.Deprecated
  public A withNewScheme(java.lang.String arg0) {
    return (A)withScheme(new String(arg0));
  }
  public java.lang.String getScrapeTimeout() {
    return this.scrapeTimeout;
  }
  public A withScrapeTimeout(java.lang.String scrapeTimeout) {
    this.scrapeTimeout=scrapeTimeout; return (A) this;
  }
  public java.lang.Boolean hasScrapeTimeout() {
    return this.scrapeTimeout != null;
  }
  
  /**
   * Method is deprecated. use withScrapeTimeout instead.
   */
  @java.lang.Deprecated
  public A withNewScrapeTimeout(java.lang.String arg0) {
    return (A)withScrapeTimeout(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildTargetPort instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.IntOrString getTargetPort() {
    return this.targetPort!=null?this.targetPort.build():null;
  }
  public io.fabric8.kubernetes.api.model.IntOrString buildTargetPort() {
    return this.targetPort!=null?this.targetPort.build():null;
  }
  public A withTargetPort(io.fabric8.kubernetes.api.model.IntOrString targetPort) {
    _visitables.get("targetPort").remove(this.targetPort);
    if (targetPort!=null){ this.targetPort= new io.fabric8.kubernetes.api.model.IntOrStringBuilder(targetPort); _visitables.get("targetPort").add(this.targetPort);} return (A) this;
  }
  public java.lang.Boolean hasTargetPort() {
    return this.targetPort != null;
  }
  public A withNewTargetPort(java.lang.Integer intVal) {
    return (A)withTargetPort(new IntOrString(intVal));
  }
  public A withNewTargetPort(java.lang.String strVal) {
    return (A)withTargetPort(new IntOrString(strVal));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.TargetPortNested<A> withNewTargetPort() {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.TargetPortNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.TargetPortNested<A> withNewTargetPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.TargetPortNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.TargetPortNested<A> editTargetPort() {
    return withNewTargetPortLike(getTargetPort());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.TargetPortNested<A> editOrNewTargetPort() {
    return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): new io.fabric8.kubernetes.api.model.IntOrStringBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.TargetPortNested<A> editOrNewTargetPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
    return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTlsConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.monitoring.v1.TLSConfig getTlsConfig() {
    return this.tlsConfig!=null?this.tlsConfig.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.TLSConfig buildTlsConfig() {
    return this.tlsConfig!=null?this.tlsConfig.build():null;
  }
  public A withTlsConfig(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig tlsConfig) {
    _visitables.get("tlsConfig").remove(this.tlsConfig);
    if (tlsConfig!=null){ this.tlsConfig= new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} return (A) this;
  }
  public java.lang.Boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.TlsConfigNested<A> withNewTlsConfig() {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.TlsConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.TlsConfigNested<A> withNewTlsConfigLike(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl.TlsConfigNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.TlsConfigNested<A> editOrNewTlsConfigLike(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig item) {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EndpointFluentImpl that = (EndpointFluentImpl) o;
    if (authorization != null ? !authorization.equals(that.authorization) :that.authorization != null) return false;
    if (basicAuth != null ? !basicAuth.equals(that.basicAuth) :that.basicAuth != null) return false;
    if (bearerTokenFile != null ? !bearerTokenFile.equals(that.bearerTokenFile) :that.bearerTokenFile != null) return false;
    if (bearerTokenSecret != null ? !bearerTokenSecret.equals(that.bearerTokenSecret) :that.bearerTokenSecret != null) return false;
    if (honorLabels != null ? !honorLabels.equals(that.honorLabels) :that.honorLabels != null) return false;
    if (honorTimestamps != null ? !honorTimestamps.equals(that.honorTimestamps) :that.honorTimestamps != null) return false;
    if (interval != null ? !interval.equals(that.interval) :that.interval != null) return false;
    if (metricRelabelings != null ? !metricRelabelings.equals(that.metricRelabelings) :that.metricRelabelings != null) return false;
    if (oauth2 != null ? !oauth2.equals(that.oauth2) :that.oauth2 != null) return false;
    if (params != null ? !params.equals(that.params) :that.params != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (proxyUrl != null ? !proxyUrl.equals(that.proxyUrl) :that.proxyUrl != null) return false;
    if (relabelings != null ? !relabelings.equals(that.relabelings) :that.relabelings != null) return false;
    if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
    if (scrapeTimeout != null ? !scrapeTimeout.equals(that.scrapeTimeout) :that.scrapeTimeout != null) return false;
    if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
    if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerTokenFile,  bearerTokenSecret,  honorLabels,  honorTimestamps,  interval,  metricRelabelings,  oauth2,  params,  path,  port,  proxyUrl,  relabelings,  scheme,  scrapeTimeout,  targetPort,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  public class AuthorizationNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.AuthorizationNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.AuthorizationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AuthorizationNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization item) {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder(this, item);
    }
    AuthorizationNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withAuthorization(builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  public class BasicAuthNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.BasicAuthNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.BasicAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BasicAuthNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth item) {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder(this, item);
    }
    BasicAuthNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withBasicAuth(builder.build());
    }
    public N endBasicAuth() {
      return and();
    }
    
  }
  public class MetricRelabelingsNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.MetricRelabelingsNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.MetricRelabelingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetricRelabelingsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(this, item);
    }
    MetricRelabelingsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) EndpointFluentImpl.this.setToMetricRelabelings(index,builder.build());
    }
    public N endMetricRelabeling() {
      return and();
    }
    
  }
  public class Oauth2NestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.OAuth2FluentImpl<io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.Oauth2Nested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.Oauth2Nested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    Oauth2NestedImpl(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 item) {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder(this, item);
    }
    Oauth2NestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withOauth2(builder.build());
    }
    public N endOauth2() {
      return and();
    }
    
  }
  public class RelabelingsNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.RelabelingsNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.RelabelingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RelabelingsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(this, item);
    }
    RelabelingsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) EndpointFluentImpl.this.setToRelabelings(index,builder.build());
    }
    public N endRelabeling() {
      return and();
    }
    
  }
  public class TargetPortNestedImpl<N> extends io.fabric8.kubernetes.api.model.IntOrStringFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.TargetPortNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.TargetPortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TargetPortNestedImpl(io.fabric8.kubernetes.api.model.IntOrString item) {
      this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this, item);
    }
    TargetPortNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this);
    }
    io.fabric8.kubernetes.api.model.IntOrStringBuilder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withTargetPort(builder.build());
    }
    public N endTargetPort() {
      return and();
    }
    
  }
  public class TlsConfigNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.TlsConfigNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent.TlsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TlsConfigNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig item) {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder(this, item);
    }
    TlsConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withTlsConfig(builder.build());
    }
    public N endTlsConfig() {
      return and();
    }
    
  }
  
}