package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AuthorizationBuilder extends io.fabric8.openshift.api.model.monitoring.v1.AuthorizationFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.AuthorizationBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.Authorization,io.fabric8.openshift.api.model.monitoring.v1.AuthorizationBuilder>{
  public AuthorizationBuilder() {
    this(false);
  }
  public AuthorizationBuilder(java.lang.Boolean validationEnabled) {
    this(new Authorization(), validationEnabled);
  }
  public AuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.AuthorizationFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.AuthorizationFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Authorization(), validationEnabled);
  }
  public AuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.AuthorizationFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Authorization instance) {
    this(fluent, instance, false);
  }
  public AuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.AuthorizationFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Authorization instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCredentials(instance.getCredentials()); 
    fluent.withCredentialsFile(instance.getCredentialsFile()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.Authorization instance) {
    this(instance,false);
  }
  public AuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.Authorization instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCredentials(instance.getCredentials()); 
    this.withCredentialsFile(instance.getCredentialsFile()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.AuthorizationFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.Authorization build() {
    Authorization buildable = new Authorization(fluent.getCredentials(),fluent.getCredentialsFile(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AuthorizationBuilder that = (AuthorizationBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}