package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ServiceMonitorSpecBuilder extends io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpec,io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecBuilder>{
  public ServiceMonitorSpecBuilder() {
    this(false);
  }
  public ServiceMonitorSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ServiceMonitorSpec(), validationEnabled);
  }
  public ServiceMonitorSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceMonitorSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceMonitorSpec(), validationEnabled);
  }
  public ServiceMonitorSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpec instance) {
    this(fluent, instance, false);
  }
  public ServiceMonitorSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEndpoints(instance.getEndpoints()); 
    fluent.withJobLabel(instance.getJobLabel()); 
    fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
    fluent.withPodTargetLabels(instance.getPodTargetLabels()); 
    fluent.withSampleLimit(instance.getSampleLimit()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTargetLabels(instance.getTargetLabels()); 
    fluent.withTargetLimit(instance.getTargetLimit()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceMonitorSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpec instance) {
    this(instance,false);
  }
  public ServiceMonitorSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEndpoints(instance.getEndpoints()); 
    this.withJobLabel(instance.getJobLabel()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withPodTargetLabels(instance.getPodTargetLabels()); 
    this.withSampleLimit(instance.getSampleLimit()); 
    this.withSelector(instance.getSelector()); 
    this.withTargetLabels(instance.getTargetLabels()); 
    this.withTargetLimit(instance.getTargetLimit()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorSpec build() {
    ServiceMonitorSpec buildable = new ServiceMonitorSpec(fluent.getEndpoints(),fluent.getJobLabel(),fluent.getNamespaceSelector(),fluent.getPodTargetLabels(),fluent.getSampleLimit(),fluent.getSelector(),fluent.getTargetLabels(),fluent.getTargetLimit());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceMonitorSpecBuilder that = (ServiceMonitorSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}