package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class QuerySpecFluentImpl<A extends QuerySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements QuerySpecFluent<A> {

    private String lookbackDelta;
    private Integer maxConcurrency;
    private Integer maxSamples;
    private String timeout;

    public QuerySpecFluentImpl() {
    }

    public QuerySpecFluentImpl(QuerySpec instance) {
        this.withLookbackDelta(instance.getLookbackDelta()); 
        this.withMaxConcurrency(instance.getMaxConcurrency()); 
        this.withMaxSamples(instance.getMaxSamples()); 
        this.withTimeout(instance.getTimeout()); 
    }

    public String getLookbackDelta() {
        return this.lookbackDelta;
    }

    public A withLookbackDelta(String lookbackDelta) {
        this.lookbackDelta=lookbackDelta; return (A) this;
    }

    public Boolean hasLookbackDelta() {
        return this.lookbackDelta != null;
    }

    public A withNewLookbackDelta(String arg1) {
        return (A)withLookbackDelta(new String(arg1));
    }

    public A withNewLookbackDelta(StringBuilder arg1) {
        return (A)withLookbackDelta(new String(arg1));
    }

    public A withNewLookbackDelta(StringBuffer arg1) {
        return (A)withLookbackDelta(new String(arg1));
    }

    public Integer getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public A withMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency=maxConcurrency; return (A) this;
    }

    public Boolean hasMaxConcurrency() {
        return this.maxConcurrency != null;
    }

    public A withNewMaxConcurrency(String arg1) {
        return (A)withMaxConcurrency(new Integer(arg1));
    }

    public A withNewMaxConcurrency(int arg1) {
        return (A)withMaxConcurrency(new Integer(arg1));
    }

    public Integer getMaxSamples() {
        return this.maxSamples;
    }

    public A withMaxSamples(Integer maxSamples) {
        this.maxSamples=maxSamples; return (A) this;
    }

    public Boolean hasMaxSamples() {
        return this.maxSamples != null;
    }

    public A withNewMaxSamples(String arg1) {
        return (A)withMaxSamples(new Integer(arg1));
    }

    public A withNewMaxSamples(int arg1) {
        return (A)withMaxSamples(new Integer(arg1));
    }

    public String getTimeout() {
        return this.timeout;
    }

    public A withTimeout(String timeout) {
        this.timeout=timeout; return (A) this;
    }

    public Boolean hasTimeout() {
        return this.timeout != null;
    }

    public A withNewTimeout(String arg1) {
        return (A)withTimeout(new String(arg1));
    }

    public A withNewTimeout(StringBuilder arg1) {
        return (A)withTimeout(new String(arg1));
    }

    public A withNewTimeout(StringBuffer arg1) {
        return (A)withTimeout(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        QuerySpecFluentImpl that = (QuerySpecFluentImpl) o;
        if (lookbackDelta != null ? !lookbackDelta.equals(that.lookbackDelta) :that.lookbackDelta != null) return false;
        if (maxConcurrency != null ? !maxConcurrency.equals(that.maxConcurrency) :that.maxConcurrency != null) return false;
        if (maxSamples != null ? !maxSamples.equals(that.maxSamples) :that.maxSamples != null) return false;
        if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(lookbackDelta,  maxConcurrency,  maxSamples,  timeout,  super.hashCode());
    }

}
