package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PrometheusRuleSpecFluentImpl<A extends PrometheusRuleSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PrometheusRuleSpecFluent<A> {

    private List<RuleGroupBuilder> groups =  new ArrayList<RuleGroupBuilder>();

    public PrometheusRuleSpecFluentImpl() {
    }

    public PrometheusRuleSpecFluentImpl(PrometheusRuleSpec instance) {
        this.withGroups(instance.getGroups()); 
    }

    public A addToGroups(int index,RuleGroup item) {
        if (this.groups == null) {this.groups = new ArrayList<RuleGroupBuilder>();}
        RuleGroupBuilder builder = new RuleGroupBuilder(item);_visitables.get("groups").add(index >= 0 ? index : _visitables.get("groups").size(), builder);this.groups.add(index >= 0 ? index : groups.size(), builder); return (A)this;
    }

    public A setToGroups(int index,RuleGroup item) {
        if (this.groups == null) {this.groups = new ArrayList<RuleGroupBuilder>();}
        RuleGroupBuilder builder = new RuleGroupBuilder(item);
        if (index < 0 || index >= _visitables.get("groups").size()) { _visitables.get("groups").add(builder); } else { _visitables.get("groups").set(index, builder);}
        if (index < 0 || index >= groups.size()) { groups.add(builder); } else { groups.set(index, builder);}
         return (A)this;
    }

    public A addToGroups(RuleGroup... items) {
        if (this.groups == null) {this.groups = new ArrayList<RuleGroupBuilder>();}
        for (RuleGroup item : items) {RuleGroupBuilder builder = new RuleGroupBuilder(item);_visitables.get("groups").add(builder);this.groups.add(builder);} return (A)this;
    }

    public A addAllToGroups(Collection<RuleGroup> items) {
        if (this.groups == null) {this.groups = new ArrayList<RuleGroupBuilder>();}
        for (RuleGroup item : items) {RuleGroupBuilder builder = new RuleGroupBuilder(item);_visitables.get("groups").add(builder);this.groups.add(builder);} return (A)this;
    }

    public A removeFromGroups(RuleGroup... items) {
        for (RuleGroup item : items) {RuleGroupBuilder builder = new RuleGroupBuilder(item);_visitables.get("groups").remove(builder);if (this.groups != null) {this.groups.remove(builder);}} return (A)this;
    }

    public A removeAllFromGroups(Collection<RuleGroup> items) {
        for (RuleGroup item : items) {RuleGroupBuilder builder = new RuleGroupBuilder(item);_visitables.get("groups").remove(builder);if (this.groups != null) {this.groups.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromGroups(Predicate<RuleGroupBuilder> predicate) {
        if (groups == null) return (A) this;
        final Iterator<RuleGroupBuilder> each = groups.iterator();
        final List visitables = _visitables.get("groups");
        while (each.hasNext()) {
          RuleGroupBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildGroups instead.
 * @return The buildable object.
 */
@Deprecated public List<RuleGroup> getGroups() {
        return build(groups);
    }

    public List<RuleGroup> buildGroups() {
        return build(groups);
    }

    public RuleGroup buildGroup(int index) {
        return this.groups.get(index).build();
    }

    public RuleGroup buildFirstGroup() {
        return this.groups.get(0).build();
    }

    public RuleGroup buildLastGroup() {
        return this.groups.get(groups.size() - 1).build();
    }

    public RuleGroup buildMatchingGroup(Predicate<RuleGroupBuilder> predicate) {
        for (RuleGroupBuilder item: groups) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingGroup(Predicate<RuleGroupBuilder> predicate) {
        for (RuleGroupBuilder item: groups) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withGroups(List<RuleGroup> groups) {
        if (this.groups != null) { _visitables.get("groups").removeAll(this.groups);}
        if (groups != null) {this.groups = new ArrayList<RuleGroupBuilder>(); for (RuleGroup item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
    }

    public A withGroups(RuleGroup... groups) {
        if (this.groups != null) {this.groups.clear();}
        if (groups != null) {for (RuleGroup item :groups){ this.addToGroups(item);}} return (A) this;
    }

    public Boolean hasGroups() {
        return groups != null && !groups.isEmpty();
    }

    public PrometheusRuleSpecFluent.GroupsNested<A> addNewGroup() {
        return new GroupsNestedImpl();
    }

    public PrometheusRuleSpecFluent.GroupsNested<A> addNewGroupLike(RuleGroup item) {
        return new GroupsNestedImpl(-1, item);
    }

    public PrometheusRuleSpecFluent.GroupsNested<A> setNewGroupLike(int index,RuleGroup item) {
        return new GroupsNestedImpl(index, item);
    }

    public PrometheusRuleSpecFluent.GroupsNested<A> editGroup(int index) {
        if (groups.size() <= index) throw new RuntimeException("Can't edit groups. Index exceeds size.");
        return setNewGroupLike(index, buildGroup(index));
    }

    public PrometheusRuleSpecFluent.GroupsNested<A> editFirstGroup() {
        if (groups.size() == 0) throw new RuntimeException("Can't edit first groups. The list is empty.");
        return setNewGroupLike(0, buildGroup(0));
    }

    public PrometheusRuleSpecFluent.GroupsNested<A> editLastGroup() {
        int index = groups.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last groups. The list is empty.");
        return setNewGroupLike(index, buildGroup(index));
    }

    public PrometheusRuleSpecFluent.GroupsNested<A> editMatchingGroup(Predicate<RuleGroupBuilder> predicate) {
        int index = -1;
        for (int i=0;i<groups.size();i++) { 
        if (predicate.test(groups.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching groups. No match found.");
        return setNewGroupLike(index, buildGroup(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PrometheusRuleSpecFluentImpl that = (PrometheusRuleSpecFluentImpl) o;
        if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(groups,  super.hashCode());
    }

    public class GroupsNestedImpl<N> extends RuleGroupFluentImpl<PrometheusRuleSpecFluent.GroupsNested<N>> implements PrometheusRuleSpecFluent.GroupsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RuleGroupBuilder builder;
        private final int index;

            GroupsNestedImpl(int index,RuleGroup item) {
                this.index = index;
                this.builder = new RuleGroupBuilder(this, item);
                        
            }

            GroupsNestedImpl() {
                this.index = -1;
                this.builder = new RuleGroupBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusRuleSpecFluentImpl.this.setToGroups(index,builder.build());
            }

            public N endGroup() {
                return and();
            }
    }


}
