package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class RelabelConfigFluentImpl<A extends RelabelConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RelabelConfigFluent<A> {

    private String action;
    private Long modulus;
    private String regex;
    private String replacement;
    private String separator;
    private List<String> sourceLabels = new ArrayList<String>();
    private String targetLabel;

    public RelabelConfigFluentImpl() {
    }

    public RelabelConfigFluentImpl(RelabelConfig instance) {
        this.withAction(instance.getAction()); 
        this.withModulus(instance.getModulus()); 
        this.withRegex(instance.getRegex()); 
        this.withReplacement(instance.getReplacement()); 
        this.withSeparator(instance.getSeparator()); 
        this.withSourceLabels(instance.getSourceLabels()); 
        this.withTargetLabel(instance.getTargetLabel()); 
    }

    public String getAction() {
        return this.action;
    }

    public A withAction(String action) {
        this.action=action; return (A) this;
    }

    public Boolean hasAction() {
        return this.action != null;
    }

    public A withNewAction(String arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(StringBuilder arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(StringBuffer arg1) {
        return (A)withAction(new String(arg1));
    }

    public Long getModulus() {
        return this.modulus;
    }

    public A withModulus(Long modulus) {
        this.modulus=modulus; return (A) this;
    }

    public Boolean hasModulus() {
        return this.modulus != null;
    }

    public A withNewModulus(String arg1) {
        return (A)withModulus(new Long(arg1));
    }

    public A withNewModulus(long arg1) {
        return (A)withModulus(new Long(arg1));
    }

    public String getRegex() {
        return this.regex;
    }

    public A withRegex(String regex) {
        this.regex=regex; return (A) this;
    }

    public Boolean hasRegex() {
        return this.regex != null;
    }

    public A withNewRegex(String arg1) {
        return (A)withRegex(new String(arg1));
    }

    public A withNewRegex(StringBuilder arg1) {
        return (A)withRegex(new String(arg1));
    }

    public A withNewRegex(StringBuffer arg1) {
        return (A)withRegex(new String(arg1));
    }

    public String getReplacement() {
        return this.replacement;
    }

    public A withReplacement(String replacement) {
        this.replacement=replacement; return (A) this;
    }

    public Boolean hasReplacement() {
        return this.replacement != null;
    }

    public A withNewReplacement(String arg1) {
        return (A)withReplacement(new String(arg1));
    }

    public A withNewReplacement(StringBuilder arg1) {
        return (A)withReplacement(new String(arg1));
    }

    public A withNewReplacement(StringBuffer arg1) {
        return (A)withReplacement(new String(arg1));
    }

    public String getSeparator() {
        return this.separator;
    }

    public A withSeparator(String separator) {
        this.separator=separator; return (A) this;
    }

    public Boolean hasSeparator() {
        return this.separator != null;
    }

    public A withNewSeparator(String arg1) {
        return (A)withSeparator(new String(arg1));
    }

    public A withNewSeparator(StringBuilder arg1) {
        return (A)withSeparator(new String(arg1));
    }

    public A withNewSeparator(StringBuffer arg1) {
        return (A)withSeparator(new String(arg1));
    }

    public A addToSourceLabels(int index,String item) {
        if (this.sourceLabels == null) {this.sourceLabels = new ArrayList<String>();}
        this.sourceLabels.add(index, item);
        return (A)this;
    }

    public A setToSourceLabels(int index,String item) {
        if (this.sourceLabels == null) {this.sourceLabels = new ArrayList<String>();}
        this.sourceLabels.set(index, item); return (A)this;
    }

    public A addToSourceLabels(String... items) {
        if (this.sourceLabels == null) {this.sourceLabels = new ArrayList<String>();}
        for (String item : items) {this.sourceLabels.add(item);} return (A)this;
    }

    public A addAllToSourceLabels(Collection<String> items) {
        if (this.sourceLabels == null) {this.sourceLabels = new ArrayList<String>();}
        for (String item : items) {this.sourceLabels.add(item);} return (A)this;
    }

    public A removeFromSourceLabels(String... items) {
        for (String item : items) {if (this.sourceLabels!= null){ this.sourceLabels.remove(item);}} return (A)this;
    }

    public A removeAllFromSourceLabels(Collection<String> items) {
        for (String item : items) {if (this.sourceLabels!= null){ this.sourceLabels.remove(item);}} return (A)this;
    }

    public List<String> getSourceLabels() {
        return this.sourceLabels;
    }

    public String getSourceLabel(int index) {
        return this.sourceLabels.get(index);
    }

    public String getFirstSourceLabel() {
        return this.sourceLabels.get(0);
    }

    public String getLastSourceLabel() {
        return this.sourceLabels.get(sourceLabels.size() - 1);
    }

    public String getMatchingSourceLabel(Predicate<String> predicate) {
        for (String item: sourceLabels) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingSourceLabel(Predicate<String> predicate) {
        for (String item: sourceLabels) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSourceLabels(List<String> sourceLabels) {
        if (this.sourceLabels != null) { _visitables.get("sourceLabels").removeAll(this.sourceLabels);}
        if (sourceLabels != null) {this.sourceLabels = new ArrayList<String>(); for (String item : sourceLabels){this.addToSourceLabels(item);}} else { this.sourceLabels = null;} return (A) this;
    }

    public A withSourceLabels(String... sourceLabels) {
        if (this.sourceLabels != null) {this.sourceLabels.clear();}
        if (sourceLabels != null) {for (String item :sourceLabels){ this.addToSourceLabels(item);}} return (A) this;
    }

    public Boolean hasSourceLabels() {
        return sourceLabels != null && !sourceLabels.isEmpty();
    }

    public A addNewSourceLabel(String arg1) {
        return (A)addToSourceLabels(new String(arg1));
    }

    public A addNewSourceLabel(StringBuilder arg1) {
        return (A)addToSourceLabels(new String(arg1));
    }

    public A addNewSourceLabel(StringBuffer arg1) {
        return (A)addToSourceLabels(new String(arg1));
    }

    public String getTargetLabel() {
        return this.targetLabel;
    }

    public A withTargetLabel(String targetLabel) {
        this.targetLabel=targetLabel; return (A) this;
    }

    public Boolean hasTargetLabel() {
        return this.targetLabel != null;
    }

    public A withNewTargetLabel(String arg1) {
        return (A)withTargetLabel(new String(arg1));
    }

    public A withNewTargetLabel(StringBuilder arg1) {
        return (A)withTargetLabel(new String(arg1));
    }

    public A withNewTargetLabel(StringBuffer arg1) {
        return (A)withTargetLabel(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RelabelConfigFluentImpl that = (RelabelConfigFluentImpl) o;
        if (action != null ? !action.equals(that.action) :that.action != null) return false;
        if (modulus != null ? !modulus.equals(that.modulus) :that.modulus != null) return false;
        if (regex != null ? !regex.equals(that.regex) :that.regex != null) return false;
        if (replacement != null ? !replacement.equals(that.replacement) :that.replacement != null) return false;
        if (separator != null ? !separator.equals(that.separator) :that.separator != null) return false;
        if (sourceLabels != null ? !sourceLabels.equals(that.sourceLabels) :that.sourceLabels != null) return false;
        if (targetLabel != null ? !targetLabel.equals(that.targetLabel) :that.targetLabel != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(action,  modulus,  regex,  replacement,  separator,  sourceLabels,  targetLabel,  super.hashCode());
    }

}
