package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class QueueConfigFluentImpl<A extends QueueConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements QueueConfigFluent<A> {

    private String batchSendDeadline;
    private Integer capacity;
    private String maxBackoff;
    private Integer maxRetries;
    private Integer maxSamplesPerSend;
    private Integer maxShards;
    private String minBackoff;
    private Integer minShards;

    public QueueConfigFluentImpl() {
    }

    public QueueConfigFluentImpl(QueueConfig instance) {
        this.withBatchSendDeadline(instance.getBatchSendDeadline()); 
        this.withCapacity(instance.getCapacity()); 
        this.withMaxBackoff(instance.getMaxBackoff()); 
        this.withMaxRetries(instance.getMaxRetries()); 
        this.withMaxSamplesPerSend(instance.getMaxSamplesPerSend()); 
        this.withMaxShards(instance.getMaxShards()); 
        this.withMinBackoff(instance.getMinBackoff()); 
        this.withMinShards(instance.getMinShards()); 
    }

    public String getBatchSendDeadline() {
        return this.batchSendDeadline;
    }

    public A withBatchSendDeadline(String batchSendDeadline) {
        this.batchSendDeadline=batchSendDeadline; return (A) this;
    }

    public Boolean hasBatchSendDeadline() {
        return this.batchSendDeadline != null;
    }

    public A withNewBatchSendDeadline(String arg1) {
        return (A)withBatchSendDeadline(new String(arg1));
    }

    public A withNewBatchSendDeadline(StringBuilder arg1) {
        return (A)withBatchSendDeadline(new String(arg1));
    }

    public A withNewBatchSendDeadline(StringBuffer arg1) {
        return (A)withBatchSendDeadline(new String(arg1));
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public A withCapacity(Integer capacity) {
        this.capacity=capacity; return (A) this;
    }

    public Boolean hasCapacity() {
        return this.capacity != null;
    }

    public A withNewCapacity(String arg1) {
        return (A)withCapacity(new Integer(arg1));
    }

    public A withNewCapacity(int arg1) {
        return (A)withCapacity(new Integer(arg1));
    }

    public String getMaxBackoff() {
        return this.maxBackoff;
    }

    public A withMaxBackoff(String maxBackoff) {
        this.maxBackoff=maxBackoff; return (A) this;
    }

    public Boolean hasMaxBackoff() {
        return this.maxBackoff != null;
    }

    public A withNewMaxBackoff(String arg1) {
        return (A)withMaxBackoff(new String(arg1));
    }

    public A withNewMaxBackoff(StringBuilder arg1) {
        return (A)withMaxBackoff(new String(arg1));
    }

    public A withNewMaxBackoff(StringBuffer arg1) {
        return (A)withMaxBackoff(new String(arg1));
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public A withMaxRetries(Integer maxRetries) {
        this.maxRetries=maxRetries; return (A) this;
    }

    public Boolean hasMaxRetries() {
        return this.maxRetries != null;
    }

    public A withNewMaxRetries(String arg1) {
        return (A)withMaxRetries(new Integer(arg1));
    }

    public A withNewMaxRetries(int arg1) {
        return (A)withMaxRetries(new Integer(arg1));
    }

    public Integer getMaxSamplesPerSend() {
        return this.maxSamplesPerSend;
    }

    public A withMaxSamplesPerSend(Integer maxSamplesPerSend) {
        this.maxSamplesPerSend=maxSamplesPerSend; return (A) this;
    }

    public Boolean hasMaxSamplesPerSend() {
        return this.maxSamplesPerSend != null;
    }

    public A withNewMaxSamplesPerSend(String arg1) {
        return (A)withMaxSamplesPerSend(new Integer(arg1));
    }

    public A withNewMaxSamplesPerSend(int arg1) {
        return (A)withMaxSamplesPerSend(new Integer(arg1));
    }

    public Integer getMaxShards() {
        return this.maxShards;
    }

    public A withMaxShards(Integer maxShards) {
        this.maxShards=maxShards; return (A) this;
    }

    public Boolean hasMaxShards() {
        return this.maxShards != null;
    }

    public A withNewMaxShards(String arg1) {
        return (A)withMaxShards(new Integer(arg1));
    }

    public A withNewMaxShards(int arg1) {
        return (A)withMaxShards(new Integer(arg1));
    }

    public String getMinBackoff() {
        return this.minBackoff;
    }

    public A withMinBackoff(String minBackoff) {
        this.minBackoff=minBackoff; return (A) this;
    }

    public Boolean hasMinBackoff() {
        return this.minBackoff != null;
    }

    public A withNewMinBackoff(String arg1) {
        return (A)withMinBackoff(new String(arg1));
    }

    public A withNewMinBackoff(StringBuilder arg1) {
        return (A)withMinBackoff(new String(arg1));
    }

    public A withNewMinBackoff(StringBuffer arg1) {
        return (A)withMinBackoff(new String(arg1));
    }

    public Integer getMinShards() {
        return this.minShards;
    }

    public A withMinShards(Integer minShards) {
        this.minShards=minShards; return (A) this;
    }

    public Boolean hasMinShards() {
        return this.minShards != null;
    }

    public A withNewMinShards(String arg1) {
        return (A)withMinShards(new Integer(arg1));
    }

    public A withNewMinShards(int arg1) {
        return (A)withMinShards(new Integer(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        QueueConfigFluentImpl that = (QueueConfigFluentImpl) o;
        if (batchSendDeadline != null ? !batchSendDeadline.equals(that.batchSendDeadline) :that.batchSendDeadline != null) return false;
        if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
        if (maxBackoff != null ? !maxBackoff.equals(that.maxBackoff) :that.maxBackoff != null) return false;
        if (maxRetries != null ? !maxRetries.equals(that.maxRetries) :that.maxRetries != null) return false;
        if (maxSamplesPerSend != null ? !maxSamplesPerSend.equals(that.maxSamplesPerSend) :that.maxSamplesPerSend != null) return false;
        if (maxShards != null ? !maxShards.equals(that.maxShards) :that.maxShards != null) return false;
        if (minBackoff != null ? !minBackoff.equals(that.minBackoff) :that.minBackoff != null) return false;
        if (minShards != null ? !minShards.equals(that.minShards) :that.minShards != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(batchSendDeadline,  capacity,  maxBackoff,  maxRetries,  maxSamplesPerSend,  maxShards,  minBackoff,  minShards,  super.hashCode());
    }

}
