package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StorageSpecBuilder extends StorageSpecFluentImpl<StorageSpecBuilder> implements VisitableBuilder<StorageSpec,StorageSpecBuilder> {

    StorageSpecFluent<?> fluent;
    Boolean validationEnabled;

    public StorageSpecBuilder() {
        this(true);
    }

    public StorageSpecBuilder(Boolean validationEnabled) {
        this(new StorageSpec(), validationEnabled);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new StorageSpec(), validationEnabled);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent,StorageSpec instance) {
        this(fluent, instance, true);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent,StorageSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDisableMountSubPath(instance.getDisableMountSubPath()); 
        fluent.withEmptyDir(instance.getEmptyDir()); 
        fluent.withVolumeClaimTemplate(instance.getVolumeClaimTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public StorageSpecBuilder(StorageSpec instance) {
        this(instance,true);
    }

    public StorageSpecBuilder(StorageSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDisableMountSubPath(instance.getDisableMountSubPath()); 
        this.withEmptyDir(instance.getEmptyDir()); 
        this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public StorageSpec build() {
        StorageSpec buildable = new StorageSpec(fluent.isDisableMountSubPath(),fluent.getEmptyDir(),fluent.getVolumeClaimTemplate());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StorageSpecBuilder that = (StorageSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
