package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

public interface ServiceMonitorSpecFluent<A extends ServiceMonitorSpecFluent<A>> extends Fluent<A> {


    public A addToEndpoints(int index,Endpoint item);
    public A setToEndpoints(int index,Endpoint item);
    public A addToEndpoints(Endpoint... items);
    public A addAllToEndpoints(Collection<Endpoint> items);
    public A removeFromEndpoints(Endpoint... items);
    public A removeAllFromEndpoints(Collection<Endpoint> items);
    public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<Endpoint> getEndpoints();
    public List<Endpoint> buildEndpoints();
    public Endpoint buildEndpoint(int index);
    public Endpoint buildFirstEndpoint();
    public Endpoint buildLastEndpoint();
    public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate);
    public Boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate);
    public A withEndpoints(List<Endpoint> endpoints);
    public A withEndpoints(Endpoint... endpoints);
    public Boolean hasEndpoints();
    public ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpoint();
    public ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpointLike(Endpoint item);
    public ServiceMonitorSpecFluent.EndpointsNested<A> setNewEndpointLike(int index,Endpoint item);
    public ServiceMonitorSpecFluent.EndpointsNested<A> editEndpoint(int index);
    public ServiceMonitorSpecFluent.EndpointsNested<A> editFirstEndpoint();
    public ServiceMonitorSpecFluent.EndpointsNested<A> editLastEndpoint();
    public ServiceMonitorSpecFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate);
    public String getJobLabel();
    public A withJobLabel(String jobLabel);
    public Boolean hasJobLabel();
    public A withNewJobLabel(String arg1);
    public A withNewJobLabel(StringBuilder arg1);
    public A withNewJobLabel(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public NamespaceSelector getNamespaceSelector();
    public NamespaceSelector buildNamespaceSelector();
    public A withNamespaceSelector(NamespaceSelector namespaceSelector);
    public Boolean hasNamespaceSelector();
    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector();
    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item);
    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector();
    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector();
    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item);
    public A addToPodTargetLabels(int index,String item);
    public A setToPodTargetLabels(int index,String item);
    public A addToPodTargetLabels(String... items);
    public A addAllToPodTargetLabels(Collection<String> items);
    public A removeFromPodTargetLabels(String... items);
    public A removeAllFromPodTargetLabels(Collection<String> items);
    public List<String> getPodTargetLabels();
    public String getPodTargetLabel(int index);
    public String getFirstPodTargetLabel();
    public String getLastPodTargetLabel();
    public String getMatchingPodTargetLabel(Predicate<String> predicate);
    public Boolean hasMatchingPodTargetLabel(Predicate<String> predicate);
    public A withPodTargetLabels(List<String> podTargetLabels);
    public A withPodTargetLabels(String... podTargetLabels);
    public Boolean hasPodTargetLabels();
    public A addNewPodTargetLabel(String arg1);
    public A addNewPodTargetLabel(StringBuilder arg1);
    public A addNewPodTargetLabel(StringBuffer arg1);
    public Long getSampleLimit();
    public A withSampleLimit(Long sampleLimit);
    public Boolean hasSampleLimit();
    public A withNewSampleLimit(String arg1);
    public A withNewSampleLimit(long arg1);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector();
    public LabelSelector buildSelector();
    public A withSelector(LabelSelector selector);
    public Boolean hasSelector();
    public ServiceMonitorSpecFluent.SelectorNested<A> withNewSelector();
    public ServiceMonitorSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public ServiceMonitorSpecFluent.SelectorNested<A> editSelector();
    public ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelector();
    public ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
    public A addToTargetLabels(int index,String item);
    public A setToTargetLabels(int index,String item);
    public A addToTargetLabels(String... items);
    public A addAllToTargetLabels(Collection<String> items);
    public A removeFromTargetLabels(String... items);
    public A removeAllFromTargetLabels(Collection<String> items);
    public List<String> getTargetLabels();
    public String getTargetLabel(int index);
    public String getFirstTargetLabel();
    public String getLastTargetLabel();
    public String getMatchingTargetLabel(Predicate<String> predicate);
    public Boolean hasMatchingTargetLabel(Predicate<String> predicate);
    public A withTargetLabels(List<String> targetLabels);
    public A withTargetLabels(String... targetLabels);
    public Boolean hasTargetLabels();
    public A addNewTargetLabel(String arg1);
    public A addNewTargetLabel(StringBuilder arg1);
    public A addNewTargetLabel(StringBuffer arg1);
    public interface EndpointsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointFluent<ServiceMonitorSpecFluent.EndpointsNested<N>> {

            public N and();
            public N endEndpoint();    }


    public interface NamespaceSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamespaceSelectorFluent<ServiceMonitorSpecFluent.NamespaceSelectorNested<N>> {

            public N and();
            public N endNamespaceSelector();    }


    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<ServiceMonitorSpecFluent.SelectorNested<N>> {

            public N and();
            public N endSelector();    }


}
