package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class RulesAlertFluentImpl<A extends RulesAlertFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RulesAlertFluent<A> {

    private String forGracePeriod;
    private String forOutageTolerance;
    private String resendDelay;

    public RulesAlertFluentImpl() {
    }

    public RulesAlertFluentImpl(RulesAlert instance) {
        this.withForGracePeriod(instance.getForGracePeriod()); 
        this.withForOutageTolerance(instance.getForOutageTolerance()); 
        this.withResendDelay(instance.getResendDelay()); 
    }

    public String getForGracePeriod() {
        return this.forGracePeriod;
    }

    public A withForGracePeriod(String forGracePeriod) {
        this.forGracePeriod=forGracePeriod; return (A) this;
    }

    public Boolean hasForGracePeriod() {
        return this.forGracePeriod != null;
    }

    public A withNewForGracePeriod(String arg1) {
        return (A)withForGracePeriod(new String(arg1));
    }

    public A withNewForGracePeriod(StringBuilder arg1) {
        return (A)withForGracePeriod(new String(arg1));
    }

    public A withNewForGracePeriod(StringBuffer arg1) {
        return (A)withForGracePeriod(new String(arg1));
    }

    public String getForOutageTolerance() {
        return this.forOutageTolerance;
    }

    public A withForOutageTolerance(String forOutageTolerance) {
        this.forOutageTolerance=forOutageTolerance; return (A) this;
    }

    public Boolean hasForOutageTolerance() {
        return this.forOutageTolerance != null;
    }

    public A withNewForOutageTolerance(String arg1) {
        return (A)withForOutageTolerance(new String(arg1));
    }

    public A withNewForOutageTolerance(StringBuilder arg1) {
        return (A)withForOutageTolerance(new String(arg1));
    }

    public A withNewForOutageTolerance(StringBuffer arg1) {
        return (A)withForOutageTolerance(new String(arg1));
    }

    public String getResendDelay() {
        return this.resendDelay;
    }

    public A withResendDelay(String resendDelay) {
        this.resendDelay=resendDelay; return (A) this;
    }

    public Boolean hasResendDelay() {
        return this.resendDelay != null;
    }

    public A withNewResendDelay(String arg1) {
        return (A)withResendDelay(new String(arg1));
    }

    public A withNewResendDelay(StringBuilder arg1) {
        return (A)withResendDelay(new String(arg1));
    }

    public A withNewResendDelay(StringBuffer arg1) {
        return (A)withResendDelay(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RulesAlertFluentImpl that = (RulesAlertFluentImpl) o;
        if (forGracePeriod != null ? !forGracePeriod.equals(that.forGracePeriod) :that.forGracePeriod != null) return false;
        if (forOutageTolerance != null ? !forOutageTolerance.equals(that.forOutageTolerance) :that.forOutageTolerance != null) return false;
        if (resendDelay != null ? !resendDelay.equals(that.resendDelay) :that.resendDelay != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(forGracePeriod,  forOutageTolerance,  resendDelay,  super.hashCode());
    }

}
