package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RuleBuilder extends RuleFluentImpl<RuleBuilder> implements VisitableBuilder<Rule,RuleBuilder> {

    RuleFluent<?> fluent;
    Boolean validationEnabled;

    public RuleBuilder() {
        this(true);
    }

    public RuleBuilder(Boolean validationEnabled) {
        this(new Rule(), validationEnabled);
    }

    public RuleBuilder(RuleFluent<?> fluent) {
        this(fluent, true);
    }

    public RuleBuilder(RuleFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Rule(), validationEnabled);
    }

    public RuleBuilder(RuleFluent<?> fluent,Rule instance) {
        this(fluent, instance, true);
    }

    public RuleBuilder(RuleFluent<?> fluent,Rule instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAlert(instance.getAlert()); 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withExpr(instance.getExpr()); 
        fluent.withFor(instance.getFor()); 
        fluent.withLabels(instance.getLabels()); 
        fluent.withRecord(instance.getRecord()); 
        this.validationEnabled = validationEnabled; 
    }

    public RuleBuilder(Rule instance) {
        this(instance,true);
    }

    public RuleBuilder(Rule instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAlert(instance.getAlert()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withExpr(instance.getExpr()); 
        this.withFor(instance.getFor()); 
        this.withLabels(instance.getLabels()); 
        this.withRecord(instance.getRecord()); 
        this.validationEnabled = validationEnabled; 
    }

    public Rule build() {
        Rule buildable = new Rule(fluent.getAlert(),fluent.getAnnotations(),fluent.getExpr(),fluent.getFor(),fluent.getLabels(),fluent.getRecord());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RuleBuilder that = (RuleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
