package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PrometheusBuilder extends PrometheusFluentImpl<PrometheusBuilder> implements VisitableBuilder<Prometheus,PrometheusBuilder> {

    PrometheusFluent<?> fluent;
    Boolean validationEnabled;

    public PrometheusBuilder() {
        this(true);
    }

    public PrometheusBuilder(Boolean validationEnabled) {
        this(new Prometheus(), validationEnabled);
    }

    public PrometheusBuilder(PrometheusFluent<?> fluent) {
        this(fluent, true);
    }

    public PrometheusBuilder(PrometheusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Prometheus(), validationEnabled);
    }

    public PrometheusBuilder(PrometheusFluent<?> fluent,Prometheus instance) {
        this(fluent, instance, true);
    }

    public PrometheusBuilder(PrometheusFluent<?> fluent,Prometheus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public PrometheusBuilder(Prometheus instance) {
        this(instance,true);
    }

    public PrometheusBuilder(Prometheus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public Prometheus build() {
        Prometheus buildable = new Prometheus(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PrometheusBuilder that = (PrometheusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
