package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodMonitorBuilder extends PodMonitorFluentImpl<PodMonitorBuilder> implements VisitableBuilder<PodMonitor,PodMonitorBuilder> {

    PodMonitorFluent<?> fluent;
    Boolean validationEnabled;

    public PodMonitorBuilder() {
        this(true);
    }

    public PodMonitorBuilder(Boolean validationEnabled) {
        this(new PodMonitor(), validationEnabled);
    }

    public PodMonitorBuilder(PodMonitorFluent<?> fluent) {
        this(fluent, true);
    }

    public PodMonitorBuilder(PodMonitorFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodMonitor(), validationEnabled);
    }

    public PodMonitorBuilder(PodMonitorFluent<?> fluent,PodMonitor instance) {
        this(fluent, instance, true);
    }

    public PodMonitorBuilder(PodMonitorFluent<?> fluent,PodMonitor instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodMonitorBuilder(PodMonitor instance) {
        this(instance,true);
    }

    public PodMonitorBuilder(PodMonitor instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodMonitor build() {
        PodMonitor buildable = new PodMonitor(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodMonitorBuilder that = (PodMonitorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
