package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BasicAuthBuilder extends BasicAuthFluentImpl<BasicAuthBuilder> implements VisitableBuilder<BasicAuth,BasicAuthBuilder> {

    BasicAuthFluent<?> fluent;
    Boolean validationEnabled;

    public BasicAuthBuilder() {
        this(true);
    }

    public BasicAuthBuilder(Boolean validationEnabled) {
        this(new BasicAuth(), validationEnabled);
    }

    public BasicAuthBuilder(BasicAuthFluent<?> fluent) {
        this(fluent, true);
    }

    public BasicAuthBuilder(BasicAuthFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new BasicAuth(), validationEnabled);
    }

    public BasicAuthBuilder(BasicAuthFluent<?> fluent,BasicAuth instance) {
        this(fluent, instance, true);
    }

    public BasicAuthBuilder(BasicAuthFluent<?> fluent,BasicAuth instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPassword(instance.getPassword()); 
        fluent.withUsername(instance.getUsername()); 
        this.validationEnabled = validationEnabled; 
    }

    public BasicAuthBuilder(BasicAuth instance) {
        this(instance,true);
    }

    public BasicAuthBuilder(BasicAuth instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withPassword(instance.getPassword()); 
        this.withUsername(instance.getUsername()); 
        this.validationEnabled = validationEnabled; 
    }

    public BasicAuth build() {
        BasicAuth buildable = new BasicAuth(fluent.getPassword(),fluent.getUsername());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BasicAuthBuilder that = (BasicAuthBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
