package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface AlertmanagerSpecFluent<A extends AlertmanagerSpecFluent<A>> extends Fluent<A> {


    public A addToAdditionalPeers(int index,String item);
    public A setToAdditionalPeers(int index,String item);
    public A addToAdditionalPeers(String... items);
    public A addAllToAdditionalPeers(Collection<String> items);
    public A removeFromAdditionalPeers(String... items);
    public A removeAllFromAdditionalPeers(Collection<String> items);
    public List<String> getAdditionalPeers();
    public String getAdditionalPeer(int index);
    public String getFirstAdditionalPeer();
    public String getLastAdditionalPeer();
    public String getMatchingAdditionalPeer(Predicate<String> predicate);
    public Boolean hasMatchingAdditionalPeer(Predicate<String> predicate);
    public A withAdditionalPeers(List<String> additionalPeers);
    public A withAdditionalPeers(String... additionalPeers);
    public Boolean hasAdditionalPeers();
    public A addNewAdditionalPeer(String arg1);
    public A addNewAdditionalPeer(StringBuilder arg1);
    public A addNewAdditionalPeer(StringBuffer arg1);
    public Affinity getAffinity();
    public A withAffinity(Affinity affinity);
    public Boolean hasAffinity();
    public String getBaseImage();
    public A withBaseImage(String baseImage);
    public Boolean hasBaseImage();
    public A withNewBaseImage(String arg1);
    public A withNewBaseImage(StringBuilder arg1);
    public A withNewBaseImage(StringBuffer arg1);
    public String getClusterAdvertiseAddress();
    public A withClusterAdvertiseAddress(String clusterAdvertiseAddress);
    public Boolean hasClusterAdvertiseAddress();
    public A withNewClusterAdvertiseAddress(String arg1);
    public A withNewClusterAdvertiseAddress(StringBuilder arg1);
    public A withNewClusterAdvertiseAddress(StringBuffer arg1);
    public A addToConfigMaps(int index,String item);
    public A setToConfigMaps(int index,String item);
    public A addToConfigMaps(String... items);
    public A addAllToConfigMaps(Collection<String> items);
    public A removeFromConfigMaps(String... items);
    public A removeAllFromConfigMaps(Collection<String> items);
    public List<String> getConfigMaps();
    public String getConfigMap(int index);
    public String getFirstConfigMap();
    public String getLastConfigMap();
    public String getMatchingConfigMap(Predicate<String> predicate);
    public Boolean hasMatchingConfigMap(Predicate<String> predicate);
    public A withConfigMaps(List<String> configMaps);
    public A withConfigMaps(String... configMaps);
    public Boolean hasConfigMaps();
    public A addNewConfigMap(String arg1);
    public A addNewConfigMap(StringBuilder arg1);
    public A addNewConfigMap(StringBuffer arg1);
    public String getConfigSecret();
    public A withConfigSecret(String configSecret);
    public Boolean hasConfigSecret();
    public A withNewConfigSecret(String arg1);
    public A withNewConfigSecret(StringBuilder arg1);
    public A withNewConfigSecret(StringBuffer arg1);
    public A addToContainers(int index,Container item);
    public A setToContainers(int index,Container item);
    public A addToContainers(Container... items);
    public A addAllToContainers(Collection<Container> items);
    public A removeFromContainers(Container... items);
    public A removeAllFromContainers(Collection<Container> items);
    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Container> getContainers();
    public List<Container> buildContainers();
    public Container buildContainer(int index);
    public Container buildFirstContainer();
    public Container buildLastContainer();
    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate);
    public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate);
    public A withContainers(List<Container> containers);
    public A withContainers(Container... containers);
    public Boolean hasContainers();
    public AlertmanagerSpecFluent.ContainersNested<A> addNewContainer();
    public AlertmanagerSpecFluent.ContainersNested<A> addNewContainerLike(Container item);
    public AlertmanagerSpecFluent.ContainersNested<A> setNewContainerLike(int index,Container item);
    public AlertmanagerSpecFluent.ContainersNested<A> editContainer(int index);
    public AlertmanagerSpecFluent.ContainersNested<A> editFirstContainer();
    public AlertmanagerSpecFluent.ContainersNested<A> editLastContainer();
    public AlertmanagerSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate);
    public String getExternalUrl();
    public A withExternalUrl(String externalUrl);
    public Boolean hasExternalUrl();
    public A withNewExternalUrl(String arg1);
    public A withNewExternalUrl(StringBuilder arg1);
    public A withNewExternalUrl(StringBuffer arg1);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public A addToImagePullSecrets(int index,LocalObjectReference item);
    public A setToImagePullSecrets(int index,LocalObjectReference item);
    public A addToImagePullSecrets(LocalObjectReference... items);
    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items);
    public A removeFromImagePullSecrets(LocalObjectReference... items);
    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items);
    public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildImagePullSecrets instead.
 * @return The buildable object.
 */
@Deprecated public List<LocalObjectReference> getImagePullSecrets();
    public List<LocalObjectReference> buildImagePullSecrets();
    public LocalObjectReference buildImagePullSecret(int index);
    public LocalObjectReference buildFirstImagePullSecret();
    public LocalObjectReference buildLastImagePullSecret();
    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
    public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets);
    public A withImagePullSecrets(LocalObjectReference... imagePullSecrets);
    public Boolean hasImagePullSecrets();
    public A addNewImagePullSecret(String name);
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item);
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item);
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index);
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret();
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret();
    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
    public A addToInitContainers(int index,Container item);
    public A setToInitContainers(int index,Container item);
    public A addToInitContainers(Container... items);
    public A addAllToInitContainers(Collection<Container> items);
    public A removeFromInitContainers(Container... items);
    public A removeAllFromInitContainers(Collection<Container> items);
    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildInitContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Container> getInitContainers();
    public List<Container> buildInitContainers();
    public Container buildInitContainer(int index);
    public Container buildFirstInitContainer();
    public Container buildLastInitContainer();
    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate);
    public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate);
    public A withInitContainers(List<Container> initContainers);
    public A withInitContainers(Container... initContainers);
    public Boolean hasInitContainers();
    public AlertmanagerSpecFluent.InitContainersNested<A> addNewInitContainer();
    public AlertmanagerSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item);
    public AlertmanagerSpecFluent.InitContainersNested<A> setNewInitContainerLike(int index,Container item);
    public AlertmanagerSpecFluent.InitContainersNested<A> editInitContainer(int index);
    public AlertmanagerSpecFluent.InitContainersNested<A> editFirstInitContainer();
    public AlertmanagerSpecFluent.InitContainersNested<A> editLastInitContainer();
    public AlertmanagerSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate);
    public Boolean isListenLocal();
    public A withListenLocal(Boolean listenLocal);
    public Boolean hasListenLocal();
    public A withNewListenLocal(String arg1);
    public A withNewListenLocal(boolean arg1);
    public String getLogFormat();
    public A withLogFormat(String logFormat);
    public Boolean hasLogFormat();
    public A withNewLogFormat(String arg1);
    public A withNewLogFormat(StringBuilder arg1);
    public A withNewLogFormat(StringBuffer arg1);
    public String getLogLevel();
    public A withLogLevel(String logLevel);
    public Boolean hasLogLevel();
    public A withNewLogLevel(String arg1);
    public A withNewLogLevel(StringBuilder arg1);
    public A withNewLogLevel(StringBuffer arg1);
    public A addToNodeSelector(String key,String value);
    public A addToNodeSelector(Map<String,String> map);
    public A removeFromNodeSelector(String key);
    public A removeFromNodeSelector(Map<String,String> map);
    public Map<String,String> getNodeSelector();
    public A withNodeSelector(Map<String,String> nodeSelector);
    public Boolean hasNodeSelector();
    public Boolean isPaused();
    public A withPaused(Boolean paused);
    public Boolean hasPaused();
    public A withNewPaused(String arg1);
    public A withNewPaused(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildPodMetadata instead.
 * @return The buildable object.
 */
@Deprecated public EmbeddedObjectMetadata getPodMetadata();
    public EmbeddedObjectMetadata buildPodMetadata();
    public A withPodMetadata(EmbeddedObjectMetadata podMetadata);
    public Boolean hasPodMetadata();
    public AlertmanagerSpecFluent.PodMetadataNested<A> withNewPodMetadata();
    public AlertmanagerSpecFluent.PodMetadataNested<A> withNewPodMetadataLike(EmbeddedObjectMetadata item);
    public AlertmanagerSpecFluent.PodMetadataNested<A> editPodMetadata();
    public AlertmanagerSpecFluent.PodMetadataNested<A> editOrNewPodMetadata();
    public AlertmanagerSpecFluent.PodMetadataNested<A> editOrNewPodMetadataLike(EmbeddedObjectMetadata item);
    public String getPortName();
    public A withPortName(String portName);
    public Boolean hasPortName();
    public A withNewPortName(String arg1);
    public A withNewPortName(StringBuilder arg1);
    public A withNewPortName(StringBuffer arg1);
    public String getPriorityClassName();
    public A withPriorityClassName(String priorityClassName);
    public Boolean hasPriorityClassName();
    public A withNewPriorityClassName(String arg1);
    public A withNewPriorityClassName(StringBuilder arg1);
    public A withNewPriorityClassName(StringBuffer arg1);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(String arg1);
    public A withNewReplicas(int arg1);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public ResourceRequirements getResources();
    public ResourceRequirements buildResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    public AlertmanagerSpecFluent.ResourcesNested<A> withNewResources();
    public AlertmanagerSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
    public AlertmanagerSpecFluent.ResourcesNested<A> editResources();
    public AlertmanagerSpecFluent.ResourcesNested<A> editOrNewResources();
    public AlertmanagerSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
    public String getRetention();
    public A withRetention(String retention);
    public Boolean hasRetention();
    public A withNewRetention(String arg1);
    public A withNewRetention(StringBuilder arg1);
    public A withNewRetention(StringBuffer arg1);
    public String getRoutePrefix();
    public A withRoutePrefix(String routePrefix);
    public Boolean hasRoutePrefix();
    public A withNewRoutePrefix(String arg1);
    public A withNewRoutePrefix(StringBuilder arg1);
    public A withNewRoutePrefix(StringBuffer arg1);
    public A addToSecrets(int index,String item);
    public A setToSecrets(int index,String item);
    public A addToSecrets(String... items);
    public A addAllToSecrets(Collection<String> items);
    public A removeFromSecrets(String... items);
    public A removeAllFromSecrets(Collection<String> items);
    public List<String> getSecrets();
    public String getSecret(int index);
    public String getFirstSecret();
    public String getLastSecret();
    public String getMatchingSecret(Predicate<String> predicate);
    public Boolean hasMatchingSecret(Predicate<String> predicate);
    public A withSecrets(List<String> secrets);
    public A withSecrets(String... secrets);
    public Boolean hasSecrets();
    public A addNewSecret(String arg1);
    public A addNewSecret(StringBuilder arg1);
    public A addNewSecret(StringBuffer arg1);
    public PodSecurityContext getSecurityContext();
    public A withSecurityContext(PodSecurityContext securityContext);
    public Boolean hasSecurityContext();
    public String getServiceAccountName();
    public A withServiceAccountName(String serviceAccountName);
    public Boolean hasServiceAccountName();
    public A withNewServiceAccountName(String arg1);
    public A withNewServiceAccountName(StringBuilder arg1);
    public A withNewServiceAccountName(StringBuffer arg1);
    public String getSha();
    public A withSha(String sha);
    public Boolean hasSha();
    public A withNewSha(String arg1);
    public A withNewSha(StringBuilder arg1);
    public A withNewSha(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildStorage instead.
 * @return The buildable object.
 */
@Deprecated public StorageSpec getStorage();
    public StorageSpec buildStorage();
    public A withStorage(StorageSpec storage);
    public Boolean hasStorage();
    public AlertmanagerSpecFluent.StorageNested<A> withNewStorage();
    public AlertmanagerSpecFluent.StorageNested<A> withNewStorageLike(StorageSpec item);
    public AlertmanagerSpecFluent.StorageNested<A> editStorage();
    public AlertmanagerSpecFluent.StorageNested<A> editOrNewStorage();
    public AlertmanagerSpecFluent.StorageNested<A> editOrNewStorageLike(StorageSpec item);
    public String getTag();
    public A withTag(String tag);
    public Boolean hasTag();
    public A withNewTag(String arg1);
    public A withNewTag(StringBuilder arg1);
    public A withNewTag(StringBuffer arg1);
    public A addToTolerations(int index,Toleration item);
    public A setToTolerations(int index,Toleration item);
    public A addToTolerations(Toleration... items);
    public A addAllToTolerations(Collection<Toleration> items);
    public A removeFromTolerations(Toleration... items);
    public A removeAllFromTolerations(Collection<Toleration> items);
    public List<Toleration> getTolerations();
    public Toleration getToleration(int index);
    public Toleration getFirstToleration();
    public Toleration getLastToleration();
    public Toleration getMatchingToleration(Predicate<Toleration> predicate);
    public Boolean hasMatchingToleration(Predicate<Toleration> predicate);
    public A withTolerations(List<Toleration> tolerations);
    public A withTolerations(Toleration... tolerations);
    public Boolean hasTolerations();
    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(String arg1);
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(StringBuffer arg1);
    public A addToVolumeMounts(int index,VolumeMount item);
    public A setToVolumeMounts(int index,VolumeMount item);
    public A addToVolumeMounts(VolumeMount... items);
    public A addAllToVolumeMounts(Collection<VolumeMount> items);
    public A removeFromVolumeMounts(VolumeMount... items);
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items);
    public List<VolumeMount> getVolumeMounts();
    public VolumeMount getVolumeMount(int index);
    public VolumeMount getFirstVolumeMount();
    public VolumeMount getLastVolumeMount();
    public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate);
    public Boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate);
    public A withVolumeMounts(List<VolumeMount> volumeMounts);
    public A withVolumeMounts(VolumeMount... volumeMounts);
    public Boolean hasVolumeMounts();
    public A addToVolumes(int index,Volume item);
    public A setToVolumes(int index,Volume item);
    public A addToVolumes(Volume... items);
    public A addAllToVolumes(Collection<Volume> items);
    public A removeFromVolumes(Volume... items);
    public A removeAllFromVolumes(Collection<Volume> items);
    public List<Volume> getVolumes();
    public Volume getVolume(int index);
    public Volume getFirstVolume();
    public Volume getLastVolume();
    public Volume getMatchingVolume(Predicate<Volume> predicate);
    public Boolean hasMatchingVolume(Predicate<Volume> predicate);
    public A withVolumes(List<Volume> volumes);
    public A withVolumes(Volume... volumes);
    public Boolean hasVolumes();
    public interface ContainersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerFluent<AlertmanagerSpecFluent.ContainersNested<N>> {

            public N and();
            public N endContainer();    }


    public interface ImagePullSecretsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<AlertmanagerSpecFluent.ImagePullSecretsNested<N>> {

            public N and();
            public N endImagePullSecret();    }


    public interface InitContainersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerFluent<AlertmanagerSpecFluent.InitContainersNested<N>> {

            public N and();
            public N endInitContainer();    }


    public interface PodMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EmbeddedObjectMetadataFluent<AlertmanagerSpecFluent.PodMetadataNested<N>> {

            public N and();
            public N endPodMetadata();    }


    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceRequirementsFluent<AlertmanagerSpecFluent.ResourcesNested<N>> {

            public N and();
            public N endResources();    }


    public interface StorageNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StorageSpecFluent<AlertmanagerSpecFluent.StorageNested<N>> {

            public N and();
            public N endStorage();    }


}
