package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;

public class SecretOrConfigMapFluentImpl<A extends SecretOrConfigMapFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SecretOrConfigMapFluent<A> {

    private ConfigMapKeySelector configMap;
    private SecretKeySelector secret;

    public SecretOrConfigMapFluentImpl() {
    }

    public SecretOrConfigMapFluentImpl(SecretOrConfigMap instance) {
        this.withConfigMap(instance.getConfigMap()); 
        this.withSecret(instance.getSecret()); 
    }

    public ConfigMapKeySelector getConfigMap() {
        return this.configMap;
    }

    public A withConfigMap(ConfigMapKeySelector configMap) {
        this.configMap=configMap; return (A) this;
    }

    public Boolean hasConfigMap() {
        return this.configMap != null;
    }

    public A withNewConfigMap(String key,String name,Boolean optional) {
        return (A)withConfigMap(new ConfigMapKeySelector(key, name, optional));
    }

    public SecretKeySelector getSecret() {
        return this.secret;
    }

    public A withSecret(SecretKeySelector secret) {
        this.secret=secret; return (A) this;
    }

    public Boolean hasSecret() {
        return this.secret != null;
    }

    public A withNewSecret(String key,String name,Boolean optional) {
        return (A)withSecret(new SecretKeySelector(key, name, optional));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SecretOrConfigMapFluentImpl that = (SecretOrConfigMapFluentImpl) o;
        if (configMap != null ? !configMap.equals(that.configMap) :that.configMap != null) return false;
        if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(configMap,  secret,  super.hashCode());
    }

}
