package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class RuleGroupFluentImpl<A extends RuleGroupFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RuleGroupFluent<A> {

    private String interval;
    private String name;
    private String partialResponseStrategy;
    private List<RuleBuilder> rules =  new ArrayList<RuleBuilder>();

    public RuleGroupFluentImpl() {
    }

    public RuleGroupFluentImpl(RuleGroup instance) {
        this.withInterval(instance.getInterval()); 
        this.withName(instance.getName()); 
        this.withPartialResponseStrategy(instance.getPartialResponseStrategy()); 
        this.withRules(instance.getRules()); 
    }

    public String getInterval() {
        return this.interval;
    }

    public A withInterval(String interval) {
        this.interval=interval; return (A) this;
    }

    public Boolean hasInterval() {
        return this.interval != null;
    }

    public A withNewInterval(String arg1) {
        return (A)withInterval(new String(arg1));
    }

    public A withNewInterval(StringBuilder arg1) {
        return (A)withInterval(new String(arg1));
    }

    public A withNewInterval(StringBuffer arg1) {
        return (A)withInterval(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getPartialResponseStrategy() {
        return this.partialResponseStrategy;
    }

    public A withPartialResponseStrategy(String partialResponseStrategy) {
        this.partialResponseStrategy=partialResponseStrategy; return (A) this;
    }

    public Boolean hasPartialResponseStrategy() {
        return this.partialResponseStrategy != null;
    }

    public A withNewPartialResponseStrategy(String arg1) {
        return (A)withPartialResponseStrategy(new String(arg1));
    }

    public A withNewPartialResponseStrategy(StringBuilder arg1) {
        return (A)withPartialResponseStrategy(new String(arg1));
    }

    public A withNewPartialResponseStrategy(StringBuffer arg1) {
        return (A)withPartialResponseStrategy(new String(arg1));
    }

    public A addToRules(int index,Rule item) {
        if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
        RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,Rule item) {
        if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
        RuleBuilder builder = new RuleBuilder(item);
        if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
        if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
         return (A)this;
    }

    public A addToRules(Rule... items) {
        if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
        for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(Collection<Rule> items) {
        if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
        for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(Rule... items) {
        for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(Collection<Rule> items) {
        for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRules(Predicate<RuleBuilder> predicate) {
        if (rules == null) return (A) this;
        final Iterator<RuleBuilder> each = rules.iterator();
        final List visitables = _visitables.get("rules");
        while (each.hasNext()) {
          RuleBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<Rule> getRules() {
        return build(rules);
    }

    public List<Rule> buildRules() {
        return build(rules);
    }

    public Rule buildRule(int index) {
        return this.rules.get(index).build();
    }

    public Rule buildFirstRule() {
        return this.rules.get(0).build();
    }

    public Rule buildLastRule() {
        return this.rules.get(rules.size() - 1).build();
    }

    public Rule buildMatchingRule(Predicate<RuleBuilder> predicate) {
        for (RuleBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRule(Predicate<RuleBuilder> predicate) {
        for (RuleBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRules(List<Rule> rules) {
        if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
        if (rules != null) {this.rules = new ArrayList<RuleBuilder>(); for (Rule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(Rule... rules) {
        if (this.rules != null) {this.rules.clear();}
        if (rules != null) {for (Rule item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules() {
        return rules != null && !rules.isEmpty();
    }

    public RuleGroupFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    public RuleGroupFluent.RulesNested<A> addNewRuleLike(Rule item) {
        return new RulesNestedImpl(-1, item);
    }

    public RuleGroupFluent.RulesNested<A> setNewRuleLike(int index,Rule item) {
        return new RulesNestedImpl(index, item);
    }

    public RuleGroupFluent.RulesNested<A> editRule(int index) {
        if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
        return setNewRuleLike(index, buildRule(index));
    }

    public RuleGroupFluent.RulesNested<A> editFirstRule() {
        if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
        return setNewRuleLike(0, buildRule(0));
    }

    public RuleGroupFluent.RulesNested<A> editLastRule() {
        int index = rules.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
        return setNewRuleLike(index, buildRule(index));
    }

    public RuleGroupFluent.RulesNested<A> editMatchingRule(Predicate<RuleBuilder> predicate) {
        int index = -1;
        for (int i=0;i<rules.size();i++) { 
        if (predicate.test(rules.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
        return setNewRuleLike(index, buildRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RuleGroupFluentImpl that = (RuleGroupFluentImpl) o;
        if (interval != null ? !interval.equals(that.interval) :that.interval != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (partialResponseStrategy != null ? !partialResponseStrategy.equals(that.partialResponseStrategy) :that.partialResponseStrategy != null) return false;
        if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(interval,  name,  partialResponseStrategy,  rules,  super.hashCode());
    }

    public class RulesNestedImpl<N> extends RuleFluentImpl<RuleGroupFluent.RulesNested<N>> implements RuleGroupFluent.RulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RuleBuilder builder;
        private final int index;

            RulesNestedImpl(int index,Rule item) {
                this.index = index;
                this.builder = new RuleBuilder(this, item);
                        
            }

            RulesNestedImpl() {
                this.index = -1;
                this.builder = new RuleBuilder(this);
                        
            }

            public N and() {
                return (N) RuleGroupFluentImpl.this.setToRules(index,builder.build());
            }

            public N endRule() {
                return and();
            }
    }


}
