package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PrometheusRuleSpecBuilder extends PrometheusRuleSpecFluentImpl<PrometheusRuleSpecBuilder> implements VisitableBuilder<PrometheusRuleSpec,PrometheusRuleSpecBuilder> {

    PrometheusRuleSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PrometheusRuleSpecBuilder() {
        this(true);
    }

    public PrometheusRuleSpecBuilder(Boolean validationEnabled) {
        this(new PrometheusRuleSpec(), validationEnabled);
    }

    public PrometheusRuleSpecBuilder(PrometheusRuleSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public PrometheusRuleSpecBuilder(PrometheusRuleSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PrometheusRuleSpec(), validationEnabled);
    }

    public PrometheusRuleSpecBuilder(PrometheusRuleSpecFluent<?> fluent,PrometheusRuleSpec instance) {
        this(fluent, instance, true);
    }

    public PrometheusRuleSpecBuilder(PrometheusRuleSpecFluent<?> fluent,PrometheusRuleSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withGroups(instance.getGroups()); 
        this.validationEnabled = validationEnabled; 
    }

    public PrometheusRuleSpecBuilder(PrometheusRuleSpec instance) {
        this(instance,true);
    }

    public PrometheusRuleSpecBuilder(PrometheusRuleSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withGroups(instance.getGroups()); 
        this.validationEnabled = validationEnabled; 
    }

    public PrometheusRuleSpec build() {
        PrometheusRuleSpec buildable = new PrometheusRuleSpec(fluent.getGroups());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PrometheusRuleSpecBuilder that = (PrometheusRuleSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
