package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import com.fasterxml.jackson.core.JsonParser;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface AlertmanagerEndpointsFluent<A extends AlertmanagerEndpointsFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getBearerTokenFile();
    public A withBearerTokenFile(String bearerTokenFile);
    public Boolean hasBearerTokenFile();
    public A withNewBearerTokenFile(String arg1);
    public A withNewBearerTokenFile(StringBuilder arg1);
    public A withNewBearerTokenFile(StringBuffer arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public String getNamespace();
    public A withNamespace(String namespace);
    public Boolean hasNamespace();
    public A withNewNamespace(String arg1);
    public A withNewNamespace(StringBuilder arg1);
    public A withNewNamespace(StringBuffer arg1);
    public String getPathPrefix();
    public A withPathPrefix(String pathPrefix);
    public Boolean hasPathPrefix();
    public A withNewPathPrefix(String arg1);
    public A withNewPathPrefix(StringBuilder arg1);
    public A withNewPathPrefix(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildPort instead.
 * @return The buildable object.
 */
@Deprecated public IntOrString getPort();
    public IntOrString buildPort();
    public A withPort(IntOrString port);
    public Boolean hasPort();
    public A withNewPort(String strVal);
    public A withNewPort(Integer intVal);
    public AlertmanagerEndpointsFluent.PortNested<A> withNewPort();
    public AlertmanagerEndpointsFluent.PortNested<A> withNewPortLike(IntOrString item);
    public AlertmanagerEndpointsFluent.PortNested<A> editPort();
    public AlertmanagerEndpointsFluent.PortNested<A> editOrNewPort();
    public AlertmanagerEndpointsFluent.PortNested<A> editOrNewPortLike(IntOrString item);
    public String getScheme();
    public A withScheme(String scheme);
    public Boolean hasScheme();
    public A withNewScheme(String arg1);
    public A withNewScheme(StringBuilder arg1);
    public A withNewScheme(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTlsConfig instead.
 * @return The buildable object.
 */
@Deprecated public TLSConfig getTlsConfig();
    public TLSConfig buildTlsConfig();
    public A withTlsConfig(TLSConfig tlsConfig);
    public Boolean hasTlsConfig();
    public AlertmanagerEndpointsFluent.TlsConfigNested<A> withNewTlsConfig();
    public AlertmanagerEndpointsFluent.TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item);
    public AlertmanagerEndpointsFluent.TlsConfigNested<A> editTlsConfig();
    public AlertmanagerEndpointsFluent.TlsConfigNested<A> editOrNewTlsConfig();
    public AlertmanagerEndpointsFluent.TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item);
    public interface PortNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IntOrStringFluent<AlertmanagerEndpointsFluent.PortNested<N>> {

            public N and();
            public N endPort();    }


    public interface TlsConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TLSConfigFluent<AlertmanagerEndpointsFluent.TlsConfigNested<N>> {

            public N and();
            public N endTlsConfig();    }


}
