package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PrometheusRuleExcludeConfigBuilder extends PrometheusRuleExcludeConfigFluentImpl<PrometheusRuleExcludeConfigBuilder> implements VisitableBuilder<PrometheusRuleExcludeConfig,PrometheusRuleExcludeConfigBuilder> {

    PrometheusRuleExcludeConfigFluent<?> fluent;
    Boolean validationEnabled;

    public PrometheusRuleExcludeConfigBuilder() {
        this(true);
    }

    public PrometheusRuleExcludeConfigBuilder(Boolean validationEnabled) {
        this(new PrometheusRuleExcludeConfig(), validationEnabled);
    }

    public PrometheusRuleExcludeConfigBuilder(PrometheusRuleExcludeConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public PrometheusRuleExcludeConfigBuilder(PrometheusRuleExcludeConfigFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PrometheusRuleExcludeConfig(), validationEnabled);
    }

    public PrometheusRuleExcludeConfigBuilder(PrometheusRuleExcludeConfigFluent<?> fluent,PrometheusRuleExcludeConfig instance) {
        this(fluent, instance, true);
    }

    public PrometheusRuleExcludeConfigBuilder(PrometheusRuleExcludeConfigFluent<?> fluent,PrometheusRuleExcludeConfig instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withRuleName(instance.getRuleName()); 
        fluent.withRuleNamespace(instance.getRuleNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public PrometheusRuleExcludeConfigBuilder(PrometheusRuleExcludeConfig instance) {
        this(instance,true);
    }

    public PrometheusRuleExcludeConfigBuilder(PrometheusRuleExcludeConfig instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withRuleName(instance.getRuleName()); 
        this.withRuleNamespace(instance.getRuleNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public PrometheusRuleExcludeConfig build() {
        PrometheusRuleExcludeConfig buildable = new PrometheusRuleExcludeConfig(fluent.getRuleName(),fluent.getRuleNamespace());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PrometheusRuleExcludeConfigBuilder that = (PrometheusRuleExcludeConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
