package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import java.lang.Integer;
import java.lang.StringBuffer;

public interface PrometheusSpecFluent<A extends PrometheusSpecFluent<A>> extends Fluent<A> {


    public SecretKeySelector getAdditionalAlertManagerConfigs();
    public A withAdditionalAlertManagerConfigs(SecretKeySelector additionalAlertManagerConfigs);
    public Boolean hasAdditionalAlertManagerConfigs();
    public A withNewAdditionalAlertManagerConfigs(String key,String name,Boolean optional);
    public SecretKeySelector getAdditionalAlertRelabelConfigs();
    public A withAdditionalAlertRelabelConfigs(SecretKeySelector additionalAlertRelabelConfigs);
    public Boolean hasAdditionalAlertRelabelConfigs();
    public A withNewAdditionalAlertRelabelConfigs(String key,String name,Boolean optional);
    public SecretKeySelector getAdditionalScrapeConfigs();
    public A withAdditionalScrapeConfigs(SecretKeySelector additionalScrapeConfigs);
    public Boolean hasAdditionalScrapeConfigs();
    public A withNewAdditionalScrapeConfigs(String key,String name,Boolean optional);
    public Affinity getAffinity();
    public A withAffinity(Affinity affinity);
    public Boolean hasAffinity();
    
/**
 * This method has been deprecated, please use method buildAlerting instead.
 * @return The buildable object.
 */
@Deprecated public AlertingSpec getAlerting();
    public AlertingSpec buildAlerting();
    public A withAlerting(AlertingSpec alerting);
    public Boolean hasAlerting();
    public PrometheusSpecFluent.AlertingNested<A> withNewAlerting();
    public PrometheusSpecFluent.AlertingNested<A> withNewAlertingLike(AlertingSpec item);
    public PrometheusSpecFluent.AlertingNested<A> editAlerting();
    public PrometheusSpecFluent.AlertingNested<A> editOrNewAlerting();
    public PrometheusSpecFluent.AlertingNested<A> editOrNewAlertingLike(AlertingSpec item);
    public Boolean isAllowOverlappingBlocks();
    public A withAllowOverlappingBlocks(Boolean allowOverlappingBlocks);
    public Boolean hasAllowOverlappingBlocks();
    public A withNewAllowOverlappingBlocks(String arg1);
    public A withNewAllowOverlappingBlocks(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildApiserverConfig instead.
 * @return The buildable object.
 */
@Deprecated public APIServerConfig getApiserverConfig();
    public APIServerConfig buildApiserverConfig();
    public A withApiserverConfig(APIServerConfig apiserverConfig);
    public Boolean hasApiserverConfig();
    public PrometheusSpecFluent.ApiserverConfigNested<A> withNewApiserverConfig();
    public PrometheusSpecFluent.ApiserverConfigNested<A> withNewApiserverConfigLike(APIServerConfig item);
    public PrometheusSpecFluent.ApiserverConfigNested<A> editApiserverConfig();
    public PrometheusSpecFluent.ApiserverConfigNested<A> editOrNewApiserverConfig();
    public PrometheusSpecFluent.ApiserverConfigNested<A> editOrNewApiserverConfigLike(APIServerConfig item);
    
/**
 * This method has been deprecated, please use method buildArbitraryFSAccessThroughSMs instead.
 * @return The buildable object.
 */
@Deprecated public ArbitraryFSAccessThroughSMsConfig getArbitraryFSAccessThroughSMs();
    public ArbitraryFSAccessThroughSMsConfig buildArbitraryFSAccessThroughSMs();
    public A withArbitraryFSAccessThroughSMs(ArbitraryFSAccessThroughSMsConfig arbitraryFSAccessThroughSMs);
    public Boolean hasArbitraryFSAccessThroughSMs();
    public A withNewArbitraryFSAccessThroughSMs(Boolean deny);
    public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> withNewArbitraryFSAccessThroughSMs();
    public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> withNewArbitraryFSAccessThroughSMsLike(ArbitraryFSAccessThroughSMsConfig item);
    public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> editArbitraryFSAccessThroughSMs();
    public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> editOrNewArbitraryFSAccessThroughSMs();
    public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> editOrNewArbitraryFSAccessThroughSMsLike(ArbitraryFSAccessThroughSMsConfig item);
    public String getBaseImage();
    public A withBaseImage(String baseImage);
    public Boolean hasBaseImage();
    public A withNewBaseImage(String arg1);
    public A withNewBaseImage(StringBuilder arg1);
    public A withNewBaseImage(StringBuffer arg1);
    public A addToConfigMaps(int index,String item);
    public A setToConfigMaps(int index,String item);
    public A addToConfigMaps(String... items);
    public A addAllToConfigMaps(Collection<String> items);
    public A removeFromConfigMaps(String... items);
    public A removeAllFromConfigMaps(Collection<String> items);
    public List<String> getConfigMaps();
    public String getConfigMap(int index);
    public String getFirstConfigMap();
    public String getLastConfigMap();
    public String getMatchingConfigMap(Predicate<String> predicate);
    public Boolean hasMatchingConfigMap(Predicate<String> predicate);
    public A withConfigMaps(List<String> configMaps);
    public A withConfigMaps(String... configMaps);
    public Boolean hasConfigMaps();
    public A addNewConfigMap(String arg1);
    public A addNewConfigMap(StringBuilder arg1);
    public A addNewConfigMap(StringBuffer arg1);
    public A addToContainers(int index,Container item);
    public A setToContainers(int index,Container item);
    public A addToContainers(Container... items);
    public A addAllToContainers(Collection<Container> items);
    public A removeFromContainers(Container... items);
    public A removeAllFromContainers(Collection<Container> items);
    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Container> getContainers();
    public List<Container> buildContainers();
    public Container buildContainer(int index);
    public Container buildFirstContainer();
    public Container buildLastContainer();
    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate);
    public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate);
    public A withContainers(List<Container> containers);
    public A withContainers(Container... containers);
    public Boolean hasContainers();
    public PrometheusSpecFluent.ContainersNested<A> addNewContainer();
    public PrometheusSpecFluent.ContainersNested<A> addNewContainerLike(Container item);
    public PrometheusSpecFluent.ContainersNested<A> setNewContainerLike(int index,Container item);
    public PrometheusSpecFluent.ContainersNested<A> editContainer(int index);
    public PrometheusSpecFluent.ContainersNested<A> editFirstContainer();
    public PrometheusSpecFluent.ContainersNested<A> editLastContainer();
    public PrometheusSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate);
    public Boolean isDisableCompaction();
    public A withDisableCompaction(Boolean disableCompaction);
    public Boolean hasDisableCompaction();
    public A withNewDisableCompaction(String arg1);
    public A withNewDisableCompaction(boolean arg1);
    public Boolean isEnableAdminAPI();
    public A withEnableAdminAPI(Boolean enableAdminAPI);
    public Boolean hasEnableAdminAPI();
    public A withNewEnableAdminAPI(String arg1);
    public A withNewEnableAdminAPI(boolean arg1);
    public String getEnforcedNamespaceLabel();
    public A withEnforcedNamespaceLabel(String enforcedNamespaceLabel);
    public Boolean hasEnforcedNamespaceLabel();
    public A withNewEnforcedNamespaceLabel(String arg1);
    public A withNewEnforcedNamespaceLabel(StringBuilder arg1);
    public A withNewEnforcedNamespaceLabel(StringBuffer arg1);
    public Long getEnforcedSampleLimit();
    public A withEnforcedSampleLimit(Long enforcedSampleLimit);
    public Boolean hasEnforcedSampleLimit();
    public String getEvaluationInterval();
    public A withEvaluationInterval(String evaluationInterval);
    public Boolean hasEvaluationInterval();
    public A withNewEvaluationInterval(String arg1);
    public A withNewEvaluationInterval(StringBuilder arg1);
    public A withNewEvaluationInterval(StringBuffer arg1);
    public A addToExternalLabels(String key,String value);
    public A addToExternalLabels(Map<String,String> map);
    public A removeFromExternalLabels(String key);
    public A removeFromExternalLabels(Map<String,String> map);
    public Map<String,String> getExternalLabels();
    public A withExternalLabels(Map<String,String> externalLabels);
    public Boolean hasExternalLabels();
    public String getExternalUrl();
    public A withExternalUrl(String externalUrl);
    public Boolean hasExternalUrl();
    public A withNewExternalUrl(String arg1);
    public A withNewExternalUrl(StringBuilder arg1);
    public A withNewExternalUrl(StringBuffer arg1);
    public Boolean isIgnoreNamespaceSelectors();
    public A withIgnoreNamespaceSelectors(Boolean ignoreNamespaceSelectors);
    public Boolean hasIgnoreNamespaceSelectors();
    public A withNewIgnoreNamespaceSelectors(String arg1);
    public A withNewIgnoreNamespaceSelectors(boolean arg1);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public A addToImagePullSecrets(int index,LocalObjectReference item);
    public A setToImagePullSecrets(int index,LocalObjectReference item);
    public A addToImagePullSecrets(LocalObjectReference... items);
    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items);
    public A removeFromImagePullSecrets(LocalObjectReference... items);
    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items);
    public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildImagePullSecrets instead.
 * @return The buildable object.
 */
@Deprecated public List<LocalObjectReference> getImagePullSecrets();
    public List<LocalObjectReference> buildImagePullSecrets();
    public LocalObjectReference buildImagePullSecret(int index);
    public LocalObjectReference buildFirstImagePullSecret();
    public LocalObjectReference buildLastImagePullSecret();
    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
    public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets);
    public A withImagePullSecrets(LocalObjectReference... imagePullSecrets);
    public Boolean hasImagePullSecrets();
    public A addNewImagePullSecret(String name);
    public PrometheusSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
    public PrometheusSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item);
    public PrometheusSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item);
    public PrometheusSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index);
    public PrometheusSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret();
    public PrometheusSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret();
    public PrometheusSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
    public A addToInitContainers(int index,Container item);
    public A setToInitContainers(int index,Container item);
    public A addToInitContainers(Container... items);
    public A addAllToInitContainers(Collection<Container> items);
    public A removeFromInitContainers(Container... items);
    public A removeAllFromInitContainers(Collection<Container> items);
    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildInitContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Container> getInitContainers();
    public List<Container> buildInitContainers();
    public Container buildInitContainer(int index);
    public Container buildFirstInitContainer();
    public Container buildLastInitContainer();
    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate);
    public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate);
    public A withInitContainers(List<Container> initContainers);
    public A withInitContainers(Container... initContainers);
    public Boolean hasInitContainers();
    public PrometheusSpecFluent.InitContainersNested<A> addNewInitContainer();
    public PrometheusSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item);
    public PrometheusSpecFluent.InitContainersNested<A> setNewInitContainerLike(int index,Container item);
    public PrometheusSpecFluent.InitContainersNested<A> editInitContainer(int index);
    public PrometheusSpecFluent.InitContainersNested<A> editFirstInitContainer();
    public PrometheusSpecFluent.InitContainersNested<A> editLastInitContainer();
    public PrometheusSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate);
    public Boolean isListenLocal();
    public A withListenLocal(Boolean listenLocal);
    public Boolean hasListenLocal();
    public A withNewListenLocal(String arg1);
    public A withNewListenLocal(boolean arg1);
    public String getLogFormat();
    public A withLogFormat(String logFormat);
    public Boolean hasLogFormat();
    public A withNewLogFormat(String arg1);
    public A withNewLogFormat(StringBuilder arg1);
    public A withNewLogFormat(StringBuffer arg1);
    public String getLogLevel();
    public A withLogLevel(String logLevel);
    public Boolean hasLogLevel();
    public A withNewLogLevel(String arg1);
    public A withNewLogLevel(StringBuilder arg1);
    public A withNewLogLevel(StringBuffer arg1);
    public A addToNodeSelector(String key,String value);
    public A addToNodeSelector(Map<String,String> map);
    public A removeFromNodeSelector(String key);
    public A removeFromNodeSelector(Map<String,String> map);
    public Map<String,String> getNodeSelector();
    public A withNodeSelector(Map<String,String> nodeSelector);
    public Boolean hasNodeSelector();
    public Boolean isOverrideHonorLabels();
    public A withOverrideHonorLabels(Boolean overrideHonorLabels);
    public Boolean hasOverrideHonorLabels();
    public A withNewOverrideHonorLabels(String arg1);
    public A withNewOverrideHonorLabels(boolean arg1);
    public Boolean isOverrideHonorTimestamps();
    public A withOverrideHonorTimestamps(Boolean overrideHonorTimestamps);
    public Boolean hasOverrideHonorTimestamps();
    public A withNewOverrideHonorTimestamps(String arg1);
    public A withNewOverrideHonorTimestamps(boolean arg1);
    public Boolean isPaused();
    public A withPaused(Boolean paused);
    public Boolean hasPaused();
    public A withNewPaused(String arg1);
    public A withNewPaused(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildPodMetadata instead.
 * @return The buildable object.
 */
@Deprecated public EmbeddedObjectMetadata getPodMetadata();
    public EmbeddedObjectMetadata buildPodMetadata();
    public A withPodMetadata(EmbeddedObjectMetadata podMetadata);
    public Boolean hasPodMetadata();
    public PrometheusSpecFluent.PodMetadataNested<A> withNewPodMetadata();
    public PrometheusSpecFluent.PodMetadataNested<A> withNewPodMetadataLike(EmbeddedObjectMetadata item);
    public PrometheusSpecFluent.PodMetadataNested<A> editPodMetadata();
    public PrometheusSpecFluent.PodMetadataNested<A> editOrNewPodMetadata();
    public PrometheusSpecFluent.PodMetadataNested<A> editOrNewPodMetadataLike(EmbeddedObjectMetadata item);
    
/**
 * This method has been deprecated, please use method buildPodMonitorNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getPodMonitorNamespaceSelector();
    public LabelSelector buildPodMonitorNamespaceSelector();
    public A withPodMonitorNamespaceSelector(LabelSelector podMonitorNamespaceSelector);
    public Boolean hasPodMonitorNamespaceSelector();
    public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> withNewPodMonitorNamespaceSelector();
    public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> withNewPodMonitorNamespaceSelectorLike(LabelSelector item);
    public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> editPodMonitorNamespaceSelector();
    public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> editOrNewPodMonitorNamespaceSelector();
    public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> editOrNewPodMonitorNamespaceSelectorLike(LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildPodMonitorSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getPodMonitorSelector();
    public LabelSelector buildPodMonitorSelector();
    public A withPodMonitorSelector(LabelSelector podMonitorSelector);
    public Boolean hasPodMonitorSelector();
    public PrometheusSpecFluent.PodMonitorSelectorNested<A> withNewPodMonitorSelector();
    public PrometheusSpecFluent.PodMonitorSelectorNested<A> withNewPodMonitorSelectorLike(LabelSelector item);
    public PrometheusSpecFluent.PodMonitorSelectorNested<A> editPodMonitorSelector();
    public PrometheusSpecFluent.PodMonitorSelectorNested<A> editOrNewPodMonitorSelector();
    public PrometheusSpecFluent.PodMonitorSelectorNested<A> editOrNewPodMonitorSelectorLike(LabelSelector item);
    public String getPortName();
    public A withPortName(String portName);
    public Boolean hasPortName();
    public A withNewPortName(String arg1);
    public A withNewPortName(StringBuilder arg1);
    public A withNewPortName(StringBuffer arg1);
    public String getPriorityClassName();
    public A withPriorityClassName(String priorityClassName);
    public Boolean hasPriorityClassName();
    public A withNewPriorityClassName(String arg1);
    public A withNewPriorityClassName(StringBuilder arg1);
    public A withNewPriorityClassName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildProbeNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getProbeNamespaceSelector();
    public LabelSelector buildProbeNamespaceSelector();
    public A withProbeNamespaceSelector(LabelSelector probeNamespaceSelector);
    public Boolean hasProbeNamespaceSelector();
    public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> withNewProbeNamespaceSelector();
    public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> withNewProbeNamespaceSelectorLike(LabelSelector item);
    public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> editProbeNamespaceSelector();
    public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> editOrNewProbeNamespaceSelector();
    public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> editOrNewProbeNamespaceSelectorLike(LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildProbeSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getProbeSelector();
    public LabelSelector buildProbeSelector();
    public A withProbeSelector(LabelSelector probeSelector);
    public Boolean hasProbeSelector();
    public PrometheusSpecFluent.ProbeSelectorNested<A> withNewProbeSelector();
    public PrometheusSpecFluent.ProbeSelectorNested<A> withNewProbeSelectorLike(LabelSelector item);
    public PrometheusSpecFluent.ProbeSelectorNested<A> editProbeSelector();
    public PrometheusSpecFluent.ProbeSelectorNested<A> editOrNewProbeSelector();
    public PrometheusSpecFluent.ProbeSelectorNested<A> editOrNewProbeSelectorLike(LabelSelector item);
    public String getPrometheusExternalLabelName();
    public A withPrometheusExternalLabelName(String prometheusExternalLabelName);
    public Boolean hasPrometheusExternalLabelName();
    public A withNewPrometheusExternalLabelName(String arg1);
    public A withNewPrometheusExternalLabelName(StringBuilder arg1);
    public A withNewPrometheusExternalLabelName(StringBuffer arg1);
    public A addToPrometheusRulesExcludedFromEnforce(int index,PrometheusRuleExcludeConfig item);
    public A setToPrometheusRulesExcludedFromEnforce(int index,PrometheusRuleExcludeConfig item);
    public A addToPrometheusRulesExcludedFromEnforce(PrometheusRuleExcludeConfig... items);
    public A addAllToPrometheusRulesExcludedFromEnforce(Collection<PrometheusRuleExcludeConfig> items);
    public A removeFromPrometheusRulesExcludedFromEnforce(PrometheusRuleExcludeConfig... items);
    public A removeAllFromPrometheusRulesExcludedFromEnforce(Collection<PrometheusRuleExcludeConfig> items);
    public A removeMatchingFromPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPrometheusRulesExcludedFromEnforce instead.
 * @return The buildable object.
 */
@Deprecated public List<PrometheusRuleExcludeConfig> getPrometheusRulesExcludedFromEnforce();
    public List<PrometheusRuleExcludeConfig> buildPrometheusRulesExcludedFromEnforce();
    public PrometheusRuleExcludeConfig buildPrometheusRulesExcludedFromEnforce(int index);
    public PrometheusRuleExcludeConfig buildFirstPrometheusRulesExcludedFromEnforce();
    public PrometheusRuleExcludeConfig buildLastPrometheusRulesExcludedFromEnforce();
    public PrometheusRuleExcludeConfig buildMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate);
    public Boolean hasMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate);
    public A withPrometheusRulesExcludedFromEnforce(List<PrometheusRuleExcludeConfig> prometheusRulesExcludedFromEnforce);
    public A withPrometheusRulesExcludedFromEnforce(PrometheusRuleExcludeConfig... prometheusRulesExcludedFromEnforce);
    public Boolean hasPrometheusRulesExcludedFromEnforce();
    public A addNewPrometheusRulesExcludedFromEnforce(String ruleName,String ruleNamespace);
    public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> addNewPrometheusRulesExcludedFromEnforce();
    public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> addNewPrometheusRulesExcludedFromEnforceLike(PrometheusRuleExcludeConfig item);
    public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> setNewPrometheusRulesExcludedFromEnforceLike(int index,PrometheusRuleExcludeConfig item);
    public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editPrometheusRulesExcludedFromEnforce(int index);
    public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editFirstPrometheusRulesExcludedFromEnforce();
    public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editLastPrometheusRulesExcludedFromEnforce();
    public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildQuery instead.
 * @return The buildable object.
 */
@Deprecated public QuerySpec getQuery();
    public QuerySpec buildQuery();
    public A withQuery(QuerySpec query);
    public Boolean hasQuery();
    public A withNewQuery(String lookbackDelta,Integer maxConcurrency,Integer maxSamples,String timeout);
    public PrometheusSpecFluent.QueryNested<A> withNewQuery();
    public PrometheusSpecFluent.QueryNested<A> withNewQueryLike(QuerySpec item);
    public PrometheusSpecFluent.QueryNested<A> editQuery();
    public PrometheusSpecFluent.QueryNested<A> editOrNewQuery();
    public PrometheusSpecFluent.QueryNested<A> editOrNewQueryLike(QuerySpec item);
    public String getQueryLogFile();
    public A withQueryLogFile(String queryLogFile);
    public Boolean hasQueryLogFile();
    public A withNewQueryLogFile(String arg1);
    public A withNewQueryLogFile(StringBuilder arg1);
    public A withNewQueryLogFile(StringBuffer arg1);
    public A addToRemoteRead(int index,RemoteReadSpec item);
    public A setToRemoteRead(int index,RemoteReadSpec item);
    public A addToRemoteRead(RemoteReadSpec... items);
    public A addAllToRemoteRead(Collection<RemoteReadSpec> items);
    public A removeFromRemoteRead(RemoteReadSpec... items);
    public A removeAllFromRemoteRead(Collection<RemoteReadSpec> items);
    public A removeMatchingFromRemoteRead(Predicate<RemoteReadSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildRemoteRead instead.
 * @return The buildable object.
 */
@Deprecated public List<RemoteReadSpec> getRemoteRead();
    public List<RemoteReadSpec> buildRemoteRead();
    public RemoteReadSpec buildRemoteRead(int index);
    public RemoteReadSpec buildFirstRemoteRead();
    public RemoteReadSpec buildLastRemoteRead();
    public RemoteReadSpec buildMatchingRemoteRead(Predicate<RemoteReadSpecBuilder> predicate);
    public Boolean hasMatchingRemoteRead(Predicate<RemoteReadSpecBuilder> predicate);
    public A withRemoteRead(List<RemoteReadSpec> remoteRead);
    public A withRemoteRead(RemoteReadSpec... remoteRead);
    public Boolean hasRemoteRead();
    public PrometheusSpecFluent.RemoteReadNested<A> addNewRemoteRead();
    public PrometheusSpecFluent.RemoteReadNested<A> addNewRemoteReadLike(RemoteReadSpec item);
    public PrometheusSpecFluent.RemoteReadNested<A> setNewRemoteReadLike(int index,RemoteReadSpec item);
    public PrometheusSpecFluent.RemoteReadNested<A> editRemoteRead(int index);
    public PrometheusSpecFluent.RemoteReadNested<A> editFirstRemoteRead();
    public PrometheusSpecFluent.RemoteReadNested<A> editLastRemoteRead();
    public PrometheusSpecFluent.RemoteReadNested<A> editMatchingRemoteRead(Predicate<RemoteReadSpecBuilder> predicate);
    public A addToRemoteWrite(int index,RemoteWriteSpec item);
    public A setToRemoteWrite(int index,RemoteWriteSpec item);
    public A addToRemoteWrite(RemoteWriteSpec... items);
    public A addAllToRemoteWrite(Collection<RemoteWriteSpec> items);
    public A removeFromRemoteWrite(RemoteWriteSpec... items);
    public A removeAllFromRemoteWrite(Collection<RemoteWriteSpec> items);
    public A removeMatchingFromRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildRemoteWrite instead.
 * @return The buildable object.
 */
@Deprecated public List<RemoteWriteSpec> getRemoteWrite();
    public List<RemoteWriteSpec> buildRemoteWrite();
    public RemoteWriteSpec buildRemoteWrite(int index);
    public RemoteWriteSpec buildFirstRemoteWrite();
    public RemoteWriteSpec buildLastRemoteWrite();
    public RemoteWriteSpec buildMatchingRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate);
    public Boolean hasMatchingRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate);
    public A withRemoteWrite(List<RemoteWriteSpec> remoteWrite);
    public A withRemoteWrite(RemoteWriteSpec... remoteWrite);
    public Boolean hasRemoteWrite();
    public PrometheusSpecFluent.RemoteWriteNested<A> addNewRemoteWrite();
    public PrometheusSpecFluent.RemoteWriteNested<A> addNewRemoteWriteLike(RemoteWriteSpec item);
    public PrometheusSpecFluent.RemoteWriteNested<A> setNewRemoteWriteLike(int index,RemoteWriteSpec item);
    public PrometheusSpecFluent.RemoteWriteNested<A> editRemoteWrite(int index);
    public PrometheusSpecFluent.RemoteWriteNested<A> editFirstRemoteWrite();
    public PrometheusSpecFluent.RemoteWriteNested<A> editLastRemoteWrite();
    public PrometheusSpecFluent.RemoteWriteNested<A> editMatchingRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate);
    public String getReplicaExternalLabelName();
    public A withReplicaExternalLabelName(String replicaExternalLabelName);
    public Boolean hasReplicaExternalLabelName();
    public A withNewReplicaExternalLabelName(String arg1);
    public A withNewReplicaExternalLabelName(StringBuilder arg1);
    public A withNewReplicaExternalLabelName(StringBuffer arg1);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public ResourceRequirements getResources();
    public ResourceRequirements buildResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    public PrometheusSpecFluent.ResourcesNested<A> withNewResources();
    public PrometheusSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
    public PrometheusSpecFluent.ResourcesNested<A> editResources();
    public PrometheusSpecFluent.ResourcesNested<A> editOrNewResources();
    public PrometheusSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
    public String getRetention();
    public A withRetention(String retention);
    public Boolean hasRetention();
    public A withNewRetention(String arg1);
    public A withNewRetention(StringBuilder arg1);
    public A withNewRetention(StringBuffer arg1);
    public String getRetentionSize();
    public A withRetentionSize(String retentionSize);
    public Boolean hasRetentionSize();
    public A withNewRetentionSize(String arg1);
    public A withNewRetentionSize(StringBuilder arg1);
    public A withNewRetentionSize(StringBuffer arg1);
    public String getRoutePrefix();
    public A withRoutePrefix(String routePrefix);
    public Boolean hasRoutePrefix();
    public A withNewRoutePrefix(String arg1);
    public A withNewRoutePrefix(StringBuilder arg1);
    public A withNewRoutePrefix(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildRuleNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getRuleNamespaceSelector();
    public LabelSelector buildRuleNamespaceSelector();
    public A withRuleNamespaceSelector(LabelSelector ruleNamespaceSelector);
    public Boolean hasRuleNamespaceSelector();
    public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> withNewRuleNamespaceSelector();
    public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> withNewRuleNamespaceSelectorLike(LabelSelector item);
    public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> editRuleNamespaceSelector();
    public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> editOrNewRuleNamespaceSelector();
    public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> editOrNewRuleNamespaceSelectorLike(LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildRuleSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getRuleSelector();
    public LabelSelector buildRuleSelector();
    public A withRuleSelector(LabelSelector ruleSelector);
    public Boolean hasRuleSelector();
    public PrometheusSpecFluent.RuleSelectorNested<A> withNewRuleSelector();
    public PrometheusSpecFluent.RuleSelectorNested<A> withNewRuleSelectorLike(LabelSelector item);
    public PrometheusSpecFluent.RuleSelectorNested<A> editRuleSelector();
    public PrometheusSpecFluent.RuleSelectorNested<A> editOrNewRuleSelector();
    public PrometheusSpecFluent.RuleSelectorNested<A> editOrNewRuleSelectorLike(LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public Rules getRules();
    public Rules buildRules();
    public A withRules(Rules rules);
    public Boolean hasRules();
    public PrometheusSpecFluent.RulesNested<A> withNewRules();
    public PrometheusSpecFluent.RulesNested<A> withNewRulesLike(Rules item);
    public PrometheusSpecFluent.RulesNested<A> editRules();
    public PrometheusSpecFluent.RulesNested<A> editOrNewRules();
    public PrometheusSpecFluent.RulesNested<A> editOrNewRulesLike(Rules item);
    public String getScrapeInterval();
    public A withScrapeInterval(String scrapeInterval);
    public Boolean hasScrapeInterval();
    public A withNewScrapeInterval(String arg1);
    public A withNewScrapeInterval(StringBuilder arg1);
    public A withNewScrapeInterval(StringBuffer arg1);
    public String getScrapeTimeout();
    public A withScrapeTimeout(String scrapeTimeout);
    public Boolean hasScrapeTimeout();
    public A withNewScrapeTimeout(String arg1);
    public A withNewScrapeTimeout(StringBuilder arg1);
    public A withNewScrapeTimeout(StringBuffer arg1);
    public A addToSecrets(int index,String item);
    public A setToSecrets(int index,String item);
    public A addToSecrets(String... items);
    public A addAllToSecrets(Collection<String> items);
    public A removeFromSecrets(String... items);
    public A removeAllFromSecrets(Collection<String> items);
    public List<String> getSecrets();
    public String getSecret(int index);
    public String getFirstSecret();
    public String getLastSecret();
    public String getMatchingSecret(Predicate<String> predicate);
    public Boolean hasMatchingSecret(Predicate<String> predicate);
    public A withSecrets(List<String> secrets);
    public A withSecrets(String... secrets);
    public Boolean hasSecrets();
    public A addNewSecret(String arg1);
    public A addNewSecret(StringBuilder arg1);
    public A addNewSecret(StringBuffer arg1);
    public PodSecurityContext getSecurityContext();
    public A withSecurityContext(PodSecurityContext securityContext);
    public Boolean hasSecurityContext();
    public String getServiceAccountName();
    public A withServiceAccountName(String serviceAccountName);
    public Boolean hasServiceAccountName();
    public A withNewServiceAccountName(String arg1);
    public A withNewServiceAccountName(StringBuilder arg1);
    public A withNewServiceAccountName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildServiceMonitorNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getServiceMonitorNamespaceSelector();
    public LabelSelector buildServiceMonitorNamespaceSelector();
    public A withServiceMonitorNamespaceSelector(LabelSelector serviceMonitorNamespaceSelector);
    public Boolean hasServiceMonitorNamespaceSelector();
    public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> withNewServiceMonitorNamespaceSelector();
    public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> withNewServiceMonitorNamespaceSelectorLike(LabelSelector item);
    public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> editServiceMonitorNamespaceSelector();
    public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> editOrNewServiceMonitorNamespaceSelector();
    public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> editOrNewServiceMonitorNamespaceSelectorLike(LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildServiceMonitorSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getServiceMonitorSelector();
    public LabelSelector buildServiceMonitorSelector();
    public A withServiceMonitorSelector(LabelSelector serviceMonitorSelector);
    public Boolean hasServiceMonitorSelector();
    public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> withNewServiceMonitorSelector();
    public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> withNewServiceMonitorSelectorLike(LabelSelector item);
    public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> editServiceMonitorSelector();
    public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> editOrNewServiceMonitorSelector();
    public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> editOrNewServiceMonitorSelectorLike(LabelSelector item);
    public String getSha();
    public A withSha(String sha);
    public Boolean hasSha();
    public A withNewSha(String arg1);
    public A withNewSha(StringBuilder arg1);
    public A withNewSha(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildStorage instead.
 * @return The buildable object.
 */
@Deprecated public StorageSpec getStorage();
    public StorageSpec buildStorage();
    public A withStorage(StorageSpec storage);
    public Boolean hasStorage();
    public PrometheusSpecFluent.StorageNested<A> withNewStorage();
    public PrometheusSpecFluent.StorageNested<A> withNewStorageLike(StorageSpec item);
    public PrometheusSpecFluent.StorageNested<A> editStorage();
    public PrometheusSpecFluent.StorageNested<A> editOrNewStorage();
    public PrometheusSpecFluent.StorageNested<A> editOrNewStorageLike(StorageSpec item);
    public String getTag();
    public A withTag(String tag);
    public Boolean hasTag();
    public A withNewTag(String arg1);
    public A withNewTag(StringBuilder arg1);
    public A withNewTag(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildThanos instead.
 * @return The buildable object.
 */
@Deprecated public ThanosSpec getThanos();
    public ThanosSpec buildThanos();
    public A withThanos(ThanosSpec thanos);
    public Boolean hasThanos();
    public PrometheusSpecFluent.ThanosNested<A> withNewThanos();
    public PrometheusSpecFluent.ThanosNested<A> withNewThanosLike(ThanosSpec item);
    public PrometheusSpecFluent.ThanosNested<A> editThanos();
    public PrometheusSpecFluent.ThanosNested<A> editOrNewThanos();
    public PrometheusSpecFluent.ThanosNested<A> editOrNewThanosLike(ThanosSpec item);
    public A addToTolerations(int index,Toleration item);
    public A setToTolerations(int index,Toleration item);
    public A addToTolerations(Toleration... items);
    public A addAllToTolerations(Collection<Toleration> items);
    public A removeFromTolerations(Toleration... items);
    public A removeAllFromTolerations(Collection<Toleration> items);
    public List<Toleration> getTolerations();
    public Toleration getToleration(int index);
    public Toleration getFirstToleration();
    public Toleration getLastToleration();
    public Toleration getMatchingToleration(Predicate<Toleration> predicate);
    public Boolean hasMatchingToleration(Predicate<Toleration> predicate);
    public A withTolerations(List<Toleration> tolerations);
    public A withTolerations(Toleration... tolerations);
    public Boolean hasTolerations();
    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(String arg1);
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(StringBuffer arg1);
    public A addToVolumeMounts(int index,VolumeMount item);
    public A setToVolumeMounts(int index,VolumeMount item);
    public A addToVolumeMounts(VolumeMount... items);
    public A addAllToVolumeMounts(Collection<VolumeMount> items);
    public A removeFromVolumeMounts(VolumeMount... items);
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items);
    public List<VolumeMount> getVolumeMounts();
    public VolumeMount getVolumeMount(int index);
    public VolumeMount getFirstVolumeMount();
    public VolumeMount getLastVolumeMount();
    public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate);
    public Boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate);
    public A withVolumeMounts(List<VolumeMount> volumeMounts);
    public A withVolumeMounts(VolumeMount... volumeMounts);
    public Boolean hasVolumeMounts();
    public A addToVolumes(int index,Volume item);
    public A setToVolumes(int index,Volume item);
    public A addToVolumes(Volume... items);
    public A addAllToVolumes(Collection<Volume> items);
    public A removeFromVolumes(Volume... items);
    public A removeAllFromVolumes(Collection<Volume> items);
    public List<Volume> getVolumes();
    public Volume getVolume(int index);
    public Volume getFirstVolume();
    public Volume getLastVolume();
    public Volume getMatchingVolume(Predicate<Volume> predicate);
    public Boolean hasMatchingVolume(Predicate<Volume> predicate);
    public A withVolumes(List<Volume> volumes);
    public A withVolumes(Volume... volumes);
    public Boolean hasVolumes();
    public Boolean isWalCompression();
    public A withWalCompression(Boolean walCompression);
    public Boolean hasWalCompression();
    public A withNewWalCompression(String arg1);
    public A withNewWalCompression(boolean arg1);
    public interface AlertingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AlertingSpecFluent<PrometheusSpecFluent.AlertingNested<N>> {

        public N and();
        public N endAlerting();    }


    public interface ApiserverConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServerConfigFluent<PrometheusSpecFluent.ApiserverConfigNested<N>> {

        public N and();
        public N endApiserverConfig();    }


    public interface ArbitraryFSAccessThroughSMsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ArbitraryFSAccessThroughSMsConfigFluent<PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<N>> {

        public N and();
        public N endArbitraryFSAccessThroughSMs();    }


    public interface ContainersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerFluent<PrometheusSpecFluent.ContainersNested<N>> {

        public N and();
        public N endContainer();    }


    public interface ImagePullSecretsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<PrometheusSpecFluent.ImagePullSecretsNested<N>> {

        public N and();
        public N endImagePullSecret();    }


    public interface InitContainersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerFluent<PrometheusSpecFluent.InitContainersNested<N>> {

        public N and();
        public N endInitContainer();    }


    public interface PodMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EmbeddedObjectMetadataFluent<PrometheusSpecFluent.PodMetadataNested<N>> {

        public N and();
        public N endPodMetadata();    }


    public interface PodMonitorNamespaceSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<N>> {

        public N and();
        public N endPodMonitorNamespaceSelector();    }


    public interface PodMonitorSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.PodMonitorSelectorNested<N>> {

        public N and();
        public N endPodMonitorSelector();    }


    public interface ProbeNamespaceSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.ProbeNamespaceSelectorNested<N>> {

        public N and();
        public N endProbeNamespaceSelector();    }


    public interface ProbeSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.ProbeSelectorNested<N>> {

        public N and();
        public N endProbeSelector();    }


    public interface PrometheusRulesExcludedFromEnforceNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PrometheusRuleExcludeConfigFluent<PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<N>> {

        public N and();
        public N endPrometheusRulesExcludedFromEnforce();    }


    public interface QueryNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,QuerySpecFluent<PrometheusSpecFluent.QueryNested<N>> {

        public N and();
        public N endQuery();    }


    public interface RemoteReadNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RemoteReadSpecFluent<PrometheusSpecFluent.RemoteReadNested<N>> {

        public N and();
        public N endRemoteRead();    }


    public interface RemoteWriteNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RemoteWriteSpecFluent<PrometheusSpecFluent.RemoteWriteNested<N>> {

        public N and();
        public N endRemoteWrite();    }


    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceRequirementsFluent<PrometheusSpecFluent.ResourcesNested<N>> {

        public N and();
        public N endResources();    }


    public interface RuleNamespaceSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.RuleNamespaceSelectorNested<N>> {

        public N and();
        public N endRuleNamespaceSelector();    }


    public interface RuleSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.RuleSelectorNested<N>> {

        public N and();
        public N endRuleSelector();    }


    public interface RulesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RulesFluent<PrometheusSpecFluent.RulesNested<N>> {

        public N and();
        public N endRules();    }


    public interface ServiceMonitorNamespaceSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<N>> {

        public N and();
        public N endServiceMonitorNamespaceSelector();    }


    public interface ServiceMonitorSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<PrometheusSpecFluent.ServiceMonitorSelectorNested<N>> {

        public N and();
        public N endServiceMonitorSelector();    }


    public interface StorageNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StorageSpecFluent<PrometheusSpecFluent.StorageNested<N>> {

        public N and();
        public N endStorage();    }


    public interface ThanosNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ThanosSpecFluent<PrometheusSpecFluent.ThanosNested<N>> {

        public N and();
        public N endThanos();    }


}
