package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PrometheusListBuilder extends PrometheusListFluentImpl<PrometheusListBuilder> implements VisitableBuilder<PrometheusList,PrometheusListBuilder> {

    PrometheusListFluent<?> fluent;
    Boolean validationEnabled;

    public PrometheusListBuilder() { 
        this(true);
    }


    public PrometheusListBuilder(Boolean validationEnabled) { 
        this(new PrometheusList(), validationEnabled);
    }


    public PrometheusListBuilder(PrometheusListFluent<?> fluent) { 
        this(fluent, true);
    }


    public PrometheusListBuilder(PrometheusListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new PrometheusList(), validationEnabled);
    }


    public PrometheusListBuilder(PrometheusListFluent<?> fluent,PrometheusList instance) { 
        this(fluent, instance, true);
    }


    public PrometheusListBuilder(PrometheusListFluent<?> fluent,PrometheusList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public PrometheusListBuilder(PrometheusList instance) { 
        this(instance,true);
    }


    public PrometheusListBuilder(PrometheusList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public PrometheusList build() {
        PrometheusList buildable = new PrometheusList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PrometheusListBuilder that = (PrometheusListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
