package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class NamespaceSelectorFluentImpl<A extends NamespaceSelectorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NamespaceSelectorFluent<A> {

    private Boolean any;
    private List<String> matchNames = new ArrayList<String>();

    public NamespaceSelectorFluentImpl() { 
    }


    public NamespaceSelectorFluentImpl(NamespaceSelector instance) { 
        this.withAny(instance.getAny()); 
        this.withMatchNames(instance.getMatchNames()); 
    }


    public Boolean isAny() {
        return this.any;
    }

    public A withAny(Boolean any) {
        this.any=any; return (A) this;
    }

    public Boolean hasAny() {
        return this.any != null;
    }

    public A withNewAny(String arg1) {
        return (A)withAny(new Boolean(arg1));
    }

    public A withNewAny(boolean arg1) {
        return (A)withAny(new Boolean(arg1));
    }

    public A addToMatchNames(int index,String item) {
        if (this.matchNames == null) {this.matchNames = new ArrayList<String>();}
        this.matchNames.add(index, item);
        return (A)this;
    }

    public A setToMatchNames(int index,String item) {
        if (this.matchNames == null) {this.matchNames = new ArrayList<String>();}
        this.matchNames.set(index, item); return (A)this;
    }

    public A addToMatchNames(String... items) {
        if (this.matchNames == null) {this.matchNames = new ArrayList<String>();}
        for (String item : items) {this.matchNames.add(item);} return (A)this;
    }

    public A addAllToMatchNames(Collection<String> items) {
        if (this.matchNames == null) {this.matchNames = new ArrayList<String>();}
        for (String item : items) {this.matchNames.add(item);} return (A)this;
    }

    public A removeFromMatchNames(String... items) {
        for (String item : items) {if (this.matchNames!= null){ this.matchNames.remove(item);}} return (A)this;
    }

    public A removeAllFromMatchNames(Collection<String> items) {
        for (String item : items) {if (this.matchNames!= null){ this.matchNames.remove(item);}} return (A)this;
    }

    public List<String> getMatchNames() {
        return this.matchNames;
    }

    public String getMatchName(int index) {
        return this.matchNames.get(index);
    }

    public String getFirstMatchName() {
        return this.matchNames.get(0);
    }

    public String getLastMatchName() {
        return this.matchNames.get(matchNames.size() - 1);
    }

    public String getMatchingMatchName(Predicate<String> predicate) {
        for (String item: matchNames) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingMatchName(Predicate<String> predicate) {
        for (String item: matchNames) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withMatchNames(List<String> matchNames) {
        if (this.matchNames != null) { _visitables.get("matchNames").removeAll(this.matchNames);}
        if (matchNames != null) {this.matchNames = new ArrayList<String>(); for (String item : matchNames){this.addToMatchNames(item);}} else { this.matchNames = null;} return (A) this;
    }

    public A withMatchNames(String... matchNames) {
        if (this.matchNames != null) {this.matchNames.clear();}
        if (matchNames != null) {for (String item :matchNames){ this.addToMatchNames(item);}} return (A) this;
    }

    public Boolean hasMatchNames() {
        return matchNames != null && !matchNames.isEmpty();
    }

    public A addNewMatchName(String arg1) {
        return (A)addToMatchNames(new String(arg1));
    }

    public A addNewMatchName(StringBuilder arg1) {
        return (A)addToMatchNames(new String(arg1));
    }

    public A addNewMatchName(StringBuffer arg1) {
        return (A)addToMatchNames(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NamespaceSelectorFluentImpl that = (NamespaceSelectorFluentImpl) o;
        if (any != null ? !any.equals(that.any) :that.any != null) return false;
        if (matchNames != null ? !matchNames.equals(that.matchNames) :that.matchNames != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(any,  matchNames,  super.hashCode());
    }

}
