package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class APIServerConfigFluentImpl<A extends APIServerConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements APIServerConfigFluent<A> {

    private BasicAuthBuilder basicAuth;
    private String bearerToken;
    private String bearerTokenFile;
    private String host;
    private TLSConfigBuilder tlsConfig;

    public APIServerConfigFluentImpl() { 
    }


    public APIServerConfigFluentImpl(APIServerConfig instance) { 
        this.withBasicAuth(instance.getBasicAuth()); 
        this.withBearerToken(instance.getBearerToken()); 
        this.withBearerTokenFile(instance.getBearerTokenFile()); 
        this.withHost(instance.getHost()); 
        this.withTlsConfig(instance.getTlsConfig()); 
    }


    
/**
 * This method has been deprecated, please use method buildBasicAuth instead.
 * @return The buildable object.
 */
@Deprecated public BasicAuth getBasicAuth() {
        return this.basicAuth!=null?this.basicAuth.build():null;
    }

    public BasicAuth buildBasicAuth() {
        return this.basicAuth!=null?this.basicAuth.build():null;
    }

    public A withBasicAuth(BasicAuth basicAuth) {
        _visitables.get("basicAuth").remove(this.basicAuth);
        if (basicAuth!=null){ this.basicAuth= new BasicAuthBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} return (A) this;
    }

    public Boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    public APIServerConfigFluent.BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNestedImpl();
    }

    public APIServerConfigFluent.BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNestedImpl(item);
    }

    public APIServerConfigFluent.BasicAuthNested<A> editBasicAuth() {
        return withNewBasicAuthLike(getBasicAuth());
    }

    public APIServerConfigFluent.BasicAuthNested<A> editOrNewBasicAuth() {
        return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new BasicAuthBuilder().build());
    }

    public APIServerConfigFluent.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public A withBearerToken(String bearerToken) {
        this.bearerToken=bearerToken; return (A) this;
    }

    public Boolean hasBearerToken() {
        return this.bearerToken != null;
    }

    public A withNewBearerToken(String arg1) {
        return (A)withBearerToken(new String(arg1));
    }

    public A withNewBearerToken(StringBuilder arg1) {
        return (A)withBearerToken(new String(arg1));
    }

    public A withNewBearerToken(StringBuffer arg1) {
        return (A)withBearerToken(new String(arg1));
    }

    public String getBearerTokenFile() {
        return this.bearerTokenFile;
    }

    public A withBearerTokenFile(String bearerTokenFile) {
        this.bearerTokenFile=bearerTokenFile; return (A) this;
    }

    public Boolean hasBearerTokenFile() {
        return this.bearerTokenFile != null;
    }

    public A withNewBearerTokenFile(String arg1) {
        return (A)withBearerTokenFile(new String(arg1));
    }

    public A withNewBearerTokenFile(StringBuilder arg1) {
        return (A)withBearerTokenFile(new String(arg1));
    }

    public A withNewBearerTokenFile(StringBuffer arg1) {
        return (A)withBearerTokenFile(new String(arg1));
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host=host; return (A) this;
    }

    public Boolean hasHost() {
        return this.host != null;
    }

    public A withNewHost(String arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuilder arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1) {
        return (A)withHost(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTlsConfig instead.
 * @return The buildable object.
 */
@Deprecated public TLSConfig getTlsConfig() {
        return this.tlsConfig!=null?this.tlsConfig.build():null;
    }

    public TLSConfig buildTlsConfig() {
        return this.tlsConfig!=null?this.tlsConfig.build():null;
    }

    public A withTlsConfig(TLSConfig tlsConfig) {
        _visitables.get("tlsConfig").remove(this.tlsConfig);
        if (tlsConfig!=null){ this.tlsConfig= new TLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} return (A) this;
    }

    public Boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public APIServerConfigFluent.TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNestedImpl();
    }

    public APIServerConfigFluent.TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
        return new TlsConfigNestedImpl(item);
    }

    public APIServerConfigFluent.TlsConfigNested<A> editTlsConfig() {
        return withNewTlsConfigLike(getTlsConfig());
    }

    public APIServerConfigFluent.TlsConfigNested<A> editOrNewTlsConfig() {
        return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new TLSConfigBuilder().build());
    }

    public APIServerConfigFluent.TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
        return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        APIServerConfigFluentImpl that = (APIServerConfigFluentImpl) o;
        if (basicAuth != null ? !basicAuth.equals(that.basicAuth) :that.basicAuth != null) return false;
        if (bearerToken != null ? !bearerToken.equals(that.bearerToken) :that.bearerToken != null) return false;
        if (bearerTokenFile != null ? !bearerTokenFile.equals(that.bearerTokenFile) :that.bearerTokenFile != null) return false;
        if (host != null ? !host.equals(that.host) :that.host != null) return false;
        if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(basicAuth,  bearerToken,  bearerTokenFile,  host,  tlsConfig,  super.hashCode());
    }

    public class BasicAuthNestedImpl<N> extends BasicAuthFluentImpl<APIServerConfigFluent.BasicAuthNested<N>> implements APIServerConfigFluent.BasicAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BasicAuthBuilder builder;

        BasicAuthNestedImpl(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        BasicAuthNestedImpl() {
            this.builder = new BasicAuthBuilder(this);
        }

        public N and() {
             return (N) APIServerConfigFluentImpl.this.withBasicAuth(builder.build());
        }

        public N endBasicAuth() {
             return and();
        }
    }


    public class TlsConfigNestedImpl<N> extends TLSConfigFluentImpl<APIServerConfigFluent.TlsConfigNested<N>> implements APIServerConfigFluent.TlsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TLSConfigBuilder builder;

        TlsConfigNestedImpl(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        TlsConfigNestedImpl() {
            this.builder = new TLSConfigBuilder(this);
        }

        public N and() {
             return (N) APIServerConfigFluentImpl.this.withTlsConfig(builder.build());
        }

        public N endTlsConfig() {
             return and();
        }
    }


}
