
package io.fabric8.openshift.api.model.monitoring.v1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "endpoints",
    "jobLabel",
    "namespaceSelector",
    "podTargetLabels",
    "sampleLimit",
    "selector",
    "targetLabels"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class ServiceMonitorSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("endpoints")
    private List<Endpoint> endpoints = new ArrayList<Endpoint>();
    /**
     * 
     * 
     */
    @JsonProperty("jobLabel")
    private String jobLabel;
    /**
     * 
     * 
     */
    @JsonProperty("namespaceSelector")
    private NamespaceSelector namespaceSelector;
    /**
     * 
     * 
     */
    @JsonProperty("podTargetLabels")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<String> podTargetLabels = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("sampleLimit")
    private Long sampleLimit;
    /**
     * 
     * 
     */
    @JsonProperty("selector")
    private io.fabric8.kubernetes.api.model.LabelSelector selector;
    /**
     * 
     * 
     */
    @JsonProperty("targetLabels")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<String> targetLabels = new ArrayList<String>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ServiceMonitorSpec() {
    }

    /**
     * 
     * @param jobLabel
     * @param podTargetLabels
     * @param sampleLimit
     * @param endpoints
     * @param targetLabels
     * @param namespaceSelector
     * @param selector
     */
    public ServiceMonitorSpec(List<Endpoint> endpoints, String jobLabel, NamespaceSelector namespaceSelector, List<String> podTargetLabels, Long sampleLimit, io.fabric8.kubernetes.api.model.LabelSelector selector, List<String> targetLabels) {
        this.endpoints = endpoints;
        this.jobLabel = jobLabel;
        this.namespaceSelector = namespaceSelector;
        this.podTargetLabels = podTargetLabels;
        this.sampleLimit = sampleLimit;
        this.selector = selector;
        this.targetLabels = targetLabels;
    }

    /**
     * 
     * 
     * @return
     *     The endpoints
     */
    @JsonProperty("endpoints")
    public List<Endpoint> getEndpoints() {
        return endpoints;
    }

    /**
     * 
     * 
     * @param endpoints
     *     The endpoints
     */
    @JsonProperty("endpoints")
    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    /**
     * 
     * 
     * @return
     *     The jobLabel
     */
    @JsonProperty("jobLabel")
    public String getJobLabel() {
        return jobLabel;
    }

    /**
     * 
     * 
     * @param jobLabel
     *     The jobLabel
     */
    @JsonProperty("jobLabel")
    public void setJobLabel(String jobLabel) {
        this.jobLabel = jobLabel;
    }

    /**
     * 
     * 
     * @return
     *     The namespaceSelector
     */
    @JsonProperty("namespaceSelector")
    public NamespaceSelector getNamespaceSelector() {
        return namespaceSelector;
    }

    /**
     * 
     * 
     * @param namespaceSelector
     *     The namespaceSelector
     */
    @JsonProperty("namespaceSelector")
    public void setNamespaceSelector(NamespaceSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
    }

    /**
     * 
     * 
     * @return
     *     The podTargetLabels
     */
    @JsonProperty("podTargetLabels")
    public List<String> getPodTargetLabels() {
        return podTargetLabels;
    }

    /**
     * 
     * 
     * @param podTargetLabels
     *     The podTargetLabels
     */
    @JsonProperty("podTargetLabels")
    public void setPodTargetLabels(List<String> podTargetLabels) {
        this.podTargetLabels = podTargetLabels;
    }

    /**
     * 
     * 
     * @return
     *     The sampleLimit
     */
    @JsonProperty("sampleLimit")
    public Long getSampleLimit() {
        return sampleLimit;
    }

    /**
     * 
     * 
     * @param sampleLimit
     *     The sampleLimit
     */
    @JsonProperty("sampleLimit")
    public void setSampleLimit(Long sampleLimit) {
        this.sampleLimit = sampleLimit;
    }

    /**
     * 
     * 
     * @return
     *     The selector
     */
    @JsonProperty("selector")
    public io.fabric8.kubernetes.api.model.LabelSelector getSelector() {
        return selector;
    }

    /**
     * 
     * 
     * @param selector
     *     The selector
     */
    @JsonProperty("selector")
    public void setSelector(io.fabric8.kubernetes.api.model.LabelSelector selector) {
        this.selector = selector;
    }

    /**
     * 
     * 
     * @return
     *     The targetLabels
     */
    @JsonProperty("targetLabels")
    public List<String> getTargetLabels() {
        return targetLabels;
    }

    /**
     * 
     * 
     * @param targetLabels
     *     The targetLabels
     */
    @JsonProperty("targetLabels")
    public void setTargetLabels(List<String> targetLabels) {
        this.targetLabels = targetLabels;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
