package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class RemoteWriteSpecFluentImpl<A extends RemoteWriteSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RemoteWriteSpecFluent<A> {

    private BasicAuthBuilder basicAuth;
    private String bearerToken;
    private String bearerTokenFile;
    private String name;
    private String proxyUrl;
    private QueueConfigBuilder queueConfig;
    private String remoteTimeout;
    private TLSConfigBuilder tlsConfig;
    private String url;
    private List<RelabelConfigBuilder> writeRelabelConfigs =  new ArrayList<RelabelConfigBuilder>();

    public RemoteWriteSpecFluentImpl() { 
    }


    public RemoteWriteSpecFluentImpl(RemoteWriteSpec instance) { 
        this.withBasicAuth(instance.getBasicAuth()); 
        this.withBearerToken(instance.getBearerToken()); 
        this.withBearerTokenFile(instance.getBearerTokenFile()); 
        this.withName(instance.getName()); 
        this.withProxyUrl(instance.getProxyUrl()); 
        this.withQueueConfig(instance.getQueueConfig()); 
        this.withRemoteTimeout(instance.getRemoteTimeout()); 
        this.withTlsConfig(instance.getTlsConfig()); 
        this.withUrl(instance.getUrl()); 
        this.withWriteRelabelConfigs(instance.getWriteRelabelConfigs()); 
    }


    
/**
 * This method has been deprecated, please use method buildBasicAuth instead.
 * @return The buildable object.
 */
@Deprecated public BasicAuth getBasicAuth() {
        return this.basicAuth!=null?this.basicAuth.build():null;
    }

    public BasicAuth buildBasicAuth() {
        return this.basicAuth!=null?this.basicAuth.build():null;
    }

    public A withBasicAuth(BasicAuth basicAuth) {
        _visitables.get("basicAuth").remove(this.basicAuth);
        if (basicAuth!=null){ this.basicAuth= new BasicAuthBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} return (A) this;
    }

    public Boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    public RemoteWriteSpecFluent.BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNestedImpl();
    }

    public RemoteWriteSpecFluent.BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNestedImpl(item);
    }

    public RemoteWriteSpecFluent.BasicAuthNested<A> editBasicAuth() {
        return withNewBasicAuthLike(getBasicAuth());
    }

    public RemoteWriteSpecFluent.BasicAuthNested<A> editOrNewBasicAuth() {
        return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new BasicAuthBuilder().build());
    }

    public RemoteWriteSpecFluent.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public A withBearerToken(String bearerToken) {
        this.bearerToken=bearerToken; return (A) this;
    }

    public Boolean hasBearerToken() {
        return this.bearerToken != null;
    }

    public A withNewBearerToken(String arg1) {
        return (A)withBearerToken(new String(arg1));
    }

    public A withNewBearerToken(StringBuilder arg1) {
        return (A)withBearerToken(new String(arg1));
    }

    public A withNewBearerToken(StringBuffer arg1) {
        return (A)withBearerToken(new String(arg1));
    }

    public String getBearerTokenFile() {
        return this.bearerTokenFile;
    }

    public A withBearerTokenFile(String bearerTokenFile) {
        this.bearerTokenFile=bearerTokenFile; return (A) this;
    }

    public Boolean hasBearerTokenFile() {
        return this.bearerTokenFile != null;
    }

    public A withNewBearerTokenFile(String arg1) {
        return (A)withBearerTokenFile(new String(arg1));
    }

    public A withNewBearerTokenFile(StringBuilder arg1) {
        return (A)withBearerTokenFile(new String(arg1));
    }

    public A withNewBearerTokenFile(StringBuffer arg1) {
        return (A)withBearerTokenFile(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl=proxyUrl; return (A) this;
    }

    public Boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public A withNewProxyUrl(String arg1) {
        return (A)withProxyUrl(new String(arg1));
    }

    public A withNewProxyUrl(StringBuilder arg1) {
        return (A)withProxyUrl(new String(arg1));
    }

    public A withNewProxyUrl(StringBuffer arg1) {
        return (A)withProxyUrl(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildQueueConfig instead.
 * @return The buildable object.
 */
@Deprecated public QueueConfig getQueueConfig() {
        return this.queueConfig!=null?this.queueConfig.build():null;
    }

    public QueueConfig buildQueueConfig() {
        return this.queueConfig!=null?this.queueConfig.build():null;
    }

    public A withQueueConfig(QueueConfig queueConfig) {
        _visitables.get("queueConfig").remove(this.queueConfig);
        if (queueConfig!=null){ this.queueConfig= new QueueConfigBuilder(queueConfig); _visitables.get("queueConfig").add(this.queueConfig);} return (A) this;
    }

    public Boolean hasQueueConfig() {
        return this.queueConfig != null;
    }

    public RemoteWriteSpecFluent.QueueConfigNested<A> withNewQueueConfig() {
        return new QueueConfigNestedImpl();
    }

    public RemoteWriteSpecFluent.QueueConfigNested<A> withNewQueueConfigLike(QueueConfig item) {
        return new QueueConfigNestedImpl(item);
    }

    public RemoteWriteSpecFluent.QueueConfigNested<A> editQueueConfig() {
        return withNewQueueConfigLike(getQueueConfig());
    }

    public RemoteWriteSpecFluent.QueueConfigNested<A> editOrNewQueueConfig() {
        return withNewQueueConfigLike(getQueueConfig() != null ? getQueueConfig(): new QueueConfigBuilder().build());
    }

    public RemoteWriteSpecFluent.QueueConfigNested<A> editOrNewQueueConfigLike(QueueConfig item) {
        return withNewQueueConfigLike(getQueueConfig() != null ? getQueueConfig(): item);
    }

    public String getRemoteTimeout() {
        return this.remoteTimeout;
    }

    public A withRemoteTimeout(String remoteTimeout) {
        this.remoteTimeout=remoteTimeout; return (A) this;
    }

    public Boolean hasRemoteTimeout() {
        return this.remoteTimeout != null;
    }

    public A withNewRemoteTimeout(String arg1) {
        return (A)withRemoteTimeout(new String(arg1));
    }

    public A withNewRemoteTimeout(StringBuilder arg1) {
        return (A)withRemoteTimeout(new String(arg1));
    }

    public A withNewRemoteTimeout(StringBuffer arg1) {
        return (A)withRemoteTimeout(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTlsConfig instead.
 * @return The buildable object.
 */
@Deprecated public TLSConfig getTlsConfig() {
        return this.tlsConfig!=null?this.tlsConfig.build():null;
    }

    public TLSConfig buildTlsConfig() {
        return this.tlsConfig!=null?this.tlsConfig.build():null;
    }

    public A withTlsConfig(TLSConfig tlsConfig) {
        _visitables.get("tlsConfig").remove(this.tlsConfig);
        if (tlsConfig!=null){ this.tlsConfig= new TLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} return (A) this;
    }

    public Boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public RemoteWriteSpecFluent.TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNestedImpl();
    }

    public RemoteWriteSpecFluent.TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
        return new TlsConfigNestedImpl(item);
    }

    public RemoteWriteSpecFluent.TlsConfigNested<A> editTlsConfig() {
        return withNewTlsConfigLike(getTlsConfig());
    }

    public RemoteWriteSpecFluent.TlsConfigNested<A> editOrNewTlsConfig() {
        return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new TLSConfigBuilder().build());
    }

    public RemoteWriteSpecFluent.TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
        return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url=url; return (A) this;
    }

    public Boolean hasUrl() {
        return this.url != null;
    }

    public A withNewUrl(String arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuilder arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A addToWriteRelabelConfigs(int index,RelabelConfig item) {
        if (this.writeRelabelConfigs == null) {this.writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>();}
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("writeRelabelConfigs").add(index >= 0 ? index : _visitables.get("writeRelabelConfigs").size(), builder);this.writeRelabelConfigs.add(index >= 0 ? index : writeRelabelConfigs.size(), builder); return (A)this;
    }

    public A setToWriteRelabelConfigs(int index,RelabelConfig item) {
        if (this.writeRelabelConfigs == null) {this.writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>();}
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= _visitables.get("writeRelabelConfigs").size()) { _visitables.get("writeRelabelConfigs").add(builder); } else { _visitables.get("writeRelabelConfigs").set(index, builder);}
        if (index < 0 || index >= writeRelabelConfigs.size()) { writeRelabelConfigs.add(builder); } else { writeRelabelConfigs.set(index, builder);}
         return (A)this;
    }

    public A addToWriteRelabelConfigs(RelabelConfig... items) {
        if (this.writeRelabelConfigs == null) {this.writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>();}
        for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("writeRelabelConfigs").add(builder);this.writeRelabelConfigs.add(builder);} return (A)this;
    }

    public A addAllToWriteRelabelConfigs(Collection<RelabelConfig> items) {
        if (this.writeRelabelConfigs == null) {this.writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>();}
        for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("writeRelabelConfigs").add(builder);this.writeRelabelConfigs.add(builder);} return (A)this;
    }

    public A removeFromWriteRelabelConfigs(RelabelConfig... items) {
        for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("writeRelabelConfigs").remove(builder);if (this.writeRelabelConfigs != null) {this.writeRelabelConfigs.remove(builder);}} return (A)this;
    }

    public A removeAllFromWriteRelabelConfigs(Collection<RelabelConfig> items) {
        for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("writeRelabelConfigs").remove(builder);if (this.writeRelabelConfigs != null) {this.writeRelabelConfigs.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromWriteRelabelConfigs(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate) {
        if (writeRelabelConfigs == null) return (A) this;
        final Iterator<RelabelConfigBuilder> each = writeRelabelConfigs.iterator();
        final List visitables = _visitables.get("writeRelabelConfigs");
        while (each.hasNext()) {
          RelabelConfigBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildWriteRelabelConfigs instead.
 * @return The buildable object.
 */
@Deprecated public List<RelabelConfig> getWriteRelabelConfigs() {
        return build(writeRelabelConfigs);
    }

    public List<RelabelConfig> buildWriteRelabelConfigs() {
        return build(writeRelabelConfigs);
    }

    public RelabelConfig buildWriteRelabelConfig(int index) {
        return this.writeRelabelConfigs.get(index).build();
    }

    public RelabelConfig buildFirstWriteRelabelConfig() {
        return this.writeRelabelConfigs.get(0).build();
    }

    public RelabelConfig buildLastWriteRelabelConfig() {
        return this.writeRelabelConfigs.get(writeRelabelConfigs.size() - 1).build();
    }

    public RelabelConfig buildMatchingWriteRelabelConfig(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item: writeRelabelConfigs) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingWriteRelabelConfig(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item: writeRelabelConfigs) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withWriteRelabelConfigs(List<RelabelConfig> writeRelabelConfigs) {
        if (this.writeRelabelConfigs != null) { _visitables.get("writeRelabelConfigs").removeAll(this.writeRelabelConfigs);}
        if (writeRelabelConfigs != null) {this.writeRelabelConfigs = new ArrayList<RelabelConfigBuilder>(); for (RelabelConfig item : writeRelabelConfigs){this.addToWriteRelabelConfigs(item);}} else { this.writeRelabelConfigs = null;} return (A) this;
    }

    public A withWriteRelabelConfigs(RelabelConfig... writeRelabelConfigs) {
        if (this.writeRelabelConfigs != null) {this.writeRelabelConfigs.clear();}
        if (writeRelabelConfigs != null) {for (RelabelConfig item :writeRelabelConfigs){ this.addToWriteRelabelConfigs(item);}} return (A) this;
    }

    public Boolean hasWriteRelabelConfigs() {
        return writeRelabelConfigs != null && !writeRelabelConfigs.isEmpty();
    }

    public RemoteWriteSpecFluent.WriteRelabelConfigsNested<A> addNewWriteRelabelConfig() {
        return new WriteRelabelConfigsNestedImpl();
    }

    public RemoteWriteSpecFluent.WriteRelabelConfigsNested<A> addNewWriteRelabelConfigLike(RelabelConfig item) {
        return new WriteRelabelConfigsNestedImpl(-1, item);
    }

    public RemoteWriteSpecFluent.WriteRelabelConfigsNested<A> setNewWriteRelabelConfigLike(int index,RelabelConfig item) {
        return new WriteRelabelConfigsNestedImpl(index, item);
    }

    public RemoteWriteSpecFluent.WriteRelabelConfigsNested<A> editWriteRelabelConfig(int index) {
        if (writeRelabelConfigs.size() <= index) throw new RuntimeException("Can't edit writeRelabelConfigs. Index exceeds size.");
        return setNewWriteRelabelConfigLike(index, buildWriteRelabelConfig(index));
    }

    public RemoteWriteSpecFluent.WriteRelabelConfigsNested<A> editFirstWriteRelabelConfig() {
        if (writeRelabelConfigs.size() == 0) throw new RuntimeException("Can't edit first writeRelabelConfigs. The list is empty.");
        return setNewWriteRelabelConfigLike(0, buildWriteRelabelConfig(0));
    }

    public RemoteWriteSpecFluent.WriteRelabelConfigsNested<A> editLastWriteRelabelConfig() {
        int index = writeRelabelConfigs.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last writeRelabelConfigs. The list is empty.");
        return setNewWriteRelabelConfigLike(index, buildWriteRelabelConfig(index));
    }

    public RemoteWriteSpecFluent.WriteRelabelConfigsNested<A> editMatchingWriteRelabelConfig(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i=0;i<writeRelabelConfigs.size();i++) { 
        if (predicate.apply(writeRelabelConfigs.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching writeRelabelConfigs. No match found.");
        return setNewWriteRelabelConfigLike(index, buildWriteRelabelConfig(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RemoteWriteSpecFluentImpl that = (RemoteWriteSpecFluentImpl) o;
        if (basicAuth != null ? !basicAuth.equals(that.basicAuth) :that.basicAuth != null) return false;
        if (bearerToken != null ? !bearerToken.equals(that.bearerToken) :that.bearerToken != null) return false;
        if (bearerTokenFile != null ? !bearerTokenFile.equals(that.bearerTokenFile) :that.bearerTokenFile != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (proxyUrl != null ? !proxyUrl.equals(that.proxyUrl) :that.proxyUrl != null) return false;
        if (queueConfig != null ? !queueConfig.equals(that.queueConfig) :that.queueConfig != null) return false;
        if (remoteTimeout != null ? !remoteTimeout.equals(that.remoteTimeout) :that.remoteTimeout != null) return false;
        if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        if (writeRelabelConfigs != null ? !writeRelabelConfigs.equals(that.writeRelabelConfigs) :that.writeRelabelConfigs != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(basicAuth,  bearerToken,  bearerTokenFile,  name,  proxyUrl,  queueConfig,  remoteTimeout,  tlsConfig,  url,  writeRelabelConfigs,  super.hashCode());
    }

    public class BasicAuthNestedImpl<N> extends BasicAuthFluentImpl<RemoteWriteSpecFluent.BasicAuthNested<N>> implements RemoteWriteSpecFluent.BasicAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BasicAuthBuilder builder;

        BasicAuthNestedImpl(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        BasicAuthNestedImpl() {
            this.builder = new BasicAuthBuilder(this);
        }

        public N and() {
             return (N) RemoteWriteSpecFluentImpl.this.withBasicAuth(builder.build());
        }

        public N endBasicAuth() {
             return and();
        }
    }


    public class QueueConfigNestedImpl<N> extends QueueConfigFluentImpl<RemoteWriteSpecFluent.QueueConfigNested<N>> implements RemoteWriteSpecFluent.QueueConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final QueueConfigBuilder builder;

        QueueConfigNestedImpl(QueueConfig item) {
            this.builder = new QueueConfigBuilder(this, item);
        }

        QueueConfigNestedImpl() {
            this.builder = new QueueConfigBuilder(this);
        }

        public N and() {
             return (N) RemoteWriteSpecFluentImpl.this.withQueueConfig(builder.build());
        }

        public N endQueueConfig() {
             return and();
        }
    }


    public class TlsConfigNestedImpl<N> extends TLSConfigFluentImpl<RemoteWriteSpecFluent.TlsConfigNested<N>> implements RemoteWriteSpecFluent.TlsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TLSConfigBuilder builder;

        TlsConfigNestedImpl(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        TlsConfigNestedImpl() {
            this.builder = new TLSConfigBuilder(this);
        }

        public N and() {
             return (N) RemoteWriteSpecFluentImpl.this.withTlsConfig(builder.build());
        }

        public N endTlsConfig() {
             return and();
        }
    }


    public class WriteRelabelConfigsNestedImpl<N> extends RelabelConfigFluentImpl<RemoteWriteSpecFluent.WriteRelabelConfigsNested<N>> implements RemoteWriteSpecFluent.WriteRelabelConfigsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RelabelConfigBuilder builder;
        private final int index;

        WriteRelabelConfigsNestedImpl(int index,RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        WriteRelabelConfigsNestedImpl() {
            this.index = -1;
            this.builder = new RelabelConfigBuilder(this);
        }

        public N and() {
             return (N) RemoteWriteSpecFluentImpl.this.setToWriteRelabelConfigs(index,builder.build());
        }

        public N endWriteRelabelConfig() {
             return and();
        }
    }


}
