
package io.fabric8.openshift.api.model.monitoring.v1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "additionalAlertManagerConfigs",
    "additionalAlertRelabelConfigs",
    "additionalScrapeConfigs",
    "affinity",
    "alerting",
    "allowOverlappingBlocks",
    "apiserverConfig",
    "arbitraryFSAccessThroughSMs",
    "baseImage",
    "configMaps",
    "containers",
    "disableCompaction",
    "enableAdminAPI",
    "enforcedNamespaceLabel",
    "enforcedSampleLimit",
    "evaluationInterval",
    "externalLabels",
    "externalUrl",
    "ignoreNamespaceSelectors",
    "image",
    "imagePullSecrets",
    "initContainers",
    "listenLocal",
    "logFormat",
    "logLevel",
    "nodeSelector",
    "overrideHonorLabels",
    "overrideHonorTimestamps",
    "paused",
    "podMetadata",
    "podMonitorNamespaceSelector",
    "podMonitorSelector",
    "portName",
    "priorityClassName",
    "probeNamespaceSelector",
    "probeSelector",
    "prometheusExternalLabelName",
    "prometheusRulesExcludedFromEnforce",
    "query",
    "queryLogFile",
    "remoteRead",
    "remoteWrite",
    "replicaExternalLabelName",
    "replicas",
    "resources",
    "retention",
    "retentionSize",
    "routePrefix",
    "ruleNamespaceSelector",
    "ruleSelector",
    "rules",
    "scrapeInterval",
    "scrapeTimeout",
    "secrets",
    "securityContext",
    "serviceAccountName",
    "serviceMonitorNamespaceSelector",
    "serviceMonitorSelector",
    "sha",
    "storage",
    "tag",
    "thanos",
    "tolerations",
    "version",
    "volumeMounts",
    "volumes",
    "walCompression"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.LabelSelector.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class PrometheusSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("additionalAlertManagerConfigs")
    private SecretKeySelector additionalAlertManagerConfigs;
    /**
     * 
     * 
     */
    @JsonProperty("additionalAlertRelabelConfigs")
    private SecretKeySelector additionalAlertRelabelConfigs;
    /**
     * 
     * 
     */
    @JsonProperty("additionalScrapeConfigs")
    private SecretKeySelector additionalScrapeConfigs;
    /**
     * 
     * 
     */
    @JsonProperty("affinity")
    private Affinity affinity;
    /**
     * 
     * 
     */
    @JsonProperty("alerting")
    private AlertingSpec alerting;
    /**
     * 
     * 
     */
    @JsonProperty("allowOverlappingBlocks")
    private Boolean allowOverlappingBlocks;
    /**
     * 
     * 
     */
    @JsonProperty("apiserverConfig")
    private APIServerConfig apiserverConfig;
    /**
     * 
     * 
     */
    @JsonProperty("arbitraryFSAccessThroughSMs")
    private ArbitraryFSAccessThroughSMsConfig arbitraryFSAccessThroughSMs;
    /**
     * 
     * 
     */
    @JsonProperty("baseImage")
    private java.lang.String baseImage;
    /**
     * 
     * 
     */
    @JsonProperty("configMaps")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<java.lang.String> configMaps = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("containers")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<io.fabric8.kubernetes.api.model.Container> containers = new ArrayList<io.fabric8.kubernetes.api.model.Container>();
    /**
     * 
     * 
     */
    @JsonProperty("disableCompaction")
    private Boolean disableCompaction;
    /**
     * 
     * 
     */
    @JsonProperty("enableAdminAPI")
    private Boolean enableAdminAPI;
    /**
     * 
     * 
     */
    @JsonProperty("enforcedNamespaceLabel")
    private java.lang.String enforcedNamespaceLabel;
    /**
     * 
     * 
     */
    @JsonProperty("enforcedSampleLimit")
    private Long enforcedSampleLimit;
    /**
     * 
     * 
     */
    @JsonProperty("evaluationInterval")
    private java.lang.String evaluationInterval;
    /**
     * 
     * 
     */
    @JsonProperty("externalLabels")
    private Map<String, String> externalLabels;
    /**
     * 
     * 
     */
    @JsonProperty("externalUrl")
    private java.lang.String externalUrl;
    /**
     * 
     * 
     */
    @JsonProperty("ignoreNamespaceSelectors")
    private Boolean ignoreNamespaceSelectors;
    /**
     * 
     * 
     */
    @JsonProperty("image")
    private java.lang.String image;
    /**
     * 
     * 
     */
    @JsonProperty("imagePullSecrets")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<io.fabric8.kubernetes.api.model.LocalObjectReference> imagePullSecrets = new ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>();
    /**
     * 
     * 
     */
    @JsonProperty("initContainers")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<io.fabric8.kubernetes.api.model.Container> initContainers = new ArrayList<io.fabric8.kubernetes.api.model.Container>();
    /**
     * 
     * 
     */
    @JsonProperty("listenLocal")
    private Boolean listenLocal;
    /**
     * 
     * 
     */
    @JsonProperty("logFormat")
    private java.lang.String logFormat;
    /**
     * 
     * 
     */
    @JsonProperty("logLevel")
    private java.lang.String logLevel;
    /**
     * 
     * 
     */
    @JsonProperty("nodeSelector")
    private Map<String, String> nodeSelector;
    /**
     * 
     * 
     */
    @JsonProperty("overrideHonorLabels")
    private Boolean overrideHonorLabels;
    /**
     * 
     * 
     */
    @JsonProperty("overrideHonorTimestamps")
    private Boolean overrideHonorTimestamps;
    /**
     * 
     * 
     */
    @JsonProperty("paused")
    private Boolean paused;
    /**
     * 
     * 
     */
    @JsonProperty("podMetadata")
    private EmbeddedObjectMetadata podMetadata;
    /**
     * 
     * 
     */
    @JsonProperty("podMonitorNamespaceSelector")
    private io.fabric8.kubernetes.api.model.LabelSelector podMonitorNamespaceSelector;
    /**
     * 
     * 
     */
    @JsonProperty("podMonitorSelector")
    private io.fabric8.kubernetes.api.model.LabelSelector podMonitorSelector;
    /**
     * 
     * 
     */
    @JsonProperty("portName")
    private java.lang.String portName;
    /**
     * 
     * 
     */
    @JsonProperty("priorityClassName")
    private java.lang.String priorityClassName;
    /**
     * 
     * 
     */
    @JsonProperty("probeNamespaceSelector")
    private io.fabric8.kubernetes.api.model.LabelSelector probeNamespaceSelector;
    /**
     * 
     * 
     */
    @JsonProperty("probeSelector")
    private io.fabric8.kubernetes.api.model.LabelSelector probeSelector;
    /**
     * 
     * 
     */
    @JsonProperty("prometheusExternalLabelName")
    private java.lang.String prometheusExternalLabelName;
    /**
     * 
     * 
     */
    @JsonProperty("prometheusRulesExcludedFromEnforce")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<PrometheusRuleExcludeConfig> prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfig>();
    /**
     * 
     * 
     */
    @JsonProperty("query")
    private QuerySpec query;
    /**
     * 
     * 
     */
    @JsonProperty("queryLogFile")
    private java.lang.String queryLogFile;
    /**
     * 
     * 
     */
    @JsonProperty("remoteRead")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<RemoteReadSpec> remoteRead = new ArrayList<RemoteReadSpec>();
    /**
     * 
     * 
     */
    @JsonProperty("remoteWrite")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<RemoteWriteSpec> remoteWrite = new ArrayList<RemoteWriteSpec>();
    /**
     * 
     * 
     */
    @JsonProperty("replicaExternalLabelName")
    private java.lang.String replicaExternalLabelName;
    /**
     * 
     * 
     */
    @JsonProperty("replicas")
    private Integer replicas;
    /**
     * 
     * 
     */
    @JsonProperty("resources")
    private io.fabric8.kubernetes.api.model.ResourceRequirements resources;
    /**
     * 
     * 
     */
    @JsonProperty("retention")
    private java.lang.String retention;
    /**
     * 
     * 
     */
    @JsonProperty("retentionSize")
    private java.lang.String retentionSize;
    /**
     * 
     * 
     */
    @JsonProperty("routePrefix")
    private java.lang.String routePrefix;
    /**
     * 
     * 
     */
    @JsonProperty("ruleNamespaceSelector")
    private io.fabric8.kubernetes.api.model.LabelSelector ruleNamespaceSelector;
    /**
     * 
     * 
     */
    @JsonProperty("ruleSelector")
    private io.fabric8.kubernetes.api.model.LabelSelector ruleSelector;
    /**
     * 
     * 
     */
    @JsonProperty("rules")
    private Rules rules;
    /**
     * 
     * 
     */
    @JsonProperty("scrapeInterval")
    private java.lang.String scrapeInterval;
    /**
     * 
     * 
     */
    @JsonProperty("scrapeTimeout")
    private java.lang.String scrapeTimeout;
    /**
     * 
     * 
     */
    @JsonProperty("secrets")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<java.lang.String> secrets = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("securityContext")
    private PodSecurityContext securityContext;
    /**
     * 
     * 
     */
    @JsonProperty("serviceAccountName")
    private java.lang.String serviceAccountName;
    /**
     * 
     * 
     */
    @JsonProperty("serviceMonitorNamespaceSelector")
    private io.fabric8.kubernetes.api.model.LabelSelector serviceMonitorNamespaceSelector;
    /**
     * 
     * 
     */
    @JsonProperty("serviceMonitorSelector")
    private io.fabric8.kubernetes.api.model.LabelSelector serviceMonitorSelector;
    /**
     * 
     * 
     */
    @JsonProperty("sha")
    private java.lang.String sha;
    /**
     * 
     * 
     */
    @JsonProperty("storage")
    private StorageSpec storage;
    /**
     * 
     * 
     */
    @JsonProperty("tag")
    private java.lang.String tag;
    /**
     * 
     * 
     */
    @JsonProperty("thanos")
    private ThanosSpec thanos;
    /**
     * 
     * 
     */
    @JsonProperty("tolerations")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    /**
     * 
     * 
     */
    @JsonProperty("version")
    private java.lang.String version;
    /**
     * 
     * 
     */
    @JsonProperty("volumeMounts")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    /**
     * 
     * 
     */
    @JsonProperty("volumes")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<Volume> volumes = new ArrayList<Volume>();
    /**
     * 
     * 
     */
    @JsonProperty("walCompression")
    private Boolean walCompression;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PrometheusSpec() {
    }

    /**
     * 
     * @param paused
     * @param probeNamespaceSelector
     * @param ruleSelector
     * @param serviceAccountName
     * @param baseImage
     * @param priorityClassName
     * @param prometheusRulesExcludedFromEnforce
     * @param rules
     * @param securityContext
     * @param nodeSelector
     * @param volumeMounts
     * @param tolerations
     * @param scrapeInterval
     * @param queryLogFile
     * @param tag
     * @param thanos
     * @param image
     * @param query
     * @param volumes
     * @param listenLocal
     * @param secrets
     * @param sha
     * @param version
     * @param serviceMonitorNamespaceSelector
     * @param logFormat
     * @param evaluationInterval
     * @param retentionSize
     * @param containers
     * @param probeSelector
     * @param podMetadata
     * @param affinity
     * @param externalLabels
     * @param ruleNamespaceSelector
     * @param arbitraryFSAccessThroughSMs
     * @param disableCompaction
     * @param imagePullSecrets
     * @param replicaExternalLabelName
     * @param ignoreNamespaceSelectors
     * @param portName
     * @param storage
     * @param apiserverConfig
     * @param podMonitorSelector
     * @param alerting
     * @param prometheusExternalLabelName
     * @param logLevel
     * @param enableAdminAPI
     * @param walCompression
     * @param podMonitorNamespaceSelector
     * @param serviceMonitorSelector
     * @param overrideHonorTimestamps
     * @param retention
     * @param externalUrl
     * @param additionalAlertManagerConfigs
     * @param overrideHonorLabels
     * @param scrapeTimeout
     * @param replicas
     * @param additionalAlertRelabelConfigs
     * @param resources
     * @param enforcedNamespaceLabel
     * @param remoteRead
     * @param enforcedSampleLimit
     * @param additionalScrapeConfigs
     * @param allowOverlappingBlocks
     * @param configMaps
     * @param routePrefix
     * @param remoteWrite
     * @param initContainers
     */
    public PrometheusSpec(SecretKeySelector additionalAlertManagerConfigs, SecretKeySelector additionalAlertRelabelConfigs, SecretKeySelector additionalScrapeConfigs, Affinity affinity, AlertingSpec alerting, Boolean allowOverlappingBlocks, APIServerConfig apiserverConfig, ArbitraryFSAccessThroughSMsConfig arbitraryFSAccessThroughSMs, java.lang.String baseImage, List<java.lang.String> configMaps, List<io.fabric8.kubernetes.api.model.Container> containers, Boolean disableCompaction, Boolean enableAdminAPI, java.lang.String enforcedNamespaceLabel, Long enforcedSampleLimit, java.lang.String evaluationInterval, Map<String, String> externalLabels, java.lang.String externalUrl, Boolean ignoreNamespaceSelectors, java.lang.String image, List<io.fabric8.kubernetes.api.model.LocalObjectReference> imagePullSecrets, List<io.fabric8.kubernetes.api.model.Container> initContainers, Boolean listenLocal, java.lang.String logFormat, java.lang.String logLevel, Map<String, String> nodeSelector, Boolean overrideHonorLabels, Boolean overrideHonorTimestamps, Boolean paused, EmbeddedObjectMetadata podMetadata, io.fabric8.kubernetes.api.model.LabelSelector podMonitorNamespaceSelector, io.fabric8.kubernetes.api.model.LabelSelector podMonitorSelector, java.lang.String portName, java.lang.String priorityClassName, io.fabric8.kubernetes.api.model.LabelSelector probeNamespaceSelector, io.fabric8.kubernetes.api.model.LabelSelector probeSelector, java.lang.String prometheusExternalLabelName, List<PrometheusRuleExcludeConfig> prometheusRulesExcludedFromEnforce, QuerySpec query, java.lang.String queryLogFile, List<RemoteReadSpec> remoteRead, List<RemoteWriteSpec> remoteWrite, java.lang.String replicaExternalLabelName, Integer replicas, io.fabric8.kubernetes.api.model.ResourceRequirements resources, java.lang.String retention, java.lang.String retentionSize, java.lang.String routePrefix, io.fabric8.kubernetes.api.model.LabelSelector ruleNamespaceSelector, io.fabric8.kubernetes.api.model.LabelSelector ruleSelector, Rules rules, java.lang.String scrapeInterval, java.lang.String scrapeTimeout, List<java.lang.String> secrets, PodSecurityContext securityContext, java.lang.String serviceAccountName, io.fabric8.kubernetes.api.model.LabelSelector serviceMonitorNamespaceSelector, io.fabric8.kubernetes.api.model.LabelSelector serviceMonitorSelector, java.lang.String sha, StorageSpec storage, java.lang.String tag, ThanosSpec thanos, List<Toleration> tolerations, java.lang.String version, List<VolumeMount> volumeMounts, List<Volume> volumes, Boolean walCompression) {
        this.additionalAlertManagerConfigs = additionalAlertManagerConfigs;
        this.additionalAlertRelabelConfigs = additionalAlertRelabelConfigs;
        this.additionalScrapeConfigs = additionalScrapeConfigs;
        this.affinity = affinity;
        this.alerting = alerting;
        this.allowOverlappingBlocks = allowOverlappingBlocks;
        this.apiserverConfig = apiserverConfig;
        this.arbitraryFSAccessThroughSMs = arbitraryFSAccessThroughSMs;
        this.baseImage = baseImage;
        this.configMaps = configMaps;
        this.containers = containers;
        this.disableCompaction = disableCompaction;
        this.enableAdminAPI = enableAdminAPI;
        this.enforcedNamespaceLabel = enforcedNamespaceLabel;
        this.enforcedSampleLimit = enforcedSampleLimit;
        this.evaluationInterval = evaluationInterval;
        this.externalLabels = externalLabels;
        this.externalUrl = externalUrl;
        this.ignoreNamespaceSelectors = ignoreNamespaceSelectors;
        this.image = image;
        this.imagePullSecrets = imagePullSecrets;
        this.initContainers = initContainers;
        this.listenLocal = listenLocal;
        this.logFormat = logFormat;
        this.logLevel = logLevel;
        this.nodeSelector = nodeSelector;
        this.overrideHonorLabels = overrideHonorLabels;
        this.overrideHonorTimestamps = overrideHonorTimestamps;
        this.paused = paused;
        this.podMetadata = podMetadata;
        this.podMonitorNamespaceSelector = podMonitorNamespaceSelector;
        this.podMonitorSelector = podMonitorSelector;
        this.portName = portName;
        this.priorityClassName = priorityClassName;
        this.probeNamespaceSelector = probeNamespaceSelector;
        this.probeSelector = probeSelector;
        this.prometheusExternalLabelName = prometheusExternalLabelName;
        this.prometheusRulesExcludedFromEnforce = prometheusRulesExcludedFromEnforce;
        this.query = query;
        this.queryLogFile = queryLogFile;
        this.remoteRead = remoteRead;
        this.remoteWrite = remoteWrite;
        this.replicaExternalLabelName = replicaExternalLabelName;
        this.replicas = replicas;
        this.resources = resources;
        this.retention = retention;
        this.retentionSize = retentionSize;
        this.routePrefix = routePrefix;
        this.ruleNamespaceSelector = ruleNamespaceSelector;
        this.ruleSelector = ruleSelector;
        this.rules = rules;
        this.scrapeInterval = scrapeInterval;
        this.scrapeTimeout = scrapeTimeout;
        this.secrets = secrets;
        this.securityContext = securityContext;
        this.serviceAccountName = serviceAccountName;
        this.serviceMonitorNamespaceSelector = serviceMonitorNamespaceSelector;
        this.serviceMonitorSelector = serviceMonitorSelector;
        this.sha = sha;
        this.storage = storage;
        this.tag = tag;
        this.thanos = thanos;
        this.tolerations = tolerations;
        this.version = version;
        this.volumeMounts = volumeMounts;
        this.volumes = volumes;
        this.walCompression = walCompression;
    }

    /**
     * 
     * 
     * @return
     *     The additionalAlertManagerConfigs
     */
    @JsonProperty("additionalAlertManagerConfigs")
    public SecretKeySelector getAdditionalAlertManagerConfigs() {
        return additionalAlertManagerConfigs;
    }

    /**
     * 
     * 
     * @param additionalAlertManagerConfigs
     *     The additionalAlertManagerConfigs
     */
    @JsonProperty("additionalAlertManagerConfigs")
    public void setAdditionalAlertManagerConfigs(SecretKeySelector additionalAlertManagerConfigs) {
        this.additionalAlertManagerConfigs = additionalAlertManagerConfigs;
    }

    /**
     * 
     * 
     * @return
     *     The additionalAlertRelabelConfigs
     */
    @JsonProperty("additionalAlertRelabelConfigs")
    public SecretKeySelector getAdditionalAlertRelabelConfigs() {
        return additionalAlertRelabelConfigs;
    }

    /**
     * 
     * 
     * @param additionalAlertRelabelConfigs
     *     The additionalAlertRelabelConfigs
     */
    @JsonProperty("additionalAlertRelabelConfigs")
    public void setAdditionalAlertRelabelConfigs(SecretKeySelector additionalAlertRelabelConfigs) {
        this.additionalAlertRelabelConfigs = additionalAlertRelabelConfigs;
    }

    /**
     * 
     * 
     * @return
     *     The additionalScrapeConfigs
     */
    @JsonProperty("additionalScrapeConfigs")
    public SecretKeySelector getAdditionalScrapeConfigs() {
        return additionalScrapeConfigs;
    }

    /**
     * 
     * 
     * @param additionalScrapeConfigs
     *     The additionalScrapeConfigs
     */
    @JsonProperty("additionalScrapeConfigs")
    public void setAdditionalScrapeConfigs(SecretKeySelector additionalScrapeConfigs) {
        this.additionalScrapeConfigs = additionalScrapeConfigs;
    }

    /**
     * 
     * 
     * @return
     *     The affinity
     */
    @JsonProperty("affinity")
    public Affinity getAffinity() {
        return affinity;
    }

    /**
     * 
     * 
     * @param affinity
     *     The affinity
     */
    @JsonProperty("affinity")
    public void setAffinity(Affinity affinity) {
        this.affinity = affinity;
    }

    /**
     * 
     * 
     * @return
     *     The alerting
     */
    @JsonProperty("alerting")
    public AlertingSpec getAlerting() {
        return alerting;
    }

    /**
     * 
     * 
     * @param alerting
     *     The alerting
     */
    @JsonProperty("alerting")
    public void setAlerting(AlertingSpec alerting) {
        this.alerting = alerting;
    }

    /**
     * 
     * 
     * @return
     *     The allowOverlappingBlocks
     */
    @JsonProperty("allowOverlappingBlocks")
    public Boolean getAllowOverlappingBlocks() {
        return allowOverlappingBlocks;
    }

    /**
     * 
     * 
     * @param allowOverlappingBlocks
     *     The allowOverlappingBlocks
     */
    @JsonProperty("allowOverlappingBlocks")
    public void setAllowOverlappingBlocks(Boolean allowOverlappingBlocks) {
        this.allowOverlappingBlocks = allowOverlappingBlocks;
    }

    /**
     * 
     * 
     * @return
     *     The apiserverConfig
     */
    @JsonProperty("apiserverConfig")
    public APIServerConfig getApiserverConfig() {
        return apiserverConfig;
    }

    /**
     * 
     * 
     * @param apiserverConfig
     *     The apiserverConfig
     */
    @JsonProperty("apiserverConfig")
    public void setApiserverConfig(APIServerConfig apiserverConfig) {
        this.apiserverConfig = apiserverConfig;
    }

    /**
     * 
     * 
     * @return
     *     The arbitraryFSAccessThroughSMs
     */
    @JsonProperty("arbitraryFSAccessThroughSMs")
    public ArbitraryFSAccessThroughSMsConfig getArbitraryFSAccessThroughSMs() {
        return arbitraryFSAccessThroughSMs;
    }

    /**
     * 
     * 
     * @param arbitraryFSAccessThroughSMs
     *     The arbitraryFSAccessThroughSMs
     */
    @JsonProperty("arbitraryFSAccessThroughSMs")
    public void setArbitraryFSAccessThroughSMs(ArbitraryFSAccessThroughSMsConfig arbitraryFSAccessThroughSMs) {
        this.arbitraryFSAccessThroughSMs = arbitraryFSAccessThroughSMs;
    }

    /**
     * 
     * 
     * @return
     *     The baseImage
     */
    @JsonProperty("baseImage")
    public java.lang.String getBaseImage() {
        return baseImage;
    }

    /**
     * 
     * 
     * @param baseImage
     *     The baseImage
     */
    @JsonProperty("baseImage")
    public void setBaseImage(java.lang.String baseImage) {
        this.baseImage = baseImage;
    }

    /**
     * 
     * 
     * @return
     *     The configMaps
     */
    @JsonProperty("configMaps")
    public List<java.lang.String> getConfigMaps() {
        return configMaps;
    }

    /**
     * 
     * 
     * @param configMaps
     *     The configMaps
     */
    @JsonProperty("configMaps")
    public void setConfigMaps(List<java.lang.String> configMaps) {
        this.configMaps = configMaps;
    }

    /**
     * 
     * 
     * @return
     *     The containers
     */
    @JsonProperty("containers")
    public List<io.fabric8.kubernetes.api.model.Container> getContainers() {
        return containers;
    }

    /**
     * 
     * 
     * @param containers
     *     The containers
     */
    @JsonProperty("containers")
    public void setContainers(List<io.fabric8.kubernetes.api.model.Container> containers) {
        this.containers = containers;
    }

    /**
     * 
     * 
     * @return
     *     The disableCompaction
     */
    @JsonProperty("disableCompaction")
    public Boolean getDisableCompaction() {
        return disableCompaction;
    }

    /**
     * 
     * 
     * @param disableCompaction
     *     The disableCompaction
     */
    @JsonProperty("disableCompaction")
    public void setDisableCompaction(Boolean disableCompaction) {
        this.disableCompaction = disableCompaction;
    }

    /**
     * 
     * 
     * @return
     *     The enableAdminAPI
     */
    @JsonProperty("enableAdminAPI")
    public Boolean getEnableAdminAPI() {
        return enableAdminAPI;
    }

    /**
     * 
     * 
     * @param enableAdminAPI
     *     The enableAdminAPI
     */
    @JsonProperty("enableAdminAPI")
    public void setEnableAdminAPI(Boolean enableAdminAPI) {
        this.enableAdminAPI = enableAdminAPI;
    }

    /**
     * 
     * 
     * @return
     *     The enforcedNamespaceLabel
     */
    @JsonProperty("enforcedNamespaceLabel")
    public java.lang.String getEnforcedNamespaceLabel() {
        return enforcedNamespaceLabel;
    }

    /**
     * 
     * 
     * @param enforcedNamespaceLabel
     *     The enforcedNamespaceLabel
     */
    @JsonProperty("enforcedNamespaceLabel")
    public void setEnforcedNamespaceLabel(java.lang.String enforcedNamespaceLabel) {
        this.enforcedNamespaceLabel = enforcedNamespaceLabel;
    }

    /**
     * 
     * 
     * @return
     *     The enforcedSampleLimit
     */
    @JsonProperty("enforcedSampleLimit")
    public Long getEnforcedSampleLimit() {
        return enforcedSampleLimit;
    }

    /**
     * 
     * 
     * @param enforcedSampleLimit
     *     The enforcedSampleLimit
     */
    @JsonProperty("enforcedSampleLimit")
    public void setEnforcedSampleLimit(Long enforcedSampleLimit) {
        this.enforcedSampleLimit = enforcedSampleLimit;
    }

    /**
     * 
     * 
     * @return
     *     The evaluationInterval
     */
    @JsonProperty("evaluationInterval")
    public java.lang.String getEvaluationInterval() {
        return evaluationInterval;
    }

    /**
     * 
     * 
     * @param evaluationInterval
     *     The evaluationInterval
     */
    @JsonProperty("evaluationInterval")
    public void setEvaluationInterval(java.lang.String evaluationInterval) {
        this.evaluationInterval = evaluationInterval;
    }

    /**
     * 
     * 
     * @return
     *     The externalLabels
     */
    @JsonProperty("externalLabels")
    public Map<String, String> getExternalLabels() {
        return externalLabels;
    }

    /**
     * 
     * 
     * @param externalLabels
     *     The externalLabels
     */
    @JsonProperty("externalLabels")
    public void setExternalLabels(Map<String, String> externalLabels) {
        this.externalLabels = externalLabels;
    }

    /**
     * 
     * 
     * @return
     *     The externalUrl
     */
    @JsonProperty("externalUrl")
    public java.lang.String getExternalUrl() {
        return externalUrl;
    }

    /**
     * 
     * 
     * @param externalUrl
     *     The externalUrl
     */
    @JsonProperty("externalUrl")
    public void setExternalUrl(java.lang.String externalUrl) {
        this.externalUrl = externalUrl;
    }

    /**
     * 
     * 
     * @return
     *     The ignoreNamespaceSelectors
     */
    @JsonProperty("ignoreNamespaceSelectors")
    public Boolean getIgnoreNamespaceSelectors() {
        return ignoreNamespaceSelectors;
    }

    /**
     * 
     * 
     * @param ignoreNamespaceSelectors
     *     The ignoreNamespaceSelectors
     */
    @JsonProperty("ignoreNamespaceSelectors")
    public void setIgnoreNamespaceSelectors(Boolean ignoreNamespaceSelectors) {
        this.ignoreNamespaceSelectors = ignoreNamespaceSelectors;
    }

    /**
     * 
     * 
     * @return
     *     The image
     */
    @JsonProperty("image")
    public java.lang.String getImage() {
        return image;
    }

    /**
     * 
     * 
     * @param image
     *     The image
     */
    @JsonProperty("image")
    public void setImage(java.lang.String image) {
        this.image = image;
    }

    /**
     * 
     * 
     * @return
     *     The imagePullSecrets
     */
    @JsonProperty("imagePullSecrets")
    public List<io.fabric8.kubernetes.api.model.LocalObjectReference> getImagePullSecrets() {
        return imagePullSecrets;
    }

    /**
     * 
     * 
     * @param imagePullSecrets
     *     The imagePullSecrets
     */
    @JsonProperty("imagePullSecrets")
    public void setImagePullSecrets(List<io.fabric8.kubernetes.api.model.LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    /**
     * 
     * 
     * @return
     *     The initContainers
     */
    @JsonProperty("initContainers")
    public List<io.fabric8.kubernetes.api.model.Container> getInitContainers() {
        return initContainers;
    }

    /**
     * 
     * 
     * @param initContainers
     *     The initContainers
     */
    @JsonProperty("initContainers")
    public void setInitContainers(List<io.fabric8.kubernetes.api.model.Container> initContainers) {
        this.initContainers = initContainers;
    }

    /**
     * 
     * 
     * @return
     *     The listenLocal
     */
    @JsonProperty("listenLocal")
    public Boolean getListenLocal() {
        return listenLocal;
    }

    /**
     * 
     * 
     * @param listenLocal
     *     The listenLocal
     */
    @JsonProperty("listenLocal")
    public void setListenLocal(Boolean listenLocal) {
        this.listenLocal = listenLocal;
    }

    /**
     * 
     * 
     * @return
     *     The logFormat
     */
    @JsonProperty("logFormat")
    public java.lang.String getLogFormat() {
        return logFormat;
    }

    /**
     * 
     * 
     * @param logFormat
     *     The logFormat
     */
    @JsonProperty("logFormat")
    public void setLogFormat(java.lang.String logFormat) {
        this.logFormat = logFormat;
    }

    /**
     * 
     * 
     * @return
     *     The logLevel
     */
    @JsonProperty("logLevel")
    public java.lang.String getLogLevel() {
        return logLevel;
    }

    /**
     * 
     * 
     * @param logLevel
     *     The logLevel
     */
    @JsonProperty("logLevel")
    public void setLogLevel(java.lang.String logLevel) {
        this.logLevel = logLevel;
    }

    /**
     * 
     * 
     * @return
     *     The nodeSelector
     */
    @JsonProperty("nodeSelector")
    public Map<String, String> getNodeSelector() {
        return nodeSelector;
    }

    /**
     * 
     * 
     * @param nodeSelector
     *     The nodeSelector
     */
    @JsonProperty("nodeSelector")
    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    /**
     * 
     * 
     * @return
     *     The overrideHonorLabels
     */
    @JsonProperty("overrideHonorLabels")
    public Boolean getOverrideHonorLabels() {
        return overrideHonorLabels;
    }

    /**
     * 
     * 
     * @param overrideHonorLabels
     *     The overrideHonorLabels
     */
    @JsonProperty("overrideHonorLabels")
    public void setOverrideHonorLabels(Boolean overrideHonorLabels) {
        this.overrideHonorLabels = overrideHonorLabels;
    }

    /**
     * 
     * 
     * @return
     *     The overrideHonorTimestamps
     */
    @JsonProperty("overrideHonorTimestamps")
    public Boolean getOverrideHonorTimestamps() {
        return overrideHonorTimestamps;
    }

    /**
     * 
     * 
     * @param overrideHonorTimestamps
     *     The overrideHonorTimestamps
     */
    @JsonProperty("overrideHonorTimestamps")
    public void setOverrideHonorTimestamps(Boolean overrideHonorTimestamps) {
        this.overrideHonorTimestamps = overrideHonorTimestamps;
    }

    /**
     * 
     * 
     * @return
     *     The paused
     */
    @JsonProperty("paused")
    public Boolean getPaused() {
        return paused;
    }

    /**
     * 
     * 
     * @param paused
     *     The paused
     */
    @JsonProperty("paused")
    public void setPaused(Boolean paused) {
        this.paused = paused;
    }

    /**
     * 
     * 
     * @return
     *     The podMetadata
     */
    @JsonProperty("podMetadata")
    public EmbeddedObjectMetadata getPodMetadata() {
        return podMetadata;
    }

    /**
     * 
     * 
     * @param podMetadata
     *     The podMetadata
     */
    @JsonProperty("podMetadata")
    public void setPodMetadata(EmbeddedObjectMetadata podMetadata) {
        this.podMetadata = podMetadata;
    }

    /**
     * 
     * 
     * @return
     *     The podMonitorNamespaceSelector
     */
    @JsonProperty("podMonitorNamespaceSelector")
    public io.fabric8.kubernetes.api.model.LabelSelector getPodMonitorNamespaceSelector() {
        return podMonitorNamespaceSelector;
    }

    /**
     * 
     * 
     * @param podMonitorNamespaceSelector
     *     The podMonitorNamespaceSelector
     */
    @JsonProperty("podMonitorNamespaceSelector")
    public void setPodMonitorNamespaceSelector(io.fabric8.kubernetes.api.model.LabelSelector podMonitorNamespaceSelector) {
        this.podMonitorNamespaceSelector = podMonitorNamespaceSelector;
    }

    /**
     * 
     * 
     * @return
     *     The podMonitorSelector
     */
    @JsonProperty("podMonitorSelector")
    public io.fabric8.kubernetes.api.model.LabelSelector getPodMonitorSelector() {
        return podMonitorSelector;
    }

    /**
     * 
     * 
     * @param podMonitorSelector
     *     The podMonitorSelector
     */
    @JsonProperty("podMonitorSelector")
    public void setPodMonitorSelector(io.fabric8.kubernetes.api.model.LabelSelector podMonitorSelector) {
        this.podMonitorSelector = podMonitorSelector;
    }

    /**
     * 
     * 
     * @return
     *     The portName
     */
    @JsonProperty("portName")
    public java.lang.String getPortName() {
        return portName;
    }

    /**
     * 
     * 
     * @param portName
     *     The portName
     */
    @JsonProperty("portName")
    public void setPortName(java.lang.String portName) {
        this.portName = portName;
    }

    /**
     * 
     * 
     * @return
     *     The priorityClassName
     */
    @JsonProperty("priorityClassName")
    public java.lang.String getPriorityClassName() {
        return priorityClassName;
    }

    /**
     * 
     * 
     * @param priorityClassName
     *     The priorityClassName
     */
    @JsonProperty("priorityClassName")
    public void setPriorityClassName(java.lang.String priorityClassName) {
        this.priorityClassName = priorityClassName;
    }

    /**
     * 
     * 
     * @return
     *     The probeNamespaceSelector
     */
    @JsonProperty("probeNamespaceSelector")
    public io.fabric8.kubernetes.api.model.LabelSelector getProbeNamespaceSelector() {
        return probeNamespaceSelector;
    }

    /**
     * 
     * 
     * @param probeNamespaceSelector
     *     The probeNamespaceSelector
     */
    @JsonProperty("probeNamespaceSelector")
    public void setProbeNamespaceSelector(io.fabric8.kubernetes.api.model.LabelSelector probeNamespaceSelector) {
        this.probeNamespaceSelector = probeNamespaceSelector;
    }

    /**
     * 
     * 
     * @return
     *     The probeSelector
     */
    @JsonProperty("probeSelector")
    public io.fabric8.kubernetes.api.model.LabelSelector getProbeSelector() {
        return probeSelector;
    }

    /**
     * 
     * 
     * @param probeSelector
     *     The probeSelector
     */
    @JsonProperty("probeSelector")
    public void setProbeSelector(io.fabric8.kubernetes.api.model.LabelSelector probeSelector) {
        this.probeSelector = probeSelector;
    }

    /**
     * 
     * 
     * @return
     *     The prometheusExternalLabelName
     */
    @JsonProperty("prometheusExternalLabelName")
    public java.lang.String getPrometheusExternalLabelName() {
        return prometheusExternalLabelName;
    }

    /**
     * 
     * 
     * @param prometheusExternalLabelName
     *     The prometheusExternalLabelName
     */
    @JsonProperty("prometheusExternalLabelName")
    public void setPrometheusExternalLabelName(java.lang.String prometheusExternalLabelName) {
        this.prometheusExternalLabelName = prometheusExternalLabelName;
    }

    /**
     * 
     * 
     * @return
     *     The prometheusRulesExcludedFromEnforce
     */
    @JsonProperty("prometheusRulesExcludedFromEnforce")
    public List<PrometheusRuleExcludeConfig> getPrometheusRulesExcludedFromEnforce() {
        return prometheusRulesExcludedFromEnforce;
    }

    /**
     * 
     * 
     * @param prometheusRulesExcludedFromEnforce
     *     The prometheusRulesExcludedFromEnforce
     */
    @JsonProperty("prometheusRulesExcludedFromEnforce")
    public void setPrometheusRulesExcludedFromEnforce(List<PrometheusRuleExcludeConfig> prometheusRulesExcludedFromEnforce) {
        this.prometheusRulesExcludedFromEnforce = prometheusRulesExcludedFromEnforce;
    }

    /**
     * 
     * 
     * @return
     *     The query
     */
    @JsonProperty("query")
    public QuerySpec getQuery() {
        return query;
    }

    /**
     * 
     * 
     * @param query
     *     The query
     */
    @JsonProperty("query")
    public void setQuery(QuerySpec query) {
        this.query = query;
    }

    /**
     * 
     * 
     * @return
     *     The queryLogFile
     */
    @JsonProperty("queryLogFile")
    public java.lang.String getQueryLogFile() {
        return queryLogFile;
    }

    /**
     * 
     * 
     * @param queryLogFile
     *     The queryLogFile
     */
    @JsonProperty("queryLogFile")
    public void setQueryLogFile(java.lang.String queryLogFile) {
        this.queryLogFile = queryLogFile;
    }

    /**
     * 
     * 
     * @return
     *     The remoteRead
     */
    @JsonProperty("remoteRead")
    public List<RemoteReadSpec> getRemoteRead() {
        return remoteRead;
    }

    /**
     * 
     * 
     * @param remoteRead
     *     The remoteRead
     */
    @JsonProperty("remoteRead")
    public void setRemoteRead(List<RemoteReadSpec> remoteRead) {
        this.remoteRead = remoteRead;
    }

    /**
     * 
     * 
     * @return
     *     The remoteWrite
     */
    @JsonProperty("remoteWrite")
    public List<RemoteWriteSpec> getRemoteWrite() {
        return remoteWrite;
    }

    /**
     * 
     * 
     * @param remoteWrite
     *     The remoteWrite
     */
    @JsonProperty("remoteWrite")
    public void setRemoteWrite(List<RemoteWriteSpec> remoteWrite) {
        this.remoteWrite = remoteWrite;
    }

    /**
     * 
     * 
     * @return
     *     The replicaExternalLabelName
     */
    @JsonProperty("replicaExternalLabelName")
    public java.lang.String getReplicaExternalLabelName() {
        return replicaExternalLabelName;
    }

    /**
     * 
     * 
     * @param replicaExternalLabelName
     *     The replicaExternalLabelName
     */
    @JsonProperty("replicaExternalLabelName")
    public void setReplicaExternalLabelName(java.lang.String replicaExternalLabelName) {
        this.replicaExternalLabelName = replicaExternalLabelName;
    }

    /**
     * 
     * 
     * @return
     *     The replicas
     */
    @JsonProperty("replicas")
    public Integer getReplicas() {
        return replicas;
    }

    /**
     * 
     * 
     * @param replicas
     *     The replicas
     */
    @JsonProperty("replicas")
    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    /**
     * 
     * 
     * @return
     *     The resources
     */
    @JsonProperty("resources")
    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
        return resources;
    }

    /**
     * 
     * 
     * @param resources
     *     The resources
     */
    @JsonProperty("resources")
    public void setResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
        this.resources = resources;
    }

    /**
     * 
     * 
     * @return
     *     The retention
     */
    @JsonProperty("retention")
    public java.lang.String getRetention() {
        return retention;
    }

    /**
     * 
     * 
     * @param retention
     *     The retention
     */
    @JsonProperty("retention")
    public void setRetention(java.lang.String retention) {
        this.retention = retention;
    }

    /**
     * 
     * 
     * @return
     *     The retentionSize
     */
    @JsonProperty("retentionSize")
    public java.lang.String getRetentionSize() {
        return retentionSize;
    }

    /**
     * 
     * 
     * @param retentionSize
     *     The retentionSize
     */
    @JsonProperty("retentionSize")
    public void setRetentionSize(java.lang.String retentionSize) {
        this.retentionSize = retentionSize;
    }

    /**
     * 
     * 
     * @return
     *     The routePrefix
     */
    @JsonProperty("routePrefix")
    public java.lang.String getRoutePrefix() {
        return routePrefix;
    }

    /**
     * 
     * 
     * @param routePrefix
     *     The routePrefix
     */
    @JsonProperty("routePrefix")
    public void setRoutePrefix(java.lang.String routePrefix) {
        this.routePrefix = routePrefix;
    }

    /**
     * 
     * 
     * @return
     *     The ruleNamespaceSelector
     */
    @JsonProperty("ruleNamespaceSelector")
    public io.fabric8.kubernetes.api.model.LabelSelector getRuleNamespaceSelector() {
        return ruleNamespaceSelector;
    }

    /**
     * 
     * 
     * @param ruleNamespaceSelector
     *     The ruleNamespaceSelector
     */
    @JsonProperty("ruleNamespaceSelector")
    public void setRuleNamespaceSelector(io.fabric8.kubernetes.api.model.LabelSelector ruleNamespaceSelector) {
        this.ruleNamespaceSelector = ruleNamespaceSelector;
    }

    /**
     * 
     * 
     * @return
     *     The ruleSelector
     */
    @JsonProperty("ruleSelector")
    public io.fabric8.kubernetes.api.model.LabelSelector getRuleSelector() {
        return ruleSelector;
    }

    /**
     * 
     * 
     * @param ruleSelector
     *     The ruleSelector
     */
    @JsonProperty("ruleSelector")
    public void setRuleSelector(io.fabric8.kubernetes.api.model.LabelSelector ruleSelector) {
        this.ruleSelector = ruleSelector;
    }

    /**
     * 
     * 
     * @return
     *     The rules
     */
    @JsonProperty("rules")
    public Rules getRules() {
        return rules;
    }

    /**
     * 
     * 
     * @param rules
     *     The rules
     */
    @JsonProperty("rules")
    public void setRules(Rules rules) {
        this.rules = rules;
    }

    /**
     * 
     * 
     * @return
     *     The scrapeInterval
     */
    @JsonProperty("scrapeInterval")
    public java.lang.String getScrapeInterval() {
        return scrapeInterval;
    }

    /**
     * 
     * 
     * @param scrapeInterval
     *     The scrapeInterval
     */
    @JsonProperty("scrapeInterval")
    public void setScrapeInterval(java.lang.String scrapeInterval) {
        this.scrapeInterval = scrapeInterval;
    }

    /**
     * 
     * 
     * @return
     *     The scrapeTimeout
     */
    @JsonProperty("scrapeTimeout")
    public java.lang.String getScrapeTimeout() {
        return scrapeTimeout;
    }

    /**
     * 
     * 
     * @param scrapeTimeout
     *     The scrapeTimeout
     */
    @JsonProperty("scrapeTimeout")
    public void setScrapeTimeout(java.lang.String scrapeTimeout) {
        this.scrapeTimeout = scrapeTimeout;
    }

    /**
     * 
     * 
     * @return
     *     The secrets
     */
    @JsonProperty("secrets")
    public List<java.lang.String> getSecrets() {
        return secrets;
    }

    /**
     * 
     * 
     * @param secrets
     *     The secrets
     */
    @JsonProperty("secrets")
    public void setSecrets(List<java.lang.String> secrets) {
        this.secrets = secrets;
    }

    /**
     * 
     * 
     * @return
     *     The securityContext
     */
    @JsonProperty("securityContext")
    public PodSecurityContext getSecurityContext() {
        return securityContext;
    }

    /**
     * 
     * 
     * @param securityContext
     *     The securityContext
     */
    @JsonProperty("securityContext")
    public void setSecurityContext(PodSecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    /**
     * 
     * 
     * @return
     *     The serviceAccountName
     */
    @JsonProperty("serviceAccountName")
    public java.lang.String getServiceAccountName() {
        return serviceAccountName;
    }

    /**
     * 
     * 
     * @param serviceAccountName
     *     The serviceAccountName
     */
    @JsonProperty("serviceAccountName")
    public void setServiceAccountName(java.lang.String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    /**
     * 
     * 
     * @return
     *     The serviceMonitorNamespaceSelector
     */
    @JsonProperty("serviceMonitorNamespaceSelector")
    public io.fabric8.kubernetes.api.model.LabelSelector getServiceMonitorNamespaceSelector() {
        return serviceMonitorNamespaceSelector;
    }

    /**
     * 
     * 
     * @param serviceMonitorNamespaceSelector
     *     The serviceMonitorNamespaceSelector
     */
    @JsonProperty("serviceMonitorNamespaceSelector")
    public void setServiceMonitorNamespaceSelector(io.fabric8.kubernetes.api.model.LabelSelector serviceMonitorNamespaceSelector) {
        this.serviceMonitorNamespaceSelector = serviceMonitorNamespaceSelector;
    }

    /**
     * 
     * 
     * @return
     *     The serviceMonitorSelector
     */
    @JsonProperty("serviceMonitorSelector")
    public io.fabric8.kubernetes.api.model.LabelSelector getServiceMonitorSelector() {
        return serviceMonitorSelector;
    }

    /**
     * 
     * 
     * @param serviceMonitorSelector
     *     The serviceMonitorSelector
     */
    @JsonProperty("serviceMonitorSelector")
    public void setServiceMonitorSelector(io.fabric8.kubernetes.api.model.LabelSelector serviceMonitorSelector) {
        this.serviceMonitorSelector = serviceMonitorSelector;
    }

    /**
     * 
     * 
     * @return
     *     The sha
     */
    @JsonProperty("sha")
    public java.lang.String getSha() {
        return sha;
    }

    /**
     * 
     * 
     * @param sha
     *     The sha
     */
    @JsonProperty("sha")
    public void setSha(java.lang.String sha) {
        this.sha = sha;
    }

    /**
     * 
     * 
     * @return
     *     The storage
     */
    @JsonProperty("storage")
    public StorageSpec getStorage() {
        return storage;
    }

    /**
     * 
     * 
     * @param storage
     *     The storage
     */
    @JsonProperty("storage")
    public void setStorage(StorageSpec storage) {
        this.storage = storage;
    }

    /**
     * 
     * 
     * @return
     *     The tag
     */
    @JsonProperty("tag")
    public java.lang.String getTag() {
        return tag;
    }

    /**
     * 
     * 
     * @param tag
     *     The tag
     */
    @JsonProperty("tag")
    public void setTag(java.lang.String tag) {
        this.tag = tag;
    }

    /**
     * 
     * 
     * @return
     *     The thanos
     */
    @JsonProperty("thanos")
    public ThanosSpec getThanos() {
        return thanos;
    }

    /**
     * 
     * 
     * @param thanos
     *     The thanos
     */
    @JsonProperty("thanos")
    public void setThanos(ThanosSpec thanos) {
        this.thanos = thanos;
    }

    /**
     * 
     * 
     * @return
     *     The tolerations
     */
    @JsonProperty("tolerations")
    public List<Toleration> getTolerations() {
        return tolerations;
    }

    /**
     * 
     * 
     * @param tolerations
     *     The tolerations
     */
    @JsonProperty("tolerations")
    public void setTolerations(List<Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    /**
     * 
     * 
     * @return
     *     The version
     */
    @JsonProperty("version")
    public java.lang.String getVersion() {
        return version;
    }

    /**
     * 
     * 
     * @param version
     *     The version
     */
    @JsonProperty("version")
    public void setVersion(java.lang.String version) {
        this.version = version;
    }

    /**
     * 
     * 
     * @return
     *     The volumeMounts
     */
    @JsonProperty("volumeMounts")
    public List<VolumeMount> getVolumeMounts() {
        return volumeMounts;
    }

    /**
     * 
     * 
     * @param volumeMounts
     *     The volumeMounts
     */
    @JsonProperty("volumeMounts")
    public void setVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    /**
     * 
     * 
     * @return
     *     The volumes
     */
    @JsonProperty("volumes")
    public List<Volume> getVolumes() {
        return volumes;
    }

    /**
     * 
     * 
     * @param volumes
     *     The volumes
     */
    @JsonProperty("volumes")
    public void setVolumes(List<Volume> volumes) {
        this.volumes = volumes;
    }

    /**
     * 
     * 
     * @return
     *     The walCompression
     */
    @JsonProperty("walCompression")
    public Boolean getWalCompression() {
        return walCompression;
    }

    /**
     * 
     * 
     * @param walCompression
     *     The walCompression
     */
    @JsonProperty("walCompression")
    public void setWalCompression(Boolean walCompression) {
        this.walCompression = walCompression;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
