package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus;
import java.lang.Object;
import java.lang.Boolean;

public class EmbeddedPersistentVolumeClaimFluentImpl<A extends EmbeddedPersistentVolumeClaimFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EmbeddedPersistentVolumeClaimFluent<A> {

    private String apiVersion;
    private String kind;
    private EmbeddedObjectMetadataBuilder metadata;
    private PersistentVolumeClaimSpec spec;
    private PersistentVolumeClaimStatus status;

    public EmbeddedPersistentVolumeClaimFluentImpl() { 
    }


    public EmbeddedPersistentVolumeClaimFluentImpl(EmbeddedPersistentVolumeClaim instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public EmbeddedObjectMetadata getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public EmbeddedObjectMetadata buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(EmbeddedObjectMetadata metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new EmbeddedObjectMetadataBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public EmbeddedPersistentVolumeClaimFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public EmbeddedPersistentVolumeClaimFluent.MetadataNested<A> withNewMetadataLike(EmbeddedObjectMetadata item) {
        return new MetadataNestedImpl(item);
    }

    public EmbeddedPersistentVolumeClaimFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public EmbeddedPersistentVolumeClaimFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new EmbeddedObjectMetadataBuilder().build());
    }

    public EmbeddedPersistentVolumeClaimFluent.MetadataNested<A> editOrNewMetadataLike(EmbeddedObjectMetadata item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public PersistentVolumeClaimSpec getSpec() {
        return this.spec;
    }

    public A withSpec(PersistentVolumeClaimSpec spec) {
        this.spec=spec; return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public PersistentVolumeClaimStatus getStatus() {
        return this.status;
    }

    public A withStatus(PersistentVolumeClaimStatus status) {
        this.status=status; return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EmbeddedPersistentVolumeClaimFluentImpl that = (EmbeddedPersistentVolumeClaimFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends EmbeddedObjectMetadataFluentImpl<EmbeddedPersistentVolumeClaimFluent.MetadataNested<N>> implements EmbeddedPersistentVolumeClaimFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EmbeddedObjectMetadataBuilder builder;

        MetadataNestedImpl(EmbeddedObjectMetadata item) {
            this.builder = new EmbeddedObjectMetadataBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new EmbeddedObjectMetadataBuilder(this);
        }

        public N and() {
             return (N) EmbeddedPersistentVolumeClaimFluentImpl.this.withMetadata(builder.build());
        }

        public N endMetadata() {
             return and();
        }
    }


}
