package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.SecretKeySelector;

public class BasicAuthFluentImpl<A extends BasicAuthFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BasicAuthFluent<A> {

    private SecretKeySelector password;
    private SecretKeySelector username;

    public BasicAuthFluentImpl() { 
    }


    public BasicAuthFluentImpl(BasicAuth instance) { 
        this.withPassword(instance.getPassword()); 
        this.withUsername(instance.getUsername()); 
    }


    public SecretKeySelector getPassword() {
        return this.password;
    }

    public A withPassword(SecretKeySelector password) {
        this.password=password; return (A) this;
    }

    public Boolean hasPassword() {
        return this.password != null;
    }

    public A withNewPassword(String key,String name,Boolean optional) {
        return (A)withPassword(new SecretKeySelector(key, name, optional));
    }

    public SecretKeySelector getUsername() {
        return this.username;
    }

    public A withUsername(SecretKeySelector username) {
        this.username=username; return (A) this;
    }

    public Boolean hasUsername() {
        return this.username != null;
    }

    public A withNewUsername(String key,String name,Boolean optional) {
        return (A)withUsername(new SecretKeySelector(key, name, optional));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BasicAuthFluentImpl that = (BasicAuthFluentImpl) o;
        if (password != null ? !password.equals(that.password) :that.password != null) return false;
        if (username != null ? !username.equals(that.username) :that.username != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(password,  username,  super.hashCode());
    }

}
