package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AlertmanagerStatusBuilder extends AlertmanagerStatusFluentImpl<AlertmanagerStatusBuilder> implements VisitableBuilder<AlertmanagerStatus,AlertmanagerStatusBuilder> {

    AlertmanagerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public AlertmanagerStatusBuilder() { 
        this(true);
    }


    public AlertmanagerStatusBuilder(Boolean validationEnabled) { 
        this(new AlertmanagerStatus(), validationEnabled);
    }


    public AlertmanagerStatusBuilder(AlertmanagerStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public AlertmanagerStatusBuilder(AlertmanagerStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new AlertmanagerStatus(), validationEnabled);
    }


    public AlertmanagerStatusBuilder(AlertmanagerStatusFluent<?> fluent,AlertmanagerStatus instance) { 
        this(fluent, instance, true);
    }


    public AlertmanagerStatusBuilder(AlertmanagerStatusFluent<?> fluent,AlertmanagerStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
        fluent.withPaused(instance.getPaused()); 
        fluent.withReplicas(instance.getReplicas()); 
        fluent.withUnavailableReplicas(instance.getUnavailableReplicas()); 
        fluent.withUpdatedReplicas(instance.getUpdatedReplicas()); 
        this.validationEnabled = validationEnabled; 
    }


    public AlertmanagerStatusBuilder(AlertmanagerStatus instance) { 
        this(instance,true);
    }


    public AlertmanagerStatusBuilder(AlertmanagerStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAvailableReplicas(instance.getAvailableReplicas()); 
        this.withPaused(instance.getPaused()); 
        this.withReplicas(instance.getReplicas()); 
        this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
        this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
        this.validationEnabled = validationEnabled; 
    }


    public AlertmanagerStatus build() {
        AlertmanagerStatus buildable = new AlertmanagerStatus(fluent.getAvailableReplicas(),fluent.isPaused(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AlertmanagerStatusBuilder that = (AlertmanagerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
