package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodMonitorListBuilder extends PodMonitorListFluentImpl<PodMonitorListBuilder> implements VisitableBuilder<PodMonitorList,PodMonitorListBuilder> {

    PodMonitorListFluent<?> fluent;
    Boolean validationEnabled;

    public PodMonitorListBuilder() { 
        this(true);
    }


    public PodMonitorListBuilder(Boolean validationEnabled) { 
        this(new PodMonitorList(), validationEnabled);
    }


    public PodMonitorListBuilder(PodMonitorListFluent<?> fluent) { 
        this(fluent, true);
    }


    public PodMonitorListBuilder(PodMonitorListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new PodMonitorList(), validationEnabled);
    }


    public PodMonitorListBuilder(PodMonitorListFluent<?> fluent,PodMonitorList instance) { 
        this(fluent, instance, true);
    }


    public PodMonitorListBuilder(PodMonitorListFluent<?> fluent,PodMonitorList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public PodMonitorListBuilder(PodMonitorList instance) { 
        this(instance,true);
    }


    public PodMonitorListBuilder(PodMonitorList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public PodMonitorList build() {
        PodMonitorList buildable = new PodMonitorList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodMonitorListBuilder that = (PodMonitorListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
