package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AlertmanagerSpecBuilder extends AlertmanagerSpecFluentImpl<AlertmanagerSpecBuilder> implements VisitableBuilder<AlertmanagerSpec,AlertmanagerSpecBuilder> {

    AlertmanagerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public AlertmanagerSpecBuilder() { 
        this(true);
    }


    public AlertmanagerSpecBuilder(Boolean validationEnabled) { 
        this(new AlertmanagerSpec(), validationEnabled);
    }


    public AlertmanagerSpecBuilder(AlertmanagerSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public AlertmanagerSpecBuilder(AlertmanagerSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new AlertmanagerSpec(), validationEnabled);
    }


    public AlertmanagerSpecBuilder(AlertmanagerSpecFluent<?> fluent,AlertmanagerSpec instance) { 
        this(fluent, instance, true);
    }


    public AlertmanagerSpecBuilder(AlertmanagerSpecFluent<?> fluent,AlertmanagerSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAdditionalPeers(instance.getAdditionalPeers()); 
        fluent.withAffinity(instance.getAffinity()); 
        fluent.withBaseImage(instance.getBaseImage()); 
        fluent.withClusterAdvertiseAddress(instance.getClusterAdvertiseAddress()); 
        fluent.withConfigMaps(instance.getConfigMaps()); 
        fluent.withConfigSecret(instance.getConfigSecret()); 
        fluent.withContainers(instance.getContainers()); 
        fluent.withExternalUrl(instance.getExternalUrl()); 
        fluent.withImage(instance.getImage()); 
        fluent.withImagePullSecrets(instance.getImagePullSecrets()); 
        fluent.withInitContainers(instance.getInitContainers()); 
        fluent.withListenLocal(instance.getListenLocal()); 
        fluent.withLogFormat(instance.getLogFormat()); 
        fluent.withLogLevel(instance.getLogLevel()); 
        fluent.withNodeSelector(instance.getNodeSelector()); 
        fluent.withPaused(instance.getPaused()); 
        fluent.withPodMetadata(instance.getPodMetadata()); 
        fluent.withPortName(instance.getPortName()); 
        fluent.withPriorityClassName(instance.getPriorityClassName()); 
        fluent.withReplicas(instance.getReplicas()); 
        fluent.withResources(instance.getResources()); 
        fluent.withRetention(instance.getRetention()); 
        fluent.withRoutePrefix(instance.getRoutePrefix()); 
        fluent.withSecrets(instance.getSecrets()); 
        fluent.withSecurityContext(instance.getSecurityContext()); 
        fluent.withServiceAccountName(instance.getServiceAccountName()); 
        fluent.withSha(instance.getSha()); 
        fluent.withStorage(instance.getStorage()); 
        fluent.withTag(instance.getTag()); 
        fluent.withTolerations(instance.getTolerations()); 
        fluent.withVersion(instance.getVersion()); 
        fluent.withVolumeMounts(instance.getVolumeMounts()); 
        fluent.withVolumes(instance.getVolumes()); 
        this.validationEnabled = validationEnabled; 
    }


    public AlertmanagerSpecBuilder(AlertmanagerSpec instance) { 
        this(instance,true);
    }


    public AlertmanagerSpecBuilder(AlertmanagerSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAdditionalPeers(instance.getAdditionalPeers()); 
        this.withAffinity(instance.getAffinity()); 
        this.withBaseImage(instance.getBaseImage()); 
        this.withClusterAdvertiseAddress(instance.getClusterAdvertiseAddress()); 
        this.withConfigMaps(instance.getConfigMaps()); 
        this.withConfigSecret(instance.getConfigSecret()); 
        this.withContainers(instance.getContainers()); 
        this.withExternalUrl(instance.getExternalUrl()); 
        this.withImage(instance.getImage()); 
        this.withImagePullSecrets(instance.getImagePullSecrets()); 
        this.withInitContainers(instance.getInitContainers()); 
        this.withListenLocal(instance.getListenLocal()); 
        this.withLogFormat(instance.getLogFormat()); 
        this.withLogLevel(instance.getLogLevel()); 
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withPaused(instance.getPaused()); 
        this.withPodMetadata(instance.getPodMetadata()); 
        this.withPortName(instance.getPortName()); 
        this.withPriorityClassName(instance.getPriorityClassName()); 
        this.withReplicas(instance.getReplicas()); 
        this.withResources(instance.getResources()); 
        this.withRetention(instance.getRetention()); 
        this.withRoutePrefix(instance.getRoutePrefix()); 
        this.withSecrets(instance.getSecrets()); 
        this.withSecurityContext(instance.getSecurityContext()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSha(instance.getSha()); 
        this.withStorage(instance.getStorage()); 
        this.withTag(instance.getTag()); 
        this.withTolerations(instance.getTolerations()); 
        this.withVersion(instance.getVersion()); 
        this.withVolumeMounts(instance.getVolumeMounts()); 
        this.withVolumes(instance.getVolumes()); 
        this.validationEnabled = validationEnabled; 
    }


    public AlertmanagerSpec build() {
        AlertmanagerSpec buildable = new AlertmanagerSpec(fluent.getAdditionalPeers(),fluent.getAffinity(),fluent.getBaseImage(),fluent.getClusterAdvertiseAddress(),fluent.getConfigMaps(),fluent.getConfigSecret(),fluent.getContainers(),fluent.getExternalUrl(),fluent.getImage(),fluent.getImagePullSecrets(),fluent.getInitContainers(),fluent.isListenLocal(),fluent.getLogFormat(),fluent.getLogLevel(),fluent.getNodeSelector(),fluent.isPaused(),fluent.getPodMetadata(),fluent.getPortName(),fluent.getPriorityClassName(),fluent.getReplicas(),fluent.getResources(),fluent.getRetention(),fluent.getRoutePrefix(),fluent.getSecrets(),fluent.getSecurityContext(),fluent.getServiceAccountName(),fluent.getSha(),fluent.getStorage(),fluent.getTag(),fluent.getTolerations(),fluent.getVersion(),fluent.getVolumeMounts(),fluent.getVolumes());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AlertmanagerSpecBuilder that = (AlertmanagerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
