package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.util.List;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import com.fasterxml.jackson.core.JsonParser;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import java.util.Map;

public class PodMetricsEndpointFluentImpl<A extends PodMetricsEndpointFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodMetricsEndpointFluent<A> {

    private Boolean honorLabels;
    private Boolean honorTimestamps;
    private String interval;
    private List<RelabelConfigBuilder> metricRelabelings =  new ArrayList<RelabelConfigBuilder>();
    private Map<String,ArrayList<String>> params;
    private String path;
    private String port;
    private String proxyUrl;
    private List<RelabelConfigBuilder> relabelings =  new ArrayList<RelabelConfigBuilder>();
    private String scheme;
    private String scrapeTimeout;
    private IntOrStringBuilder targetPort;

    public PodMetricsEndpointFluentImpl() { 
    }


    public PodMetricsEndpointFluentImpl(PodMetricsEndpoint instance) { 
        this.withHonorLabels(instance.getHonorLabels()); 
        this.withHonorTimestamps(instance.getHonorTimestamps()); 
        this.withInterval(instance.getInterval()); 
        this.withMetricRelabelings(instance.getMetricRelabelings()); 
        this.withParams(instance.getParams()); 
        this.withPath(instance.getPath()); 
        this.withPort(instance.getPort()); 
        this.withProxyUrl(instance.getProxyUrl()); 
        this.withRelabelings(instance.getRelabelings()); 
        this.withScheme(instance.getScheme()); 
        this.withScrapeTimeout(instance.getScrapeTimeout()); 
        this.withTargetPort(instance.getTargetPort()); 
    }


    public Boolean isHonorLabels() {
        return this.honorLabels;
    }

    public A withHonorLabels(Boolean honorLabels) {
        this.honorLabels=honorLabels; return (A) this;
    }

    public Boolean hasHonorLabels() {
        return this.honorLabels != null;
    }

    public A withNewHonorLabels(String arg1) {
        return (A)withHonorLabels(new Boolean(arg1));
    }

    public A withNewHonorLabels(boolean arg1) {
        return (A)withHonorLabels(new Boolean(arg1));
    }

    public Boolean isHonorTimestamps() {
        return this.honorTimestamps;
    }

    public A withHonorTimestamps(Boolean honorTimestamps) {
        this.honorTimestamps=honorTimestamps; return (A) this;
    }

    public Boolean hasHonorTimestamps() {
        return this.honorTimestamps != null;
    }

    public A withNewHonorTimestamps(String arg1) {
        return (A)withHonorTimestamps(new Boolean(arg1));
    }

    public A withNewHonorTimestamps(boolean arg1) {
        return (A)withHonorTimestamps(new Boolean(arg1));
    }

    public String getInterval() {
        return this.interval;
    }

    public A withInterval(String interval) {
        this.interval=interval; return (A) this;
    }

    public Boolean hasInterval() {
        return this.interval != null;
    }

    public A withNewInterval(String arg1) {
        return (A)withInterval(new String(arg1));
    }

    public A withNewInterval(StringBuilder arg1) {
        return (A)withInterval(new String(arg1));
    }

    public A withNewInterval(StringBuffer arg1) {
        return (A)withInterval(new String(arg1));
    }

    public A addToMetricRelabelings(int index,RelabelConfig item) {
        if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(index >= 0 ? index : _visitables.get("metricRelabelings").size(), builder);this.metricRelabelings.add(index >= 0 ? index : metricRelabelings.size(), builder); return (A)this;
    }

    public A setToMetricRelabelings(int index,RelabelConfig item) {
        if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= _visitables.get("metricRelabelings").size()) { _visitables.get("metricRelabelings").add(builder); } else { _visitables.get("metricRelabelings").set(index, builder);}
        if (index < 0 || index >= metricRelabelings.size()) { metricRelabelings.add(builder); } else { metricRelabelings.set(index, builder);}
         return (A)this;
    }

    public A addToMetricRelabelings(RelabelConfig... items) {
        if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
        for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
    }

    public A addAllToMetricRelabelings(Collection<RelabelConfig> items) {
        if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
        for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
    }

    public A removeFromMetricRelabelings(RelabelConfig... items) {
        for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder);if (this.metricRelabelings != null) {this.metricRelabelings.remove(builder);}} return (A)this;
    }

    public A removeAllFromMetricRelabelings(Collection<RelabelConfig> items) {
        for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder);if (this.metricRelabelings != null) {this.metricRelabelings.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromMetricRelabelings(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate) {
        if (metricRelabelings == null) return (A) this;
        final Iterator<RelabelConfigBuilder> each = metricRelabelings.iterator();
        final List visitables = _visitables.get("metricRelabelings");
        while (each.hasNext()) {
          RelabelConfigBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMetricRelabelings instead.
 * @return The buildable object.
 */
@Deprecated public List<RelabelConfig> getMetricRelabelings() {
        return build(metricRelabelings);
    }

    public List<RelabelConfig> buildMetricRelabelings() {
        return build(metricRelabelings);
    }

    public RelabelConfig buildMetricRelabeling(int index) {
        return this.metricRelabelings.get(index).build();
    }

    public RelabelConfig buildFirstMetricRelabeling() {
        return this.metricRelabelings.get(0).build();
    }

    public RelabelConfig buildLastMetricRelabeling() {
        return this.metricRelabelings.get(metricRelabelings.size() - 1).build();
    }

    public RelabelConfig buildMatchingMetricRelabeling(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item: metricRelabelings) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingMetricRelabeling(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item: metricRelabelings) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withMetricRelabelings(List<RelabelConfig> metricRelabelings) {
        if (this.metricRelabelings != null) { _visitables.get("metricRelabelings").removeAll(this.metricRelabelings);}
        if (metricRelabelings != null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>(); for (RelabelConfig item : metricRelabelings){this.addToMetricRelabelings(item);}} else { this.metricRelabelings = null;} return (A) this;
    }

    public A withMetricRelabelings(RelabelConfig... metricRelabelings) {
        if (this.metricRelabelings != null) {this.metricRelabelings.clear();}
        if (metricRelabelings != null) {for (RelabelConfig item :metricRelabelings){ this.addToMetricRelabelings(item);}} return (A) this;
    }

    public Boolean hasMetricRelabelings() {
        return metricRelabelings != null && !metricRelabelings.isEmpty();
    }

    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabeling() {
        return new MetricRelabelingsNestedImpl();
    }

    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabelingLike(RelabelConfig item) {
        return new MetricRelabelingsNestedImpl(-1, item);
    }

    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> setNewMetricRelabelingLike(int index,RelabelConfig item) {
        return new MetricRelabelingsNestedImpl(index, item);
    }

    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> editMetricRelabeling(int index) {
        if (metricRelabelings.size() <= index) throw new RuntimeException("Can't edit metricRelabelings. Index exceeds size.");
        return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
    }

    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> editFirstMetricRelabeling() {
        if (metricRelabelings.size() == 0) throw new RuntimeException("Can't edit first metricRelabelings. The list is empty.");
        return setNewMetricRelabelingLike(0, buildMetricRelabeling(0));
    }

    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> editLastMetricRelabeling() {
        int index = metricRelabelings.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last metricRelabelings. The list is empty.");
        return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
    }

    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> editMatchingMetricRelabeling(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i=0;i<metricRelabelings.size();i++) { 
        if (predicate.apply(metricRelabelings.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching metricRelabelings. No match found.");
        return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
    }

    public A addToParams(String key,ArrayList<String> value) {
        if(this.params == null && key != null && value != null) { this.params = new LinkedHashMap<String,ArrayList<String>>(); }
        if(key != null && value != null) {this.params.put(key, value);} return (A)this;
    }

    public A addToParams(Map<String,ArrayList<String>> map) {
        if(this.params == null && map != null) { this.params = new LinkedHashMap<String,ArrayList<String>>(); }
        if(map != null) { this.params.putAll(map);} return (A)this;
    }

    public A removeFromParams(String key) {
        if(this.params == null) { return (A) this; }
        if(key != null && this.params != null) {this.params.remove(key);} return (A)this;
    }

    public A removeFromParams(Map<String,ArrayList<String>> map) {
        if(this.params == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.params != null){this.params.remove(key);}}} return (A)this;
    }

    public Map<String,ArrayList<String>> getParams() {
        return this.params;
    }

    public A withParams(Map<String,ArrayList<String>> params) {
        if (params == null) { this.params =  null;} else {this.params = new LinkedHashMap<String,ArrayList<String>>(params);} return (A) this;
    }

    public Boolean hasParams() {
        return this.params != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path=path; return (A) this;
    }

    public Boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(String arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1) {
        return (A)withPath(new String(arg1));
    }

    public String getPort() {
        return this.port;
    }

    public A withPort(String port) {
        this.port=port; return (A) this;
    }

    public Boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(String arg1) {
        return (A)withPort(new String(arg1));
    }

    public A withNewPort(StringBuilder arg1) {
        return (A)withPort(new String(arg1));
    }

    public A withNewPort(StringBuffer arg1) {
        return (A)withPort(new String(arg1));
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl=proxyUrl; return (A) this;
    }

    public Boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public A withNewProxyUrl(String arg1) {
        return (A)withProxyUrl(new String(arg1));
    }

    public A withNewProxyUrl(StringBuilder arg1) {
        return (A)withProxyUrl(new String(arg1));
    }

    public A withNewProxyUrl(StringBuffer arg1) {
        return (A)withProxyUrl(new String(arg1));
    }

    public A addToRelabelings(int index,RelabelConfig item) {
        if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").add(index >= 0 ? index : _visitables.get("relabelings").size(), builder);this.relabelings.add(index >= 0 ? index : relabelings.size(), builder); return (A)this;
    }

    public A setToRelabelings(int index,RelabelConfig item) {
        if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= _visitables.get("relabelings").size()) { _visitables.get("relabelings").add(builder); } else { _visitables.get("relabelings").set(index, builder);}
        if (index < 0 || index >= relabelings.size()) { relabelings.add(builder); } else { relabelings.set(index, builder);}
         return (A)this;
    }

    public A addToRelabelings(RelabelConfig... items) {
        if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
        for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
    }

    public A addAllToRelabelings(Collection<RelabelConfig> items) {
        if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
        for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
    }

    public A removeFromRelabelings(RelabelConfig... items) {
        for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder);if (this.relabelings != null) {this.relabelings.remove(builder);}} return (A)this;
    }

    public A removeAllFromRelabelings(Collection<RelabelConfig> items) {
        for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder);if (this.relabelings != null) {this.relabelings.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRelabelings(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate) {
        if (relabelings == null) return (A) this;
        final Iterator<RelabelConfigBuilder> each = relabelings.iterator();
        final List visitables = _visitables.get("relabelings");
        while (each.hasNext()) {
          RelabelConfigBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRelabelings instead.
 * @return The buildable object.
 */
@Deprecated public List<RelabelConfig> getRelabelings() {
        return build(relabelings);
    }

    public List<RelabelConfig> buildRelabelings() {
        return build(relabelings);
    }

    public RelabelConfig buildRelabeling(int index) {
        return this.relabelings.get(index).build();
    }

    public RelabelConfig buildFirstRelabeling() {
        return this.relabelings.get(0).build();
    }

    public RelabelConfig buildLastRelabeling() {
        return this.relabelings.get(relabelings.size() - 1).build();
    }

    public RelabelConfig buildMatchingRelabeling(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item: relabelings) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRelabeling(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item: relabelings) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRelabelings(List<RelabelConfig> relabelings) {
        if (this.relabelings != null) { _visitables.get("relabelings").removeAll(this.relabelings);}
        if (relabelings != null) {this.relabelings = new ArrayList<RelabelConfigBuilder>(); for (RelabelConfig item : relabelings){this.addToRelabelings(item);}} else { this.relabelings = null;} return (A) this;
    }

    public A withRelabelings(RelabelConfig... relabelings) {
        if (this.relabelings != null) {this.relabelings.clear();}
        if (relabelings != null) {for (RelabelConfig item :relabelings){ this.addToRelabelings(item);}} return (A) this;
    }

    public Boolean hasRelabelings() {
        return relabelings != null && !relabelings.isEmpty();
    }

    public PodMetricsEndpointFluent.RelabelingsNested<A> addNewRelabeling() {
        return new RelabelingsNestedImpl();
    }

    public PodMetricsEndpointFluent.RelabelingsNested<A> addNewRelabelingLike(RelabelConfig item) {
        return new RelabelingsNestedImpl(-1, item);
    }

    public PodMetricsEndpointFluent.RelabelingsNested<A> setNewRelabelingLike(int index,RelabelConfig item) {
        return new RelabelingsNestedImpl(index, item);
    }

    public PodMetricsEndpointFluent.RelabelingsNested<A> editRelabeling(int index) {
        if (relabelings.size() <= index) throw new RuntimeException("Can't edit relabelings. Index exceeds size.");
        return setNewRelabelingLike(index, buildRelabeling(index));
    }

    public PodMetricsEndpointFluent.RelabelingsNested<A> editFirstRelabeling() {
        if (relabelings.size() == 0) throw new RuntimeException("Can't edit first relabelings. The list is empty.");
        return setNewRelabelingLike(0, buildRelabeling(0));
    }

    public PodMetricsEndpointFluent.RelabelingsNested<A> editLastRelabeling() {
        int index = relabelings.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last relabelings. The list is empty.");
        return setNewRelabelingLike(index, buildRelabeling(index));
    }

    public PodMetricsEndpointFluent.RelabelingsNested<A> editMatchingRelabeling(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i=0;i<relabelings.size();i++) { 
        if (predicate.apply(relabelings.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching relabelings. No match found.");
        return setNewRelabelingLike(index, buildRelabeling(index));
    }

    public String getScheme() {
        return this.scheme;
    }

    public A withScheme(String scheme) {
        this.scheme=scheme; return (A) this;
    }

    public Boolean hasScheme() {
        return this.scheme != null;
    }

    public A withNewScheme(String arg1) {
        return (A)withScheme(new String(arg1));
    }

    public A withNewScheme(StringBuilder arg1) {
        return (A)withScheme(new String(arg1));
    }

    public A withNewScheme(StringBuffer arg1) {
        return (A)withScheme(new String(arg1));
    }

    public String getScrapeTimeout() {
        return this.scrapeTimeout;
    }

    public A withScrapeTimeout(String scrapeTimeout) {
        this.scrapeTimeout=scrapeTimeout; return (A) this;
    }

    public Boolean hasScrapeTimeout() {
        return this.scrapeTimeout != null;
    }

    public A withNewScrapeTimeout(String arg1) {
        return (A)withScrapeTimeout(new String(arg1));
    }

    public A withNewScrapeTimeout(StringBuilder arg1) {
        return (A)withScrapeTimeout(new String(arg1));
    }

    public A withNewScrapeTimeout(StringBuffer arg1) {
        return (A)withScrapeTimeout(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTargetPort instead.
 * @return The buildable object.
 */
@Deprecated public IntOrString getTargetPort() {
        return this.targetPort!=null?this.targetPort.build():null;
    }

    public IntOrString buildTargetPort() {
        return this.targetPort!=null?this.targetPort.build():null;
    }

    public A withTargetPort(IntOrString targetPort) {
        _visitables.get("targetPort").remove(this.targetPort);
        if (targetPort!=null){ this.targetPort= new IntOrStringBuilder(targetPort); _visitables.get("targetPort").add(this.targetPort);} return (A) this;
    }

    public Boolean hasTargetPort() {
        return this.targetPort != null;
    }

    public A withNewTargetPort(String strVal) {
        return (A)withTargetPort(new IntOrString(strVal));
    }

    public A withNewTargetPort(Integer intVal) {
        return (A)withTargetPort(new IntOrString(intVal));
    }

    public PodMetricsEndpointFluent.TargetPortNested<A> withNewTargetPort() {
        return new TargetPortNestedImpl();
    }

    public PodMetricsEndpointFluent.TargetPortNested<A> withNewTargetPortLike(IntOrString item) {
        return new TargetPortNestedImpl(item);
    }

    public PodMetricsEndpointFluent.TargetPortNested<A> editTargetPort() {
        return withNewTargetPortLike(getTargetPort());
    }

    public PodMetricsEndpointFluent.TargetPortNested<A> editOrNewTargetPort() {
        return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): new IntOrStringBuilder().build());
    }

    public PodMetricsEndpointFluent.TargetPortNested<A> editOrNewTargetPortLike(IntOrString item) {
        return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodMetricsEndpointFluentImpl that = (PodMetricsEndpointFluentImpl) o;
        if (honorLabels != null ? !honorLabels.equals(that.honorLabels) :that.honorLabels != null) return false;
        if (honorTimestamps != null ? !honorTimestamps.equals(that.honorTimestamps) :that.honorTimestamps != null) return false;
        if (interval != null ? !interval.equals(that.interval) :that.interval != null) return false;
        if (metricRelabelings != null ? !metricRelabelings.equals(that.metricRelabelings) :that.metricRelabelings != null) return false;
        if (params != null ? !params.equals(that.params) :that.params != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (port != null ? !port.equals(that.port) :that.port != null) return false;
        if (proxyUrl != null ? !proxyUrl.equals(that.proxyUrl) :that.proxyUrl != null) return false;
        if (relabelings != null ? !relabelings.equals(that.relabelings) :that.relabelings != null) return false;
        if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
        if (scrapeTimeout != null ? !scrapeTimeout.equals(that.scrapeTimeout) :that.scrapeTimeout != null) return false;
        if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(honorLabels,  honorTimestamps,  interval,  metricRelabelings,  params,  path,  port,  proxyUrl,  relabelings,  scheme,  scrapeTimeout,  targetPort,  super.hashCode());
    }

    public class MetricRelabelingsNestedImpl<N> extends RelabelConfigFluentImpl<PodMetricsEndpointFluent.MetricRelabelingsNested<N>> implements PodMetricsEndpointFluent.MetricRelabelingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RelabelConfigBuilder builder;
        private final int index;

        MetricRelabelingsNestedImpl(int index,RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        MetricRelabelingsNestedImpl() {
            this.index = -1;
            this.builder = new RelabelConfigBuilder(this);
        }

        public N and() {
             return (N) PodMetricsEndpointFluentImpl.this.setToMetricRelabelings(index,builder.build());
        }

        public N endMetricRelabeling() {
             return and();
        }
    }


    public class RelabelingsNestedImpl<N> extends RelabelConfigFluentImpl<PodMetricsEndpointFluent.RelabelingsNested<N>> implements PodMetricsEndpointFluent.RelabelingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RelabelConfigBuilder builder;
        private final int index;

        RelabelingsNestedImpl(int index,RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        RelabelingsNestedImpl() {
            this.index = -1;
            this.builder = new RelabelConfigBuilder(this);
        }

        public N and() {
             return (N) PodMetricsEndpointFluentImpl.this.setToRelabelings(index,builder.build());
        }

        public N endRelabeling() {
             return and();
        }
    }


    public class TargetPortNestedImpl<N> extends IntOrStringFluentImpl<PodMetricsEndpointFluent.TargetPortNested<N>> implements PodMetricsEndpointFluent.TargetPortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntOrStringBuilder builder;

        TargetPortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        TargetPortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        public N and() {
             return (N) PodMetricsEndpointFluentImpl.this.withTargetPort(builder.build());
        }

        public N endTargetPort() {
             return and();
        }
    }


}
