package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceMonitorListBuilder extends ServiceMonitorListFluentImpl<ServiceMonitorListBuilder> implements VisitableBuilder<ServiceMonitorList,ServiceMonitorListBuilder> {

    ServiceMonitorListFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceMonitorListBuilder() { 
        this(true);
    }


    public ServiceMonitorListBuilder(Boolean validationEnabled) { 
        this(new ServiceMonitorList(), validationEnabled);
    }


    public ServiceMonitorListBuilder(ServiceMonitorListFluent<?> fluent) { 
        this(fluent, true);
    }


    public ServiceMonitorListBuilder(ServiceMonitorListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ServiceMonitorList(), validationEnabled);
    }


    public ServiceMonitorListBuilder(ServiceMonitorListFluent<?> fluent,ServiceMonitorList instance) { 
        this(fluent, instance, true);
    }


    public ServiceMonitorListBuilder(ServiceMonitorListFluent<?> fluent,ServiceMonitorList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public ServiceMonitorListBuilder(ServiceMonitorList instance) { 
        this(instance,true);
    }


    public ServiceMonitorListBuilder(ServiceMonitorList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public ServiceMonitorList build() {
        ServiceMonitorList buildable = new ServiceMonitorList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceMonitorListBuilder that = (ServiceMonitorListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
