package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RulesAlertBuilder extends RulesAlertFluentImpl<RulesAlertBuilder> implements VisitableBuilder<RulesAlert,RulesAlertBuilder> {

    RulesAlertFluent<?> fluent;
    Boolean validationEnabled;

    public RulesAlertBuilder() { 
        this(true);
    }


    public RulesAlertBuilder(Boolean validationEnabled) { 
        this(new RulesAlert(), validationEnabled);
    }


    public RulesAlertBuilder(RulesAlertFluent<?> fluent) { 
        this(fluent, true);
    }


    public RulesAlertBuilder(RulesAlertFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new RulesAlert(), validationEnabled);
    }


    public RulesAlertBuilder(RulesAlertFluent<?> fluent,RulesAlert instance) { 
        this(fluent, instance, true);
    }


    public RulesAlertBuilder(RulesAlertFluent<?> fluent,RulesAlert instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withForGracePeriod(instance.getForGracePeriod()); 
        fluent.withForOutageTolerance(instance.getForOutageTolerance()); 
        fluent.withResendDelay(instance.getResendDelay()); 
        this.validationEnabled = validationEnabled; 
    }


    public RulesAlertBuilder(RulesAlert instance) { 
        this(instance,true);
    }


    public RulesAlertBuilder(RulesAlert instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withForGracePeriod(instance.getForGracePeriod()); 
        this.withForOutageTolerance(instance.getForOutageTolerance()); 
        this.withResendDelay(instance.getResendDelay()); 
        this.validationEnabled = validationEnabled; 
    }


    public RulesAlert build() {
        RulesAlert buildable = new RulesAlert(fluent.getForGracePeriod(),fluent.getForOutageTolerance(),fluent.getResendDelay());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RulesAlertBuilder that = (RulesAlertBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
