package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class QueueConfigBuilder extends QueueConfigFluentImpl<QueueConfigBuilder> implements VisitableBuilder<QueueConfig,QueueConfigBuilder> {

    QueueConfigFluent<?> fluent;
    Boolean validationEnabled;

    public QueueConfigBuilder() { 
        this(true);
    }


    public QueueConfigBuilder(Boolean validationEnabled) { 
        this(new QueueConfig(), validationEnabled);
    }


    public QueueConfigBuilder(QueueConfigFluent<?> fluent) { 
        this(fluent, true);
    }


    public QueueConfigBuilder(QueueConfigFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new QueueConfig(), validationEnabled);
    }


    public QueueConfigBuilder(QueueConfigFluent<?> fluent,QueueConfig instance) { 
        this(fluent, instance, true);
    }


    public QueueConfigBuilder(QueueConfigFluent<?> fluent,QueueConfig instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withBatchSendDeadline(instance.getBatchSendDeadline()); 
        fluent.withCapacity(instance.getCapacity()); 
        fluent.withMaxBackoff(instance.getMaxBackoff()); 
        fluent.withMaxRetries(instance.getMaxRetries()); 
        fluent.withMaxSamplesPerSend(instance.getMaxSamplesPerSend()); 
        fluent.withMaxShards(instance.getMaxShards()); 
        fluent.withMinBackoff(instance.getMinBackoff()); 
        fluent.withMinShards(instance.getMinShards()); 
        this.validationEnabled = validationEnabled; 
    }


    public QueueConfigBuilder(QueueConfig instance) { 
        this(instance,true);
    }


    public QueueConfigBuilder(QueueConfig instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withBatchSendDeadline(instance.getBatchSendDeadline()); 
        this.withCapacity(instance.getCapacity()); 
        this.withMaxBackoff(instance.getMaxBackoff()); 
        this.withMaxRetries(instance.getMaxRetries()); 
        this.withMaxSamplesPerSend(instance.getMaxSamplesPerSend()); 
        this.withMaxShards(instance.getMaxShards()); 
        this.withMinBackoff(instance.getMinBackoff()); 
        this.withMinShards(instance.getMinShards()); 
        this.validationEnabled = validationEnabled; 
    }


    public QueueConfig build() {
        QueueConfig buildable = new QueueConfig(fluent.getBatchSendDeadline(),fluent.getCapacity(),fluent.getMaxBackoff(),fluent.getMaxRetries(),fluent.getMaxSamplesPerSend(),fluent.getMaxShards(),fluent.getMinBackoff(),fluent.getMinShards());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        QueueConfigBuilder that = (QueueConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
