
package io.fabric8.openshift.api.model.monitoring.v1;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "lookbackDelta",
    "maxConcurrency",
    "maxSamples",
    "timeout"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class QuerySpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("lookbackDelta")
    private String lookbackDelta;
    /**
     * 
     * 
     */
    @JsonProperty("maxConcurrency")
    private Integer maxConcurrency;
    /**
     * 
     * 
     */
    @JsonProperty("maxSamples")
    private Integer maxSamples;
    /**
     * 
     * 
     */
    @JsonProperty("timeout")
    private String timeout;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public QuerySpec() {
    }

    /**
     * 
     * @param maxSamples
     * @param lookbackDelta
     * @param timeout
     * @param maxConcurrency
     */
    public QuerySpec(String lookbackDelta, Integer maxConcurrency, Integer maxSamples, String timeout) {
        this.lookbackDelta = lookbackDelta;
        this.maxConcurrency = maxConcurrency;
        this.maxSamples = maxSamples;
        this.timeout = timeout;
    }

    /**
     * 
     * 
     * @return
     *     The lookbackDelta
     */
    @JsonProperty("lookbackDelta")
    public String getLookbackDelta() {
        return lookbackDelta;
    }

    /**
     * 
     * 
     * @param lookbackDelta
     *     The lookbackDelta
     */
    @JsonProperty("lookbackDelta")
    public void setLookbackDelta(String lookbackDelta) {
        this.lookbackDelta = lookbackDelta;
    }

    /**
     * 
     * 
     * @return
     *     The maxConcurrency
     */
    @JsonProperty("maxConcurrency")
    public Integer getMaxConcurrency() {
        return maxConcurrency;
    }

    /**
     * 
     * 
     * @param maxConcurrency
     *     The maxConcurrency
     */
    @JsonProperty("maxConcurrency")
    public void setMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    /**
     * 
     * 
     * @return
     *     The maxSamples
     */
    @JsonProperty("maxSamples")
    public Integer getMaxSamples() {
        return maxSamples;
    }

    /**
     * 
     * 
     * @param maxSamples
     *     The maxSamples
     */
    @JsonProperty("maxSamples")
    public void setMaxSamples(Integer maxSamples) {
        this.maxSamples = maxSamples;
    }

    /**
     * 
     * 
     * @return
     *     The timeout
     */
    @JsonProperty("timeout")
    public String getTimeout() {
        return timeout;
    }

    /**
     * 
     * 
     * @param timeout
     *     The timeout
     */
    @JsonProperty("timeout")
    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
