package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AlertmanagerListBuilder extends AlertmanagerListFluentImpl<AlertmanagerListBuilder> implements VisitableBuilder<AlertmanagerList,AlertmanagerListBuilder> {

    AlertmanagerListFluent<?> fluent;
    Boolean validationEnabled;

    public AlertmanagerListBuilder() { 
        this(true);
    }


    public AlertmanagerListBuilder(Boolean validationEnabled) { 
        this(new AlertmanagerList(), validationEnabled);
    }


    public AlertmanagerListBuilder(AlertmanagerListFluent<?> fluent) { 
        this(fluent, true);
    }


    public AlertmanagerListBuilder(AlertmanagerListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new AlertmanagerList(), validationEnabled);
    }


    public AlertmanagerListBuilder(AlertmanagerListFluent<?> fluent,AlertmanagerList instance) { 
        this(fluent, instance, true);
    }


    public AlertmanagerListBuilder(AlertmanagerListFluent<?> fluent,AlertmanagerList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public AlertmanagerListBuilder(AlertmanagerList instance) { 
        this(instance,true);
    }


    public AlertmanagerListBuilder(AlertmanagerList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public AlertmanagerList build() {
        AlertmanagerList buildable = new AlertmanagerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AlertmanagerListBuilder that = (AlertmanagerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
