package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class TLSConfigFluentImpl<A extends TLSConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TLSConfigFluent<A> {

    private SecretOrConfigMapBuilder ca;
    private String caFile;
    private SecretOrConfigMapBuilder cert;
    private String certFile;
    private Boolean insecureSkipVerify;
    private String keyFile;
    private SecretKeySelector keySecret;
    private String serverName;

    public TLSConfigFluentImpl() { 
    }


    public TLSConfigFluentImpl(TLSConfig instance) { 
        this.withCa(instance.getCa()); 
        this.withCaFile(instance.getCaFile()); 
        this.withCert(instance.getCert()); 
        this.withCertFile(instance.getCertFile()); 
        this.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
        this.withKeyFile(instance.getKeyFile()); 
        this.withKeySecret(instance.getKeySecret()); 
        this.withServerName(instance.getServerName()); 
    }


    
/**
 * This method has been deprecated, please use method buildCa instead.
 * @return The buildable object.
 */
@Deprecated public SecretOrConfigMap getCa() {
        return this.ca!=null?this.ca.build():null;
    }

    public SecretOrConfigMap buildCa() {
        return this.ca!=null?this.ca.build():null;
    }

    public A withCa(SecretOrConfigMap ca) {
        _visitables.get("ca").remove(this.ca);
        if (ca!=null){ this.ca= new SecretOrConfigMapBuilder(ca); _visitables.get("ca").add(this.ca);} return (A) this;
    }

    public Boolean hasCa() {
        return this.ca != null;
    }

    public TLSConfigFluent.CaNested<A> withNewCa() {
        return new CaNestedImpl();
    }

    public TLSConfigFluent.CaNested<A> withNewCaLike(SecretOrConfigMap item) {
        return new CaNestedImpl(item);
    }

    public TLSConfigFluent.CaNested<A> editCa() {
        return withNewCaLike(getCa());
    }

    public TLSConfigFluent.CaNested<A> editOrNewCa() {
        return withNewCaLike(getCa() != null ? getCa(): new SecretOrConfigMapBuilder().build());
    }

    public TLSConfigFluent.CaNested<A> editOrNewCaLike(SecretOrConfigMap item) {
        return withNewCaLike(getCa() != null ? getCa(): item);
    }

    public String getCaFile() {
        return this.caFile;
    }

    public A withCaFile(String caFile) {
        this.caFile=caFile; return (A) this;
    }

    public Boolean hasCaFile() {
        return this.caFile != null;
    }

    public A withNewCaFile(String arg1) {
        return (A)withCaFile(new String(arg1));
    }

    public A withNewCaFile(StringBuilder arg1) {
        return (A)withCaFile(new String(arg1));
    }

    public A withNewCaFile(StringBuffer arg1) {
        return (A)withCaFile(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildCert instead.
 * @return The buildable object.
 */
@Deprecated public SecretOrConfigMap getCert() {
        return this.cert!=null?this.cert.build():null;
    }

    public SecretOrConfigMap buildCert() {
        return this.cert!=null?this.cert.build():null;
    }

    public A withCert(SecretOrConfigMap cert) {
        _visitables.get("cert").remove(this.cert);
        if (cert!=null){ this.cert= new SecretOrConfigMapBuilder(cert); _visitables.get("cert").add(this.cert);} return (A) this;
    }

    public Boolean hasCert() {
        return this.cert != null;
    }

    public TLSConfigFluent.CertNested<A> withNewCert() {
        return new CertNestedImpl();
    }

    public TLSConfigFluent.CertNested<A> withNewCertLike(SecretOrConfigMap item) {
        return new CertNestedImpl(item);
    }

    public TLSConfigFluent.CertNested<A> editCert() {
        return withNewCertLike(getCert());
    }

    public TLSConfigFluent.CertNested<A> editOrNewCert() {
        return withNewCertLike(getCert() != null ? getCert(): new SecretOrConfigMapBuilder().build());
    }

    public TLSConfigFluent.CertNested<A> editOrNewCertLike(SecretOrConfigMap item) {
        return withNewCertLike(getCert() != null ? getCert(): item);
    }

    public String getCertFile() {
        return this.certFile;
    }

    public A withCertFile(String certFile) {
        this.certFile=certFile; return (A) this;
    }

    public Boolean hasCertFile() {
        return this.certFile != null;
    }

    public A withNewCertFile(String arg1) {
        return (A)withCertFile(new String(arg1));
    }

    public A withNewCertFile(StringBuilder arg1) {
        return (A)withCertFile(new String(arg1));
    }

    public A withNewCertFile(StringBuffer arg1) {
        return (A)withCertFile(new String(arg1));
    }

    public Boolean isInsecureSkipVerify() {
        return this.insecureSkipVerify;
    }

    public A withInsecureSkipVerify(Boolean insecureSkipVerify) {
        this.insecureSkipVerify=insecureSkipVerify; return (A) this;
    }

    public Boolean hasInsecureSkipVerify() {
        return this.insecureSkipVerify != null;
    }

    public A withNewInsecureSkipVerify(String arg1) {
        return (A)withInsecureSkipVerify(new Boolean(arg1));
    }

    public A withNewInsecureSkipVerify(boolean arg1) {
        return (A)withInsecureSkipVerify(new Boolean(arg1));
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public A withKeyFile(String keyFile) {
        this.keyFile=keyFile; return (A) this;
    }

    public Boolean hasKeyFile() {
        return this.keyFile != null;
    }

    public A withNewKeyFile(String arg1) {
        return (A)withKeyFile(new String(arg1));
    }

    public A withNewKeyFile(StringBuilder arg1) {
        return (A)withKeyFile(new String(arg1));
    }

    public A withNewKeyFile(StringBuffer arg1) {
        return (A)withKeyFile(new String(arg1));
    }

    public SecretKeySelector getKeySecret() {
        return this.keySecret;
    }

    public A withKeySecret(SecretKeySelector keySecret) {
        this.keySecret=keySecret; return (A) this;
    }

    public Boolean hasKeySecret() {
        return this.keySecret != null;
    }

    public A withNewKeySecret(String key,String name,Boolean optional) {
        return (A)withKeySecret(new SecretKeySelector(key, name, optional));
    }

    public String getServerName() {
        return this.serverName;
    }

    public A withServerName(String serverName) {
        this.serverName=serverName; return (A) this;
    }

    public Boolean hasServerName() {
        return this.serverName != null;
    }

    public A withNewServerName(String arg1) {
        return (A)withServerName(new String(arg1));
    }

    public A withNewServerName(StringBuilder arg1) {
        return (A)withServerName(new String(arg1));
    }

    public A withNewServerName(StringBuffer arg1) {
        return (A)withServerName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TLSConfigFluentImpl that = (TLSConfigFluentImpl) o;
        if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
        if (caFile != null ? !caFile.equals(that.caFile) :that.caFile != null) return false;
        if (cert != null ? !cert.equals(that.cert) :that.cert != null) return false;
        if (certFile != null ? !certFile.equals(that.certFile) :that.certFile != null) return false;
        if (insecureSkipVerify != null ? !insecureSkipVerify.equals(that.insecureSkipVerify) :that.insecureSkipVerify != null) return false;
        if (keyFile != null ? !keyFile.equals(that.keyFile) :that.keyFile != null) return false;
        if (keySecret != null ? !keySecret.equals(that.keySecret) :that.keySecret != null) return false;
        if (serverName != null ? !serverName.equals(that.serverName) :that.serverName != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ca,  caFile,  cert,  certFile,  insecureSkipVerify,  keyFile,  keySecret,  serverName,  super.hashCode());
    }

    public class CaNestedImpl<N> extends SecretOrConfigMapFluentImpl<TLSConfigFluent.CaNested<N>> implements TLSConfigFluent.CaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretOrConfigMapBuilder builder;

        CaNestedImpl(SecretOrConfigMap item) {
            this.builder = new SecretOrConfigMapBuilder(this, item);
        }

        CaNestedImpl() {
            this.builder = new SecretOrConfigMapBuilder(this);
        }

        public N and() {
             return (N) TLSConfigFluentImpl.this.withCa(builder.build());
        }

        public N endCa() {
             return and();
        }
    }


    public class CertNestedImpl<N> extends SecretOrConfigMapFluentImpl<TLSConfigFluent.CertNested<N>> implements TLSConfigFluent.CertNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretOrConfigMapBuilder builder;

        CertNestedImpl(SecretOrConfigMap item) {
            this.builder = new SecretOrConfigMapBuilder(this, item);
        }

        CertNestedImpl() {
            this.builder = new SecretOrConfigMapBuilder(this);
        }

        public N and() {
             return (N) TLSConfigFluentImpl.this.withCert(builder.build());
        }

        public N endCert() {
             return and();
        }
    }


}
