package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import java.lang.Integer;
import java.lang.StringBuffer;

public class AlertmanagerSpecFluentImpl<A extends AlertmanagerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AlertmanagerSpecFluent<A> {

    private List<String> additionalPeers = new ArrayList<String>();
    private Affinity affinity;
    private String baseImage;
    private String clusterAdvertiseAddress;
    private List<String> configMaps = new ArrayList<String>();
    private String configSecret;
    private List<ContainerBuilder> containers =  new ArrayList<ContainerBuilder>();
    private String externalUrl;
    private String image;
    private List<LocalObjectReferenceBuilder> imagePullSecrets =  new ArrayList<LocalObjectReferenceBuilder>();
    private List<ContainerBuilder> initContainers =  new ArrayList<ContainerBuilder>();
    private Boolean listenLocal;
    private String logFormat;
    private String logLevel;
    private Map<String,String> nodeSelector;
    private Boolean paused;
    private EmbeddedObjectMetadataBuilder podMetadata;
    private String portName;
    private String priorityClassName;
    private Integer replicas;
    private ResourceRequirementsBuilder resources;
    private String retention;
    private String routePrefix;
    private List<String> secrets = new ArrayList<String>();
    private PodSecurityContext securityContext;
    private String serviceAccountName;
    private String sha;
    private StorageSpecBuilder storage;
    private String tag;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private String version;
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    private List<Volume> volumes = new ArrayList<Volume>();

    public AlertmanagerSpecFluentImpl() { 
    }


    public AlertmanagerSpecFluentImpl(AlertmanagerSpec instance) { 
        this.withAdditionalPeers(instance.getAdditionalPeers()); 
        this.withAffinity(instance.getAffinity()); 
        this.withBaseImage(instance.getBaseImage()); 
        this.withClusterAdvertiseAddress(instance.getClusterAdvertiseAddress()); 
        this.withConfigMaps(instance.getConfigMaps()); 
        this.withConfigSecret(instance.getConfigSecret()); 
        this.withContainers(instance.getContainers()); 
        this.withExternalUrl(instance.getExternalUrl()); 
        this.withImage(instance.getImage()); 
        this.withImagePullSecrets(instance.getImagePullSecrets()); 
        this.withInitContainers(instance.getInitContainers()); 
        this.withListenLocal(instance.getListenLocal()); 
        this.withLogFormat(instance.getLogFormat()); 
        this.withLogLevel(instance.getLogLevel()); 
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withPaused(instance.getPaused()); 
        this.withPodMetadata(instance.getPodMetadata()); 
        this.withPortName(instance.getPortName()); 
        this.withPriorityClassName(instance.getPriorityClassName()); 
        this.withReplicas(instance.getReplicas()); 
        this.withResources(instance.getResources()); 
        this.withRetention(instance.getRetention()); 
        this.withRoutePrefix(instance.getRoutePrefix()); 
        this.withSecrets(instance.getSecrets()); 
        this.withSecurityContext(instance.getSecurityContext()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSha(instance.getSha()); 
        this.withStorage(instance.getStorage()); 
        this.withTag(instance.getTag()); 
        this.withTolerations(instance.getTolerations()); 
        this.withVersion(instance.getVersion()); 
        this.withVolumeMounts(instance.getVolumeMounts()); 
        this.withVolumes(instance.getVolumes()); 
    }


    public A addToAdditionalPeers(int index,String item) {
        if (this.additionalPeers == null) {this.additionalPeers = new ArrayList<String>();}
        this.additionalPeers.add(index, item);
        return (A)this;
    }

    public A setToAdditionalPeers(int index,String item) {
        if (this.additionalPeers == null) {this.additionalPeers = new ArrayList<String>();}
        this.additionalPeers.set(index, item); return (A)this;
    }

    public A addToAdditionalPeers(String... items) {
        if (this.additionalPeers == null) {this.additionalPeers = new ArrayList<String>();}
        for (String item : items) {this.additionalPeers.add(item);} return (A)this;
    }

    public A addAllToAdditionalPeers(Collection<String> items) {
        if (this.additionalPeers == null) {this.additionalPeers = new ArrayList<String>();}
        for (String item : items) {this.additionalPeers.add(item);} return (A)this;
    }

    public A removeFromAdditionalPeers(String... items) {
        for (String item : items) {if (this.additionalPeers!= null){ this.additionalPeers.remove(item);}} return (A)this;
    }

    public A removeAllFromAdditionalPeers(Collection<String> items) {
        for (String item : items) {if (this.additionalPeers!= null){ this.additionalPeers.remove(item);}} return (A)this;
    }

    public List<String> getAdditionalPeers() {
        return this.additionalPeers;
    }

    public String getAdditionalPeer(int index) {
        return this.additionalPeers.get(index);
    }

    public String getFirstAdditionalPeer() {
        return this.additionalPeers.get(0);
    }

    public String getLastAdditionalPeer() {
        return this.additionalPeers.get(additionalPeers.size() - 1);
    }

    public String getMatchingAdditionalPeer(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: additionalPeers) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAdditionalPeer(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: additionalPeers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAdditionalPeers(List<String> additionalPeers) {
        if (this.additionalPeers != null) { _visitables.get("additionalPeers").removeAll(this.additionalPeers);}
        if (additionalPeers != null) {this.additionalPeers = new ArrayList<String>(); for (String item : additionalPeers){this.addToAdditionalPeers(item);}} else { this.additionalPeers = null;} return (A) this;
    }

    public A withAdditionalPeers(String... additionalPeers) {
        if (this.additionalPeers != null) {this.additionalPeers.clear();}
        if (additionalPeers != null) {for (String item :additionalPeers){ this.addToAdditionalPeers(item);}} return (A) this;
    }

    public Boolean hasAdditionalPeers() {
        return additionalPeers != null && !additionalPeers.isEmpty();
    }

    public A addNewAdditionalPeer(String arg1) {
        return (A)addToAdditionalPeers(new String(arg1));
    }

    public A addNewAdditionalPeer(StringBuilder arg1) {
        return (A)addToAdditionalPeers(new String(arg1));
    }

    public A addNewAdditionalPeer(StringBuffer arg1) {
        return (A)addToAdditionalPeers(new String(arg1));
    }

    public Affinity getAffinity() {
        return this.affinity;
    }

    public A withAffinity(Affinity affinity) {
        this.affinity=affinity; return (A) this;
    }

    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage=baseImage; return (A) this;
    }

    public Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public A withNewBaseImage(String arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(StringBuilder arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(StringBuffer arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public String getClusterAdvertiseAddress() {
        return this.clusterAdvertiseAddress;
    }

    public A withClusterAdvertiseAddress(String clusterAdvertiseAddress) {
        this.clusterAdvertiseAddress=clusterAdvertiseAddress; return (A) this;
    }

    public Boolean hasClusterAdvertiseAddress() {
        return this.clusterAdvertiseAddress != null;
    }

    public A withNewClusterAdvertiseAddress(String arg1) {
        return (A)withClusterAdvertiseAddress(new String(arg1));
    }

    public A withNewClusterAdvertiseAddress(StringBuilder arg1) {
        return (A)withClusterAdvertiseAddress(new String(arg1));
    }

    public A withNewClusterAdvertiseAddress(StringBuffer arg1) {
        return (A)withClusterAdvertiseAddress(new String(arg1));
    }

    public A addToConfigMaps(int index,String item) {
        if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
        this.configMaps.add(index, item);
        return (A)this;
    }

    public A setToConfigMaps(int index,String item) {
        if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
        this.configMaps.set(index, item); return (A)this;
    }

    public A addToConfigMaps(String... items) {
        if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
        for (String item : items) {this.configMaps.add(item);} return (A)this;
    }

    public A addAllToConfigMaps(Collection<String> items) {
        if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
        for (String item : items) {this.configMaps.add(item);} return (A)this;
    }

    public A removeFromConfigMaps(String... items) {
        for (String item : items) {if (this.configMaps!= null){ this.configMaps.remove(item);}} return (A)this;
    }

    public A removeAllFromConfigMaps(Collection<String> items) {
        for (String item : items) {if (this.configMaps!= null){ this.configMaps.remove(item);}} return (A)this;
    }

    public List<String> getConfigMaps() {
        return this.configMaps;
    }

    public String getConfigMap(int index) {
        return this.configMaps.get(index);
    }

    public String getFirstConfigMap() {
        return this.configMaps.get(0);
    }

    public String getLastConfigMap() {
        return this.configMaps.get(configMaps.size() - 1);
    }

    public String getMatchingConfigMap(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: configMaps) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingConfigMap(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: configMaps) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConfigMaps(List<String> configMaps) {
        if (this.configMaps != null) { _visitables.get("configMaps").removeAll(this.configMaps);}
        if (configMaps != null) {this.configMaps = new ArrayList<String>(); for (String item : configMaps){this.addToConfigMaps(item);}} else { this.configMaps = null;} return (A) this;
    }

    public A withConfigMaps(String... configMaps) {
        if (this.configMaps != null) {this.configMaps.clear();}
        if (configMaps != null) {for (String item :configMaps){ this.addToConfigMaps(item);}} return (A) this;
    }

    public Boolean hasConfigMaps() {
        return configMaps != null && !configMaps.isEmpty();
    }

    public A addNewConfigMap(String arg1) {
        return (A)addToConfigMaps(new String(arg1));
    }

    public A addNewConfigMap(StringBuilder arg1) {
        return (A)addToConfigMaps(new String(arg1));
    }

    public A addNewConfigMap(StringBuffer arg1) {
        return (A)addToConfigMaps(new String(arg1));
    }

    public String getConfigSecret() {
        return this.configSecret;
    }

    public A withConfigSecret(String configSecret) {
        this.configSecret=configSecret; return (A) this;
    }

    public Boolean hasConfigSecret() {
        return this.configSecret != null;
    }

    public A withNewConfigSecret(String arg1) {
        return (A)withConfigSecret(new String(arg1));
    }

    public A withNewConfigSecret(StringBuilder arg1) {
        return (A)withConfigSecret(new String(arg1));
    }

    public A withNewConfigSecret(StringBuffer arg1) {
        return (A)withConfigSecret(new String(arg1));
    }

    public A addToContainers(int index,Container item) {
        if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
        ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(index >= 0 ? index : _visitables.get("containers").size(), builder);this.containers.add(index >= 0 ? index : containers.size(), builder); return (A)this;
    }

    public A setToContainers(int index,Container item) {
        if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= _visitables.get("containers").size()) { _visitables.get("containers").add(builder); } else { _visitables.get("containers").set(index, builder);}
        if (index < 0 || index >= containers.size()) { containers.add(builder); } else { containers.set(index, builder);}
         return (A)this;
    }

    public A addToContainers(Container... items) {
        if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
    }

    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
    }

    public A removeFromContainers(Container... items) {
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
    }

    public A removeAllFromContainers(Collection<Container> items) {
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromContainers(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate) {
        if (containers == null) return (A) this;
        final Iterator<ContainerBuilder> each = containers.iterator();
        final List visitables = _visitables.get("containers");
        while (each.hasNext()) {
          ContainerBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Container> getContainers() {
        return build(containers);
    }

    public List<Container> buildContainers() {
        return build(containers);
    }

    public Container buildContainer(int index) {
        return this.containers.get(index).build();
    }

    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    public Container buildLastContainer() {
        return this.containers.get(containers.size() - 1).build();
    }

    public Container buildMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item: containers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item: containers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withContainers(List<Container> containers) {
        if (this.containers != null) { _visitables.get("containers").removeAll(this.containers);}
        if (containers != null) {this.containers = new ArrayList<ContainerBuilder>(); for (Container item : containers){this.addToContainers(item);}} else { this.containers = null;} return (A) this;
    }

    public A withContainers(Container... containers) {
        if (this.containers != null) {this.containers.clear();}
        if (containers != null) {for (Container item :containers){ this.addToContainers(item);}} return (A) this;
    }

    public Boolean hasContainers() {
        return containers != null && !containers.isEmpty();
    }

    public AlertmanagerSpecFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    public AlertmanagerSpecFluent.ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNestedImpl(-1, item);
    }

    public AlertmanagerSpecFluent.ContainersNested<A> setNewContainerLike(int index,Container item) {
        return new ContainersNestedImpl(index, item);
    }

    public AlertmanagerSpecFluent.ContainersNested<A> editContainer(int index) {
        if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
        return setNewContainerLike(index, buildContainer(index));
    }

    public AlertmanagerSpecFluent.ContainersNested<A> editFirstContainer() {
        if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
        return setNewContainerLike(0, buildContainer(0));
    }

    public AlertmanagerSpecFluent.ContainersNested<A> editLastContainer() {
        int index = containers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
        return setNewContainerLike(index, buildContainer(index));
    }

    public AlertmanagerSpecFluent.ContainersNested<A> editMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i=0;i<containers.size();i++) { 
        if (predicate.apply(containers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
        return setNewContainerLike(index, buildContainer(index));
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public A withExternalUrl(String externalUrl) {
        this.externalUrl=externalUrl; return (A) this;
    }

    public Boolean hasExternalUrl() {
        return this.externalUrl != null;
    }

    public A withNewExternalUrl(String arg1) {
        return (A)withExternalUrl(new String(arg1));
    }

    public A withNewExternalUrl(StringBuilder arg1) {
        return (A)withExternalUrl(new String(arg1));
    }

    public A withNewExternalUrl(StringBuffer arg1) {
        return (A)withExternalUrl(new String(arg1));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public A addToImagePullSecrets(int index,LocalObjectReference item) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(index >= 0 ? index : _visitables.get("imagePullSecrets").size(), builder);this.imagePullSecrets.add(index >= 0 ? index : imagePullSecrets.size(), builder); return (A)this;
    }

    public A setToImagePullSecrets(int index,LocalObjectReference item) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= _visitables.get("imagePullSecrets").size()) { _visitables.get("imagePullSecrets").add(builder); } else { _visitables.get("imagePullSecrets").set(index, builder);}
        if (index < 0 || index >= imagePullSecrets.size()) { imagePullSecrets.add(builder); } else { imagePullSecrets.set(index, builder);}
         return (A)this;
    }

    public A addToImagePullSecrets(LocalObjectReference... items) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
        for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
    }

    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
        for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
    }

    public A removeFromImagePullSecrets(LocalObjectReference... items) {
        for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
    }

    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromImagePullSecrets(io.fabric8.kubernetes.api.builder.Predicate<LocalObjectReferenceBuilder> predicate) {
        if (imagePullSecrets == null) return (A) this;
        final Iterator<LocalObjectReferenceBuilder> each = imagePullSecrets.iterator();
        final List visitables = _visitables.get("imagePullSecrets");
        while (each.hasNext()) {
          LocalObjectReferenceBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildImagePullSecrets instead.
 * @return The buildable object.
 */
@Deprecated public List<LocalObjectReference> getImagePullSecrets() {
        return build(imagePullSecrets);
    }

    public List<LocalObjectReference> buildImagePullSecrets() {
        return build(imagePullSecrets);
    }

    public LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    public LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    public LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
    }

    public LocalObjectReference buildMatchingImagePullSecret(io.fabric8.kubernetes.api.builder.Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingImagePullSecret(io.fabric8.kubernetes.api.builder.Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);}
        if (imagePullSecrets != null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>(); for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
    }

    public A withImagePullSecrets(LocalObjectReference... imagePullSecrets) {
        if (this.imagePullSecrets != null) {this.imagePullSecrets.clear();}
        if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
    }

    public Boolean hasImagePullSecrets() {
        return imagePullSecrets != null && !imagePullSecrets.isEmpty();
    }

    public A addNewImagePullSecret(String name) {
        return (A)addToImagePullSecrets(new LocalObjectReference(name));
    }

    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(-1, item);
    }

    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(index, item);
    }

    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        return setNewImagePullSecretLike(0, buildImagePullSecret(0));
    }

    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = imagePullSecrets.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(io.fabric8.kubernetes.api.builder.Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<imagePullSecrets.size();i++) { 
        if (predicate.apply(imagePullSecrets.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public A addToInitContainers(int index,Container item) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
        ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(index >= 0 ? index : _visitables.get("initContainers").size(), builder);this.initContainers.add(index >= 0 ? index : initContainers.size(), builder); return (A)this;
    }

    public A setToInitContainers(int index,Container item) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= _visitables.get("initContainers").size()) { _visitables.get("initContainers").add(builder); } else { _visitables.get("initContainers").set(index, builder);}
        if (index < 0 || index >= initContainers.size()) { initContainers.add(builder); } else { initContainers.set(index, builder);}
         return (A)this;
    }

    public A addToInitContainers(Container... items) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
    }

    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
    }

    public A removeFromInitContainers(Container... items) {
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
    }

    public A removeAllFromInitContainers(Collection<Container> items) {
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromInitContainers(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate) {
        if (initContainers == null) return (A) this;
        final Iterator<ContainerBuilder> each = initContainers.iterator();
        final List visitables = _visitables.get("initContainers");
        while (each.hasNext()) {
          ContainerBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildInitContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Container> getInitContainers() {
        return build(initContainers);
    }

    public List<Container> buildInitContainers() {
        return build(initContainers);
    }

    public Container buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    public Container buildLastInitContainer() {
        return this.initContainers.get(initContainers.size() - 1).build();
    }

    public Container buildMatchingInitContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item: initContainers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingInitContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item: initContainers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withInitContainers(List<Container> initContainers) {
        if (this.initContainers != null) { _visitables.get("initContainers").removeAll(this.initContainers);}
        if (initContainers != null) {this.initContainers = new ArrayList<ContainerBuilder>(); for (Container item : initContainers){this.addToInitContainers(item);}} else { this.initContainers = null;} return (A) this;
    }

    public A withInitContainers(Container... initContainers) {
        if (this.initContainers != null) {this.initContainers.clear();}
        if (initContainers != null) {for (Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
    }

    public Boolean hasInitContainers() {
        return initContainers != null && !initContainers.isEmpty();
    }

    public AlertmanagerSpecFluent.InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNestedImpl();
    }

    public AlertmanagerSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNestedImpl(-1, item);
    }

    public AlertmanagerSpecFluent.InitContainersNested<A> setNewInitContainerLike(int index,Container item) {
        return new InitContainersNestedImpl(index, item);
    }

    public AlertmanagerSpecFluent.InitContainersNested<A> editInitContainer(int index) {
        if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public AlertmanagerSpecFluent.InitContainersNested<A> editFirstInitContainer() {
        if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        return setNewInitContainerLike(0, buildInitContainer(0));
    }

    public AlertmanagerSpecFluent.InitContainersNested<A> editLastInitContainer() {
        int index = initContainers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public AlertmanagerSpecFluent.InitContainersNested<A> editMatchingInitContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i=0;i<initContainers.size();i++) { 
        if (predicate.apply(initContainers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
        return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public Boolean isListenLocal() {
        return this.listenLocal;
    }

    public A withListenLocal(Boolean listenLocal) {
        this.listenLocal=listenLocal; return (A) this;
    }

    public Boolean hasListenLocal() {
        return this.listenLocal != null;
    }

    public A withNewListenLocal(String arg1) {
        return (A)withListenLocal(new Boolean(arg1));
    }

    public A withNewListenLocal(boolean arg1) {
        return (A)withListenLocal(new Boolean(arg1));
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public A withLogFormat(String logFormat) {
        this.logFormat=logFormat; return (A) this;
    }

    public Boolean hasLogFormat() {
        return this.logFormat != null;
    }

    public A withNewLogFormat(String arg1) {
        return (A)withLogFormat(new String(arg1));
    }

    public A withNewLogFormat(StringBuilder arg1) {
        return (A)withLogFormat(new String(arg1));
    }

    public A withNewLogFormat(StringBuffer arg1) {
        return (A)withLogFormat(new String(arg1));
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel=logLevel; return (A) this;
    }

    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public A withNewLogLevel(String arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(StringBuilder arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(StringBuffer arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A addToNodeSelector(String key,String value) {
        if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
    }

    public A addToNodeSelector(Map<String,String> map) {
        if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
        if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
    }

    public A removeFromNodeSelector(String key) {
        if(this.nodeSelector == null) { return (A) this; }
        if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
    }

    public A removeFromNodeSelector(Map<String,String> map) {
        if(this.nodeSelector == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
    }

    public Map<String,String> getNodeSelector() {
        return this.nodeSelector;
    }

    public A withNodeSelector(Map<String,String> nodeSelector) {
        if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap<String,String>(nodeSelector);} return (A) this;
    }

    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public Boolean isPaused() {
        return this.paused;
    }

    public A withPaused(Boolean paused) {
        this.paused=paused; return (A) this;
    }

    public Boolean hasPaused() {
        return this.paused != null;
    }

    public A withNewPaused(String arg1) {
        return (A)withPaused(new Boolean(arg1));
    }

    public A withNewPaused(boolean arg1) {
        return (A)withPaused(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildPodMetadata instead.
 * @return The buildable object.
 */
@Deprecated public EmbeddedObjectMetadata getPodMetadata() {
        return this.podMetadata!=null?this.podMetadata.build():null;
    }

    public EmbeddedObjectMetadata buildPodMetadata() {
        return this.podMetadata!=null?this.podMetadata.build():null;
    }

    public A withPodMetadata(EmbeddedObjectMetadata podMetadata) {
        _visitables.get("podMetadata").remove(this.podMetadata);
        if (podMetadata!=null){ this.podMetadata= new EmbeddedObjectMetadataBuilder(podMetadata); _visitables.get("podMetadata").add(this.podMetadata);} return (A) this;
    }

    public Boolean hasPodMetadata() {
        return this.podMetadata != null;
    }

    public AlertmanagerSpecFluent.PodMetadataNested<A> withNewPodMetadata() {
        return new PodMetadataNestedImpl();
    }

    public AlertmanagerSpecFluent.PodMetadataNested<A> withNewPodMetadataLike(EmbeddedObjectMetadata item) {
        return new PodMetadataNestedImpl(item);
    }

    public AlertmanagerSpecFluent.PodMetadataNested<A> editPodMetadata() {
        return withNewPodMetadataLike(getPodMetadata());
    }

    public AlertmanagerSpecFluent.PodMetadataNested<A> editOrNewPodMetadata() {
        return withNewPodMetadataLike(getPodMetadata() != null ? getPodMetadata(): new EmbeddedObjectMetadataBuilder().build());
    }

    public AlertmanagerSpecFluent.PodMetadataNested<A> editOrNewPodMetadataLike(EmbeddedObjectMetadata item) {
        return withNewPodMetadataLike(getPodMetadata() != null ? getPodMetadata(): item);
    }

    public String getPortName() {
        return this.portName;
    }

    public A withPortName(String portName) {
        this.portName=portName; return (A) this;
    }

    public Boolean hasPortName() {
        return this.portName != null;
    }

    public A withNewPortName(String arg1) {
        return (A)withPortName(new String(arg1));
    }

    public A withNewPortName(StringBuilder arg1) {
        return (A)withPortName(new String(arg1));
    }

    public A withNewPortName(StringBuffer arg1) {
        return (A)withPortName(new String(arg1));
    }

    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName=priorityClassName; return (A) this;
    }

    public Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    public A withNewPriorityClassName(String arg1) {
        return (A)withPriorityClassName(new String(arg1));
    }

    public A withNewPriorityClassName(StringBuilder arg1) {
        return (A)withPriorityClassName(new String(arg1));
    }

    public A withNewPriorityClassName(StringBuffer arg1) {
        return (A)withPriorityClassName(new String(arg1));
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public ResourceRequirements getResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public ResourceRequirements buildResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public A withResources(ResourceRequirements resources) {
        _visitables.get("resources").remove(this.resources);
        if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
    }

    public Boolean hasResources() {
        return this.resources != null;
    }

    public AlertmanagerSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    public AlertmanagerSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    public AlertmanagerSpecFluent.ResourcesNested<A> editResources() {
        return withNewResourcesLike(getResources());
    }

    public AlertmanagerSpecFluent.ResourcesNested<A> editOrNewResources() {
        return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
    }

    public AlertmanagerSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return withNewResourcesLike(getResources() != null ? getResources(): item);
    }

    public String getRetention() {
        return this.retention;
    }

    public A withRetention(String retention) {
        this.retention=retention; return (A) this;
    }

    public Boolean hasRetention() {
        return this.retention != null;
    }

    public A withNewRetention(String arg1) {
        return (A)withRetention(new String(arg1));
    }

    public A withNewRetention(StringBuilder arg1) {
        return (A)withRetention(new String(arg1));
    }

    public A withNewRetention(StringBuffer arg1) {
        return (A)withRetention(new String(arg1));
    }

    public String getRoutePrefix() {
        return this.routePrefix;
    }

    public A withRoutePrefix(String routePrefix) {
        this.routePrefix=routePrefix; return (A) this;
    }

    public Boolean hasRoutePrefix() {
        return this.routePrefix != null;
    }

    public A withNewRoutePrefix(String arg1) {
        return (A)withRoutePrefix(new String(arg1));
    }

    public A withNewRoutePrefix(StringBuilder arg1) {
        return (A)withRoutePrefix(new String(arg1));
    }

    public A withNewRoutePrefix(StringBuffer arg1) {
        return (A)withRoutePrefix(new String(arg1));
    }

    public A addToSecrets(int index,String item) {
        if (this.secrets == null) {this.secrets = new ArrayList<String>();}
        this.secrets.add(index, item);
        return (A)this;
    }

    public A setToSecrets(int index,String item) {
        if (this.secrets == null) {this.secrets = new ArrayList<String>();}
        this.secrets.set(index, item); return (A)this;
    }

    public A addToSecrets(String... items) {
        if (this.secrets == null) {this.secrets = new ArrayList<String>();}
        for (String item : items) {this.secrets.add(item);} return (A)this;
    }

    public A addAllToSecrets(Collection<String> items) {
        if (this.secrets == null) {this.secrets = new ArrayList<String>();}
        for (String item : items) {this.secrets.add(item);} return (A)this;
    }

    public A removeFromSecrets(String... items) {
        for (String item : items) {if (this.secrets!= null){ this.secrets.remove(item);}} return (A)this;
    }

    public A removeAllFromSecrets(Collection<String> items) {
        for (String item : items) {if (this.secrets!= null){ this.secrets.remove(item);}} return (A)this;
    }

    public List<String> getSecrets() {
        return this.secrets;
    }

    public String getSecret(int index) {
        return this.secrets.get(index);
    }

    public String getFirstSecret() {
        return this.secrets.get(0);
    }

    public String getLastSecret() {
        return this.secrets.get(secrets.size() - 1);
    }

    public String getMatchingSecret(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: secrets) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingSecret(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: secrets) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSecrets(List<String> secrets) {
        if (this.secrets != null) { _visitables.get("secrets").removeAll(this.secrets);}
        if (secrets != null) {this.secrets = new ArrayList<String>(); for (String item : secrets){this.addToSecrets(item);}} else { this.secrets = null;} return (A) this;
    }

    public A withSecrets(String... secrets) {
        if (this.secrets != null) {this.secrets.clear();}
        if (secrets != null) {for (String item :secrets){ this.addToSecrets(item);}} return (A) this;
    }

    public Boolean hasSecrets() {
        return secrets != null && !secrets.isEmpty();
    }

    public A addNewSecret(String arg1) {
        return (A)addToSecrets(new String(arg1));
    }

    public A addNewSecret(StringBuilder arg1) {
        return (A)addToSecrets(new String(arg1));
    }

    public A addNewSecret(StringBuffer arg1) {
        return (A)addToSecrets(new String(arg1));
    }

    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public A withSecurityContext(PodSecurityContext securityContext) {
        this.securityContext=securityContext; return (A) this;
    }

    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public String getSha() {
        return this.sha;
    }

    public A withSha(String sha) {
        this.sha=sha; return (A) this;
    }

    public Boolean hasSha() {
        return this.sha != null;
    }

    public A withNewSha(String arg1) {
        return (A)withSha(new String(arg1));
    }

    public A withNewSha(StringBuilder arg1) {
        return (A)withSha(new String(arg1));
    }

    public A withNewSha(StringBuffer arg1) {
        return (A)withSha(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildStorage instead.
 * @return The buildable object.
 */
@Deprecated public StorageSpec getStorage() {
        return this.storage!=null?this.storage.build():null;
    }

    public StorageSpec buildStorage() {
        return this.storage!=null?this.storage.build():null;
    }

    public A withStorage(StorageSpec storage) {
        _visitables.get("storage").remove(this.storage);
        if (storage!=null){ this.storage= new StorageSpecBuilder(storage); _visitables.get("storage").add(this.storage);} return (A) this;
    }

    public Boolean hasStorage() {
        return this.storage != null;
    }

    public AlertmanagerSpecFluent.StorageNested<A> withNewStorage() {
        return new StorageNestedImpl();
    }

    public AlertmanagerSpecFluent.StorageNested<A> withNewStorageLike(StorageSpec item) {
        return new StorageNestedImpl(item);
    }

    public AlertmanagerSpecFluent.StorageNested<A> editStorage() {
        return withNewStorageLike(getStorage());
    }

    public AlertmanagerSpecFluent.StorageNested<A> editOrNewStorage() {
        return withNewStorageLike(getStorage() != null ? getStorage(): new StorageSpecBuilder().build());
    }

    public AlertmanagerSpecFluent.StorageNested<A> editOrNewStorageLike(StorageSpec item) {
        return withNewStorageLike(getStorage() != null ? getStorage(): item);
    }

    public String getTag() {
        return this.tag;
    }

    public A withTag(String tag) {
        this.tag=tag; return (A) this;
    }

    public Boolean hasTag() {
        return this.tag != null;
    }

    public A withNewTag(String arg1) {
        return (A)withTag(new String(arg1));
    }

    public A withNewTag(StringBuilder arg1) {
        return (A)withTag(new String(arg1));
    }

    public A withNewTag(StringBuffer arg1) {
        return (A)withTag(new String(arg1));
    }

    public A addToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.add(index, item);
        return (A)this;
    }

    public A setToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(Toleration... items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(Toleration... items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
        if (tolerations != null) {this.tolerations = new ArrayList<Toleration>(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(Toleration... tolerations) {
        if (this.tolerations != null) {this.tolerations.clear();}
        if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public Boolean hasTolerations() {
        return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
        return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A addToVolumeMounts(int index,VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        this.volumeMounts.add(index, item);
        return (A)this;
    }

    public A setToVolumeMounts(int index,VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        this.volumeMounts.set(index, item); return (A)this;
    }

    public A addToVolumeMounts(VolumeMount... items) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
    }

    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
    }

    public A removeFromVolumeMounts(VolumeMount... items) {
        for (VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
    }

    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public VolumeMount getVolumeMount(int index) {
        return this.volumeMounts.get(index);
    }

    public VolumeMount getFirstVolumeMount() {
        return this.volumeMounts.get(0);
    }

    public VolumeMount getLastVolumeMount() {
        return this.volumeMounts.get(volumeMounts.size() - 1);
    }

    public VolumeMount getMatchingVolumeMount(io.fabric8.kubernetes.api.builder.Predicate<VolumeMount> predicate) {
        for (VolumeMount item: volumeMounts) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVolumeMount(io.fabric8.kubernetes.api.builder.Predicate<VolumeMount> predicate) {
        for (VolumeMount item: volumeMounts) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) { _visitables.get("volumeMounts").removeAll(this.volumeMounts);}
        if (volumeMounts != null) {this.volumeMounts = new ArrayList<VolumeMount>(); for (VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
    }

    public A withVolumeMounts(VolumeMount... volumeMounts) {
        if (this.volumeMounts != null) {this.volumeMounts.clear();}
        if (volumeMounts != null) {for (VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
    }

    public Boolean hasVolumeMounts() {
        return volumeMounts != null && !volumeMounts.isEmpty();
    }

    public A addToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        this.volumes.add(index, item);
        return (A)this;
    }

    public A setToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        this.volumes.set(index, item); return (A)this;
    }

    public A addToVolumes(Volume... items) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        for (Volume item : items) {this.volumes.add(item);} return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        for (Volume item : items) {this.volumes.add(item);} return (A)this;
    }

    public A removeFromVolumes(Volume... items) {
        for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public List<Volume> getVolumes() {
        return this.volumes;
    }

    public Volume getVolume(int index) {
        return this.volumes.get(index);
    }

    public Volume getFirstVolume() {
        return this.volumes.get(0);
    }

    public Volume getLastVolume() {
        return this.volumes.get(volumes.size() - 1);
    }

    public Volume getMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<Volume> predicate) {
        for (Volume item: volumes) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<Volume> predicate) {
        for (Volume item: volumes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
        if (volumes != null) {this.volumes = new ArrayList<Volume>(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(Volume... volumes) {
        if (this.volumes != null) {this.volumes.clear();}
        if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes() {
        return volumes != null && !volumes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AlertmanagerSpecFluentImpl that = (AlertmanagerSpecFluentImpl) o;
        if (additionalPeers != null ? !additionalPeers.equals(that.additionalPeers) :that.additionalPeers != null) return false;
        if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
        if (baseImage != null ? !baseImage.equals(that.baseImage) :that.baseImage != null) return false;
        if (clusterAdvertiseAddress != null ? !clusterAdvertiseAddress.equals(that.clusterAdvertiseAddress) :that.clusterAdvertiseAddress != null) return false;
        if (configMaps != null ? !configMaps.equals(that.configMaps) :that.configMaps != null) return false;
        if (configSecret != null ? !configSecret.equals(that.configSecret) :that.configSecret != null) return false;
        if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
        if (externalUrl != null ? !externalUrl.equals(that.externalUrl) :that.externalUrl != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
        if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
        if (listenLocal != null ? !listenLocal.equals(that.listenLocal) :that.listenLocal != null) return false;
        if (logFormat != null ? !logFormat.equals(that.logFormat) :that.logFormat != null) return false;
        if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
        if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
        if (paused != null ? !paused.equals(that.paused) :that.paused != null) return false;
        if (podMetadata != null ? !podMetadata.equals(that.podMetadata) :that.podMetadata != null) return false;
        if (portName != null ? !portName.equals(that.portName) :that.portName != null) return false;
        if (priorityClassName != null ? !priorityClassName.equals(that.priorityClassName) :that.priorityClassName != null) return false;
        if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (retention != null ? !retention.equals(that.retention) :that.retention != null) return false;
        if (routePrefix != null ? !routePrefix.equals(that.routePrefix) :that.routePrefix != null) return false;
        if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
        if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        if (sha != null ? !sha.equals(that.sha) :that.sha != null) return false;
        if (storage != null ? !storage.equals(that.storage) :that.storage != null) return false;
        if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
        if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
        if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(additionalPeers,  affinity,  baseImage,  clusterAdvertiseAddress,  configMaps,  configSecret,  containers,  externalUrl,  image,  imagePullSecrets,  initContainers,  listenLocal,  logFormat,  logLevel,  nodeSelector,  paused,  podMetadata,  portName,  priorityClassName,  replicas,  resources,  retention,  routePrefix,  secrets,  securityContext,  serviceAccountName,  sha,  storage,  tag,  tolerations,  version,  volumeMounts,  volumes,  super.hashCode());
    }

    public class ContainersNestedImpl<N> extends ContainerFluentImpl<AlertmanagerSpecFluent.ContainersNested<N>> implements AlertmanagerSpecFluent.ContainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerBuilder builder;
        private final int index;

        ContainersNestedImpl(int index,Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        ContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder(this);
        }

        public N and() {
             return (N) AlertmanagerSpecFluentImpl.this.setToContainers(index,builder.build());
        }

        public N endContainer() {
             return and();
        }
    }


    public class ImagePullSecretsNestedImpl<N> extends LocalObjectReferenceFluentImpl<AlertmanagerSpecFluent.ImagePullSecretsNested<N>> implements AlertmanagerSpecFluent.ImagePullSecretsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LocalObjectReferenceBuilder builder;
        private final int index;

        ImagePullSecretsNestedImpl(int index,LocalObjectReference item) {
            this.index = index;
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        ImagePullSecretsNestedImpl() {
            this.index = -1;
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        public N and() {
             return (N) AlertmanagerSpecFluentImpl.this.setToImagePullSecrets(index,builder.build());
        }

        public N endImagePullSecret() {
             return and();
        }
    }


    public class InitContainersNestedImpl<N> extends ContainerFluentImpl<AlertmanagerSpecFluent.InitContainersNested<N>> implements AlertmanagerSpecFluent.InitContainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerBuilder builder;
        private final int index;

        InitContainersNestedImpl(int index,Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        InitContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder(this);
        }

        public N and() {
             return (N) AlertmanagerSpecFluentImpl.this.setToInitContainers(index,builder.build());
        }

        public N endInitContainer() {
             return and();
        }
    }


    public class PodMetadataNestedImpl<N> extends EmbeddedObjectMetadataFluentImpl<AlertmanagerSpecFluent.PodMetadataNested<N>> implements AlertmanagerSpecFluent.PodMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EmbeddedObjectMetadataBuilder builder;

        PodMetadataNestedImpl(EmbeddedObjectMetadata item) {
            this.builder = new EmbeddedObjectMetadataBuilder(this, item);
        }

        PodMetadataNestedImpl() {
            this.builder = new EmbeddedObjectMetadataBuilder(this);
        }

        public N and() {
             return (N) AlertmanagerSpecFluentImpl.this.withPodMetadata(builder.build());
        }

        public N endPodMetadata() {
             return and();
        }
    }


    public class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<AlertmanagerSpecFluent.ResourcesNested<N>> implements AlertmanagerSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        public N and() {
             return (N) AlertmanagerSpecFluentImpl.this.withResources(builder.build());
        }

        public N endResources() {
             return and();
        }
    }


    public class StorageNestedImpl<N> extends StorageSpecFluentImpl<AlertmanagerSpecFluent.StorageNested<N>> implements AlertmanagerSpecFluent.StorageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StorageSpecBuilder builder;

        StorageNestedImpl(StorageSpec item) {
            this.builder = new StorageSpecBuilder(this, item);
        }

        StorageNestedImpl() {
            this.builder = new StorageSpecBuilder(this);
        }

        public N and() {
             return (N) AlertmanagerSpecFluentImpl.this.withStorage(builder.build());
        }

        public N endStorage() {
             return and();
        }
    }


}
