package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;

public class AlertmanagerFluentImpl<A extends AlertmanagerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AlertmanagerFluent<A> {

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private AlertmanagerSpecBuilder spec;
    private AlertmanagerStatusBuilder status;

    public AlertmanagerFluentImpl() { 
    }


    public AlertmanagerFluentImpl(Alertmanager instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public AlertmanagerFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public AlertmanagerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public AlertmanagerFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public AlertmanagerFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public AlertmanagerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public AlertmanagerSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public AlertmanagerSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(AlertmanagerSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new AlertmanagerSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public AlertmanagerFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public AlertmanagerFluent.SpecNested<A> withNewSpecLike(AlertmanagerSpec item) {
        return new SpecNestedImpl(item);
    }

    public AlertmanagerFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public AlertmanagerFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new AlertmanagerSpecBuilder().build());
    }

    public AlertmanagerFluent.SpecNested<A> editOrNewSpecLike(AlertmanagerSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public AlertmanagerStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public AlertmanagerStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(AlertmanagerStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new AlertmanagerStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public A withNewStatus(Integer availableReplicas,Boolean paused,Integer replicas,Integer unavailableReplicas,Integer updatedReplicas) {
        return (A)withStatus(new AlertmanagerStatus(availableReplicas, paused, replicas, unavailableReplicas, updatedReplicas));
    }

    public AlertmanagerFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public AlertmanagerFluent.StatusNested<A> withNewStatusLike(AlertmanagerStatus item) {
        return new StatusNestedImpl(item);
    }

    public AlertmanagerFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public AlertmanagerFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new AlertmanagerStatusBuilder().build());
    }

    public AlertmanagerFluent.StatusNested<A> editOrNewStatusLike(AlertmanagerStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AlertmanagerFluentImpl that = (AlertmanagerFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<AlertmanagerFluent.MetadataNested<N>> implements AlertmanagerFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        public N and() {
             return (N) AlertmanagerFluentImpl.this.withMetadata(builder.build());
        }

        public N endMetadata() {
             return and();
        }
    }


    public class SpecNestedImpl<N> extends AlertmanagerSpecFluentImpl<AlertmanagerFluent.SpecNested<N>> implements AlertmanagerFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AlertmanagerSpecBuilder builder;

        SpecNestedImpl(AlertmanagerSpec item) {
            this.builder = new AlertmanagerSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new AlertmanagerSpecBuilder(this);
        }

        public N and() {
             return (N) AlertmanagerFluentImpl.this.withSpec(builder.build());
        }

        public N endSpec() {
             return and();
        }
    }


    public class StatusNestedImpl<N> extends AlertmanagerStatusFluentImpl<AlertmanagerFluent.StatusNested<N>> implements AlertmanagerFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AlertmanagerStatusBuilder builder;

        StatusNestedImpl(AlertmanagerStatus item) {
            this.builder = new AlertmanagerStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new AlertmanagerStatusBuilder(this);
        }

        public N and() {
             return (N) AlertmanagerFluentImpl.this.withStatus(builder.build());
        }

        public N endStatus() {
             return and();
        }
    }


}
